/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Test;

public class TestHeaderElement {
    @Test
    public void testConstructor3() throws Exception {
        BasicHeaderElement element = new BasicHeaderElement("name", "value", new NameValuePair[]{new BasicNameValuePair("param1", "value1"), new BasicNameValuePair("param2", "value2")});
        Assert.assertEquals((Object)"name", (Object)element.getName());
        Assert.assertEquals((Object)"value", (Object)element.getValue());
        Assert.assertEquals((long)2L, (long)element.getParameters().length);
        Assert.assertEquals((Object)"value1", (Object)element.getParameterByName("param1").getValue());
        Assert.assertEquals((Object)"value2", (Object)element.getParameterByName("param2").getValue());
    }

    @Test
    public void testConstructor2() throws Exception {
        BasicHeaderElement element = new BasicHeaderElement("name", "value");
        Assert.assertEquals((Object)"name", (Object)element.getName());
        Assert.assertEquals((Object)"value", (Object)element.getValue());
        Assert.assertEquals((long)0L, (long)element.getParameters().length);
    }

    @Test
    public void testInvalidName() {
        try {
            new BasicHeaderElement(null, null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParamByName() throws Exception {
        String s = "name = value; param1 = value1; param2 = value2";
        HeaderElement element = BasicHeaderValueParser.parseHeaderElement((String)"name = value; param1 = value1; param2 = value2", null);
        Assert.assertEquals((Object)"value1", (Object)element.getParameterByName("param1").getValue());
        Assert.assertEquals((Object)"value2", (Object)element.getParameterByName("param2").getValue());
        Assert.assertNull((Object)element.getParameterByName("param3"));
        try {
            element.getParameterByName(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testHashCode() {
        BasicHeaderElement element1 = new BasicHeaderElement("name", "value", new NameValuePair[]{new BasicNameValuePair("param1", "value1"), new BasicNameValuePair("param2", "value2")});
        BasicHeaderElement element2 = new BasicHeaderElement("name", "value", new NameValuePair[]{new BasicNameValuePair("param2", "value2"), new BasicNameValuePair("param1", "value1")});
        BasicHeaderElement element3 = new BasicHeaderElement("name", "value");
        BasicHeaderElement element4 = new BasicHeaderElement("name", "value");
        BasicHeaderElement element5 = new BasicHeaderElement("name", "value", new NameValuePair[]{new BasicNameValuePair("param1", "value1"), new BasicNameValuePair("param2", "value2")});
        Assert.assertTrue((element1.hashCode() != element2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((element1.hashCode() != element3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((element2.hashCode() != element3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((element3.hashCode() == element4.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((element1.hashCode() == element5.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        BasicHeaderElement element1 = new BasicHeaderElement("name", "value", new NameValuePair[]{new BasicNameValuePair("param1", "value1"), new BasicNameValuePair("param2", "value2")});
        BasicHeaderElement element2 = new BasicHeaderElement("name", "value", new NameValuePair[]{new BasicNameValuePair("param2", "value2"), new BasicNameValuePair("param1", "value1")});
        BasicHeaderElement element3 = new BasicHeaderElement("name", "value");
        BasicHeaderElement element4 = new BasicHeaderElement("name", "value");
        BasicHeaderElement element5 = new BasicHeaderElement("name", "value", new NameValuePair[]{new BasicNameValuePair("param1", "value1"), new BasicNameValuePair("param2", "value2")});
        Assert.assertTrue((boolean)element1.equals(element1));
        Assert.assertTrue((!element1.equals(element2) ? 1 : 0) != 0);
        Assert.assertTrue((!element1.equals(element3) ? 1 : 0) != 0);
        Assert.assertTrue((!element2.equals(element3) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)element3.equals(element4));
        Assert.assertTrue((boolean)element1.equals(element5));
        Assert.assertFalse((boolean)element1.equals(null));
        Assert.assertFalse((boolean)element1.equals("name = value; param1 = value1; param2 = value2"));
    }

    @Test
    public void testToString() {
        String s = "name=value; param1=value1; param2=value2";
        HeaderElement element = BasicHeaderValueParser.parseHeaderElement((String)s, null);
        Assert.assertEquals((Object)s, (Object)element.toString());
        s = "name; param1=value1; param2=value2";
        element = BasicHeaderValueParser.parseHeaderElement((String)s, null);
        Assert.assertEquals((Object)s, (Object)element.toString());
    }

    @Test
    public void testCloning() throws Exception {
        BasicHeaderElement orig = new BasicHeaderElement("name", "value", new NameValuePair[]{new BasicNameValuePair("param1", "value1"), new BasicNameValuePair("param2", "value2")});
        BasicHeaderElement clone = (BasicHeaderElement)orig.clone();
        Assert.assertEquals((Object)orig, (Object)clone);
    }
}

