/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.junit.Assert;
import org.junit.Test;

public class TestHeaderGroup {
    @Test
    public void testConstructor() {
        HeaderGroup headergroup = new HeaderGroup();
        Assert.assertNotNull((Object)headergroup.getAllHeaders());
        Assert.assertEquals((long)0L, (long)headergroup.getAllHeaders().length);
    }

    @Test
    public void testClear() {
        HeaderGroup headergroup = new HeaderGroup();
        headergroup.addHeader((Header)new BasicHeader("name", "value"));
        Assert.assertEquals((long)1L, (long)headergroup.getAllHeaders().length);
        headergroup.clear();
        Assert.assertEquals((long)0L, (long)headergroup.getAllHeaders().length);
    }

    @Test
    public void testAddRemoveHeader() {
        HeaderGroup headergroup = new HeaderGroup();
        BasicHeader header = new BasicHeader("name", "value");
        headergroup.addHeader((Header)header);
        headergroup.addHeader(null);
        Assert.assertEquals((long)1L, (long)headergroup.getAllHeaders().length);
        headergroup.removeHeader((Header)header);
        headergroup.removeHeader(null);
        Assert.assertEquals((long)0L, (long)headergroup.getAllHeaders().length);
    }

    @Test
    public void testUpdateHeader() {
        HeaderGroup headergroup = new HeaderGroup();
        BasicHeader header1 = new BasicHeader("name1", "value1");
        BasicHeader header2 = new BasicHeader("name2", "value2");
        BasicHeader header3 = new BasicHeader("name3", "value3");
        headergroup.addHeader((Header)header1);
        headergroup.addHeader((Header)header2);
        headergroup.addHeader((Header)header3);
        headergroup.updateHeader((Header)new BasicHeader("name2", "newvalue"));
        headergroup.updateHeader((Header)new BasicHeader("name4", "value4"));
        headergroup.updateHeader(null);
        Assert.assertEquals((long)4L, (long)headergroup.getAllHeaders().length);
        Assert.assertEquals((Object)"newvalue", (Object)headergroup.getFirstHeader("name2").getValue());
    }

    @Test
    public void testSetHeaders() {
        HeaderGroup headergroup = new HeaderGroup();
        BasicHeader header1 = new BasicHeader("name1", "value1");
        BasicHeader header2 = new BasicHeader("name2", "value2");
        BasicHeader header3 = new BasicHeader("name3", "value3");
        headergroup.addHeader((Header)header1);
        headergroup.setHeaders(new Header[]{header2, header3});
        Assert.assertEquals((long)2L, (long)headergroup.getAllHeaders().length);
        Assert.assertEquals((long)0L, (long)headergroup.getHeaders("name1").length);
        Assert.assertFalse((boolean)headergroup.containsHeader("name1"));
        Assert.assertEquals((long)1L, (long)headergroup.getHeaders("name2").length);
        Assert.assertTrue((boolean)headergroup.containsHeader("name2"));
        Assert.assertEquals((long)1L, (long)headergroup.getHeaders("name3").length);
        Assert.assertTrue((boolean)headergroup.containsHeader("name3"));
        headergroup.setHeaders(null);
        Assert.assertEquals((long)0L, (long)headergroup.getAllHeaders().length);
    }

    @Test
    public void testFirstLastHeaders() {
        HeaderGroup headergroup = new HeaderGroup();
        BasicHeader header1 = new BasicHeader("name", "value1");
        BasicHeader header2 = new BasicHeader("name", "value2");
        BasicHeader header3 = new BasicHeader("name", "value3");
        headergroup.setHeaders(new Header[]{header1, header2, header3});
        Assert.assertNull((Object)headergroup.getFirstHeader("whatever"));
        Assert.assertNull((Object)headergroup.getLastHeader("whatever"));
        Assert.assertEquals((Object)"value1", (Object)headergroup.getFirstHeader("name").getValue());
        Assert.assertEquals((Object)"value3", (Object)headergroup.getLastHeader("name").getValue());
    }

    @Test
    public void testCondensedHeader() {
        HeaderGroup headergroup = new HeaderGroup();
        Assert.assertNull((Object)headergroup.getCondensedHeader("name"));
        BasicHeader header1 = new BasicHeader("name", "value1");
        BasicHeader header2 = new BasicHeader("name", "value2");
        BasicHeader header3 = new BasicHeader("name", "value3");
        headergroup.setHeaders(new Header[]{header1, header2, header3});
        Assert.assertEquals((Object)"value1, value2, value3", (Object)headergroup.getCondensedHeader("name").getValue());
        headergroup.setHeaders(new Header[]{header1});
        Assert.assertEquals((Object)header1, (Object)headergroup.getCondensedHeader("name"));
    }

    @Test
    public void testIterator() {
        HeaderGroup headergroup = new HeaderGroup();
        HeaderIterator i = headergroup.iterator();
        Assert.assertNotNull((Object)i);
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void testHeaderRemove() {
        HeaderGroup headergroup = new HeaderGroup();
        BasicHeader header1 = new BasicHeader("name", "value1");
        BasicHeader header2 = new BasicHeader("name", "value2");
        BasicHeader header3 = new BasicHeader("name", "value3");
        headergroup.setHeaders(new Header[]{header1, header2, header3});
        HeaderIterator i = headergroup.iterator();
        Assert.assertNotNull((Object)i);
        Assert.assertTrue((boolean)i.hasNext());
        i.next();
        Assert.assertTrue((boolean)i.hasNext());
        i.next();
        i.remove();
        Assert.assertEquals((long)2L, (long)headergroup.getAllHeaders().length);
        Assert.assertTrue((boolean)i.hasNext());
        i.next();
        i.remove();
        Assert.assertEquals((long)1L, (long)headergroup.getAllHeaders().length);
        Assert.assertFalse((boolean)i.hasNext());
    }

    @Test
    public void testCloning() throws Exception {
        HeaderGroup orig = new HeaderGroup();
        BasicHeader header1 = new BasicHeader("name", "value1");
        BasicHeader header2 = new BasicHeader("name", "value2");
        BasicHeader header3 = new BasicHeader("name", "value3");
        orig.setHeaders(new Header[]{header1, header2, header3});
        HeaderGroup clone = (HeaderGroup)orig.clone();
        Header[] headers1 = orig.getAllHeaders();
        Header[] headers2 = clone.getAllHeaders();
        Assert.assertNotNull((Object)headers1);
        Assert.assertNotNull((Object)headers2);
        Assert.assertEquals((long)3L, (long)headers2.length);
        Assert.assertEquals((long)headers1.length, (long)headers2.length);
        for (int i = 0; i < headers1.length; ++i) {
            Assert.assertEquals((Object)headers1[i].getName(), (Object)headers2[i].getName());
            Assert.assertEquals((Object)headers1[i].getValue(), (Object)headers2[i].getValue());
        }
    }

    @Test
    public void testSerialization() throws Exception {
        HeaderGroup orig = new HeaderGroup();
        BasicHeader header1 = new BasicHeader("name", "value1");
        BasicHeader header2 = new BasicHeader("name", "value2");
        BasicHeader header3 = new BasicHeader("name", "value3");
        orig.setHeaders(new Header[]{header1, header2, header3});
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        HeaderGroup clone = (HeaderGroup)inStream.readObject();
        Header[] headers1 = orig.getAllHeaders();
        Header[] headers2 = clone.getAllHeaders();
        Assert.assertNotNull((Object)headers1);
        Assert.assertNotNull((Object)headers2);
        Assert.assertEquals((long)headers1.length, (long)headers2.length);
        for (int i = 0; i < headers1.length; ++i) {
            Assert.assertEquals((Object)headers1[i].getName(), (Object)headers2[i].getName());
            Assert.assertEquals((Object)headers1[i].getValue(), (Object)headers2[i].getValue());
        }
    }
}

