/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.BasicStatusLine;
import org.junit.Assert;
import org.junit.Test;

public class TestStatusLine {
    @Test
    public void testConstructor() {
        BasicStatusLine statusline = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)statusline.getProtocolVersion());
        Assert.assertEquals((long)200L, (long)statusline.getStatusCode());
        Assert.assertEquals((Object)"OK", (Object)statusline.getReasonPhrase());
    }

    @Test
    public void testConstructorInvalidInput() {
        try {
            new BasicStatusLine(null, 200, "OK");
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, -1, "OK");
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToString() throws Exception {
        BasicStatusLine statusline = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)statusline.toString());
        statusline = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, null);
        Assert.assertEquals((Object)"HTTP/1.1 200 ", (Object)statusline.toString());
    }

    @Test
    public void testCloning() throws Exception {
        BasicStatusLine orig = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        BasicStatusLine clone = (BasicStatusLine)orig.clone();
        Assert.assertEquals((Object)orig.getReasonPhrase(), (Object)clone.getReasonPhrase());
        Assert.assertEquals((long)orig.getStatusCode(), (long)clone.getStatusCode());
        Assert.assertEquals((Object)orig.getProtocolVersion(), (Object)clone.getProtocolVersion());
    }

    @Test
    public void testSerialization() throws Exception {
        BasicStatusLine orig = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        BasicStatusLine clone = (BasicStatusLine)inStream.readObject();
        Assert.assertEquals((Object)orig.getReasonPhrase(), (Object)clone.getReasonPhrase());
        Assert.assertEquals((long)orig.getStatusCode(), (long)clone.getStatusCode());
        Assert.assertEquals((Object)orig.getProtocolVersion(), (Object)clone.getProtocolVersion());
    }
}

