/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.pool;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpConnection;
import org.apache.http.pool.AbstractConnPool;
import org.apache.http.pool.ConnFactory;
import org.apache.http.pool.PoolEntry;
import org.apache.http.pool.PoolStats;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestConnPool {
    private static final int GRACE_PERIOD = 10000;

    @Test
    public void testEmptyPool() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 10);
        pool.setDefaultMaxPerRoute(5);
        pool.setMaxPerRoute("somehost", 3);
        PoolStats totals = pool.getTotalStats();
        Assert.assertEquals((long)0L, (long)totals.getAvailable());
        Assert.assertEquals((long)0L, (long)totals.getLeased());
        Assert.assertEquals((long)10L, (long)totals.getMax());
        Assert.assertEquals(Collections.emptySet(), (Object)pool.getRoutes());
        PoolStats stats = pool.getStats("somehost");
        Assert.assertEquals((long)0L, (long)stats.getAvailable());
        Assert.assertEquals((long)0L, (long)stats.getLeased());
        Assert.assertEquals((long)3L, (long)stats.getMax());
        Assert.assertEquals((Object)"[leased: []][available: []][pending: []]", (Object)pool.toString());
    }

    @Test
    public void testInvalidConstruction() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        try {
            new LocalConnPool(connFactory, -1, 1);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            new LocalConnPool(connFactory, 1, -1);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLeaseRelease() throws Exception {
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn1.isOpen()).thenReturn((Object)true);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn2.isOpen()).thenReturn((Object)true);
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"somehost"))).thenReturn((Object)conn1);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"otherhost"))).thenReturn((Object)conn2);
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 10);
        Future future1 = pool.lease("somehost", null);
        LocalPoolEntry entry1 = (LocalPoolEntry)((Object)future1.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry1));
        Future future2 = pool.lease("somehost", null);
        LocalPoolEntry entry2 = (LocalPoolEntry)((Object)future2.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry2));
        Future future3 = pool.lease("otherhost", null);
        LocalPoolEntry entry3 = (LocalPoolEntry)((Object)future3.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry3));
        PoolStats totals = pool.getTotalStats();
        Assert.assertEquals((long)0L, (long)totals.getAvailable());
        Assert.assertEquals((long)3L, (long)totals.getLeased());
        LocalPoolEntry entry = (LocalPoolEntry)((Object)future1.get());
        Assert.assertSame((Object)((Object)entry1), (Object)((Object)entry));
        pool.release(entry1, true);
        pool.release(entry2, true);
        pool.release(entry3, false);
        ((HttpConnection)Mockito.verify((Object)conn1, (VerificationMode)Mockito.never())).close();
        ((HttpConnection)Mockito.verify((Object)conn2, (VerificationMode)Mockito.times((int)1))).close();
        totals = pool.getTotalStats();
        Assert.assertEquals((long)2L, (long)totals.getAvailable());
        Assert.assertEquals((long)0L, (long)totals.getLeased());
    }

    @Test
    public void testLeaseIllegal() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 10);
        try {
            pool.lease(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReleaseUnknownEntry() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 10);
        pool.release(new LocalPoolEntry("somehost", (HttpConnection)Mockito.mock(HttpConnection.class)), true);
    }

    @Test
    public void testMaxLimits() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn1.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"somehost"))).thenReturn((Object)conn1);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn2.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"otherhost"))).thenReturn((Object)conn2);
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 10);
        pool.setMaxPerRoute("somehost", 2);
        pool.setMaxPerRoute("otherhost", 1);
        pool.setMaxTotal(3);
        Future future1 = pool.lease("somehost", null);
        GetPoolEntryThread t1 = new GetPoolEntryThread(future1);
        t1.start();
        Future future2 = pool.lease("somehost", null);
        GetPoolEntryThread t2 = new GetPoolEntryThread(future2);
        t2.start();
        Future future3 = pool.lease("otherhost", null);
        GetPoolEntryThread t3 = new GetPoolEntryThread(future3);
        t3.start();
        t1.join(10000L);
        Assert.assertTrue((boolean)future1.isDone());
        LocalPoolEntry entry1 = t1.getEntry();
        Assert.assertNotNull((Object)((Object)entry1));
        t2.join(10000L);
        Assert.assertTrue((boolean)future2.isDone());
        LocalPoolEntry entry2 = t2.getEntry();
        Assert.assertNotNull((Object)((Object)entry2));
        t3.join(10000L);
        Assert.assertTrue((boolean)future3.isDone());
        LocalPoolEntry entry3 = t3.getEntry();
        Assert.assertNotNull((Object)((Object)entry3));
        pool.release(entry1, true);
        pool.release(entry2, true);
        pool.release(entry3, true);
        PoolStats totals = pool.getTotalStats();
        Assert.assertEquals((long)3L, (long)totals.getAvailable());
        Assert.assertEquals((long)0L, (long)totals.getLeased());
        Future future4 = pool.lease("somehost", null);
        GetPoolEntryThread t4 = new GetPoolEntryThread(future4);
        t4.start();
        Future future5 = pool.lease("somehost", null);
        GetPoolEntryThread t5 = new GetPoolEntryThread(future5);
        t5.start();
        Future future6 = pool.lease("otherhost", null);
        GetPoolEntryThread t6 = new GetPoolEntryThread(future6);
        t6.start();
        t4.join(10000L);
        Assert.assertTrue((boolean)future4.isDone());
        LocalPoolEntry entry4 = t4.getEntry();
        Assert.assertNotNull((Object)((Object)entry4));
        t5.join(10000L);
        Assert.assertTrue((boolean)future5.isDone());
        LocalPoolEntry entry5 = t5.getEntry();
        Assert.assertNotNull((Object)((Object)entry5));
        t6.join(10000L);
        Assert.assertTrue((boolean)future6.isDone());
        LocalPoolEntry entry6 = t6.getEntry();
        Assert.assertNotNull((Object)((Object)entry6));
        Future future7 = pool.lease("somehost", null);
        GetPoolEntryThread t7 = new GetPoolEntryThread(future7);
        t7.start();
        Future future8 = pool.lease("somehost", null);
        GetPoolEntryThread t8 = new GetPoolEntryThread(future8);
        t8.start();
        Future future9 = pool.lease("otherhost", null);
        GetPoolEntryThread t9 = new GetPoolEntryThread(future9);
        t9.start();
        Assert.assertFalse((boolean)t7.isDone());
        Assert.assertFalse((boolean)t8.isDone());
        Assert.assertFalse((boolean)t9.isDone());
        ((LocalConnFactory)Mockito.verify((Object)connFactory, (VerificationMode)Mockito.times((int)3))).create(Matchers.any(String.class));
        pool.release(entry4, true);
        pool.release(entry5, false);
        pool.release(entry6, true);
        t7.join();
        Assert.assertTrue((boolean)future7.isDone());
        t8.join();
        Assert.assertTrue((boolean)future8.isDone());
        t9.join();
        Assert.assertTrue((boolean)future9.isDone());
        ((LocalConnFactory)Mockito.verify((Object)connFactory, (VerificationMode)Mockito.times((int)4))).create(Matchers.any(String.class));
    }

    @Test
    public void testConnectionRedistributionOnTotalMaxLimit() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn1.isOpen()).thenReturn((Object)true);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn2.isOpen()).thenReturn((Object)true);
        HttpConnection conn3 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn3.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"somehost"))).thenReturn((Object)conn1, (Object[])new HttpConnection[]{conn2, conn3});
        HttpConnection conn4 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn4.isOpen()).thenReturn((Object)true);
        HttpConnection conn5 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn5.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"otherhost"))).thenReturn((Object)conn4, (Object[])new HttpConnection[]{conn5});
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 10);
        pool.setMaxPerRoute("somehost", 2);
        pool.setMaxPerRoute("otherhost", 2);
        pool.setMaxTotal(2);
        Future future1 = pool.lease("somehost", null);
        GetPoolEntryThread t1 = new GetPoolEntryThread(future1);
        t1.start();
        Future future2 = pool.lease("somehost", null);
        GetPoolEntryThread t2 = new GetPoolEntryThread(future2);
        t2.start();
        t1.join(10000L);
        Assert.assertTrue((boolean)future1.isDone());
        LocalPoolEntry entry1 = t1.getEntry();
        Assert.assertNotNull((Object)((Object)entry1));
        t2.join(10000L);
        Assert.assertTrue((boolean)future2.isDone());
        LocalPoolEntry entry2 = t2.getEntry();
        Assert.assertNotNull((Object)((Object)entry2));
        Future future3 = pool.lease("otherhost", null);
        GetPoolEntryThread t3 = new GetPoolEntryThread(future3);
        t3.start();
        Future future4 = pool.lease("otherhost", null);
        GetPoolEntryThread t4 = new GetPoolEntryThread(future4);
        t4.start();
        Assert.assertFalse((boolean)t3.isDone());
        Assert.assertFalse((boolean)t4.isDone());
        ((LocalConnFactory)Mockito.verify((Object)connFactory, (VerificationMode)Mockito.times((int)2))).create(Matchers.eq((Object)"somehost"));
        ((LocalConnFactory)Mockito.verify((Object)connFactory, (VerificationMode)Mockito.never())).create(Matchers.eq((Object)"otherhost"));
        PoolStats totals = pool.getTotalStats();
        Assert.assertEquals((long)0L, (long)totals.getAvailable());
        Assert.assertEquals((long)2L, (long)totals.getLeased());
        pool.release(entry1, true);
        pool.release(entry2, true);
        t3.join(10000L);
        Assert.assertTrue((boolean)future3.isDone());
        LocalPoolEntry entry3 = t3.getEntry();
        Assert.assertNotNull((Object)((Object)entry3));
        t4.join(10000L);
        Assert.assertTrue((boolean)future4.isDone());
        LocalPoolEntry entry4 = t4.getEntry();
        Assert.assertNotNull((Object)((Object)entry4));
        ((LocalConnFactory)Mockito.verify((Object)connFactory, (VerificationMode)Mockito.times((int)2))).create(Matchers.eq((Object)"somehost"));
        ((LocalConnFactory)Mockito.verify((Object)connFactory, (VerificationMode)Mockito.times((int)2))).create(Matchers.eq((Object)"otherhost"));
        totals = pool.getTotalStats();
        Assert.assertEquals((long)0L, (long)totals.getAvailable());
        Assert.assertEquals((long)2L, (long)totals.getLeased());
        Future future5 = pool.lease("somehost", null);
        GetPoolEntryThread t5 = new GetPoolEntryThread(future5);
        t5.start();
        Future future6 = pool.lease("otherhost", null);
        GetPoolEntryThread t6 = new GetPoolEntryThread(future6);
        t6.start();
        pool.release(entry3, true);
        pool.release(entry4, true);
        t5.join(10000L);
        Assert.assertTrue((boolean)future5.isDone());
        LocalPoolEntry entry5 = t5.getEntry();
        Assert.assertNotNull((Object)((Object)entry5));
        t6.join(10000L);
        Assert.assertTrue((boolean)future6.isDone());
        LocalPoolEntry entry6 = t6.getEntry();
        Assert.assertNotNull((Object)((Object)entry6));
        ((LocalConnFactory)Mockito.verify((Object)connFactory, (VerificationMode)Mockito.times((int)3))).create(Matchers.eq((Object)"somehost"));
        ((LocalConnFactory)Mockito.verify((Object)connFactory, (VerificationMode)Mockito.times((int)2))).create(Matchers.eq((Object)"otherhost"));
        totals = pool.getTotalStats();
        Assert.assertEquals((long)0L, (long)totals.getAvailable());
        Assert.assertEquals((long)2L, (long)totals.getLeased());
        pool.release(entry5, true);
        pool.release(entry6, true);
        totals = pool.getTotalStats();
        Assert.assertEquals((long)2L, (long)totals.getAvailable());
        Assert.assertEquals((long)0L, (long)totals.getLeased());
    }

    @Test
    public void testStatefulConnectionRedistributionOnPerRouteMaxLimit() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn1.isOpen()).thenReturn((Object)true);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn2.isOpen()).thenReturn((Object)true);
        HttpConnection conn3 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn3.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"somehost"))).thenReturn((Object)conn1, (Object[])new HttpConnection[]{conn2, conn3});
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 10);
        pool.setMaxPerRoute("somehost", 2);
        pool.setMaxTotal(2);
        Future future1 = pool.lease("somehost", null);
        GetPoolEntryThread t1 = new GetPoolEntryThread(future1);
        t1.start();
        t1.join(10000L);
        Assert.assertTrue((boolean)future1.isDone());
        LocalPoolEntry entry1 = t1.getEntry();
        Assert.assertNotNull((Object)((Object)entry1));
        Future future2 = pool.lease("somehost", null);
        GetPoolEntryThread t2 = new GetPoolEntryThread(future2);
        t2.start();
        t2.join(10000L);
        Assert.assertTrue((boolean)future2.isDone());
        LocalPoolEntry entry2 = t2.getEntry();
        Assert.assertNotNull((Object)((Object)entry2));
        PoolStats totals = pool.getTotalStats();
        Assert.assertEquals((long)0L, (long)totals.getAvailable());
        Assert.assertEquals((long)2L, (long)totals.getLeased());
        Assert.assertEquals((long)0L, (long)totals.getPending());
        entry1.setState("some-stuff");
        pool.release(entry1, true);
        entry2.setState("some-stuff");
        pool.release(entry2, true);
        ((LocalConnFactory)Mockito.verify((Object)connFactory, (VerificationMode)Mockito.times((int)2))).create(Matchers.eq((Object)"somehost"));
        Future future3 = pool.lease("somehost", "some-other-stuff");
        GetPoolEntryThread t3 = new GetPoolEntryThread(future3);
        t3.start();
        t3.join(10000L);
        Assert.assertTrue((boolean)future3.isDone());
        LocalPoolEntry entry3 = t3.getEntry();
        Assert.assertNotNull((Object)((Object)entry3));
        ((LocalConnFactory)Mockito.verify((Object)connFactory, (VerificationMode)Mockito.times((int)3))).create(Matchers.eq((Object)"somehost"));
        ((HttpConnection)Mockito.verify((Object)conn1)).close();
        ((HttpConnection)Mockito.verify((Object)conn2, (VerificationMode)Mockito.never())).close();
        totals = pool.getTotalStats();
        Assert.assertEquals((long)1L, (long)totals.getAvailable());
        Assert.assertEquals((long)1L, (long)totals.getLeased());
    }

    @Test
    public void testCreateNewIfExpired() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn1.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"somehost"))).thenReturn((Object)conn1);
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 2);
        Future future1 = pool.lease("somehost", null);
        LocalPoolEntry entry1 = (LocalPoolEntry)((Object)future1.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry1));
        ((LocalConnFactory)Mockito.verify((Object)connFactory, (VerificationMode)Mockito.times((int)1))).create(Matchers.eq((Object)"somehost"));
        entry1.updateExpiry(1L, TimeUnit.MILLISECONDS);
        pool.release(entry1, true);
        Thread.sleep(200L);
        Future future2 = pool.lease("somehost", null);
        LocalPoolEntry entry2 = (LocalPoolEntry)((Object)future2.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry2));
        ((LocalConnFactory)Mockito.verify((Object)connFactory, (VerificationMode)Mockito.times((int)2))).create(Matchers.eq((Object)"somehost"));
        PoolStats totals = pool.getTotalStats();
        Assert.assertEquals((long)0L, (long)totals.getAvailable());
        Assert.assertEquals((long)1L, (long)totals.getLeased());
        Assert.assertEquals(Collections.singleton("somehost"), (Object)pool.getRoutes());
        PoolStats stats = pool.getStats("somehost");
        Assert.assertEquals((long)0L, (long)stats.getAvailable());
        Assert.assertEquals((long)1L, (long)stats.getLeased());
    }

    @Test
    public void testCloseExpired() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn1.isOpen()).thenReturn((Object)Boolean.FALSE);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn2.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"somehost"))).thenReturn((Object)conn1, (Object[])new HttpConnection[]{conn2});
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 2);
        Future future1 = pool.lease("somehost", null);
        LocalPoolEntry entry1 = (LocalPoolEntry)((Object)future1.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry1));
        Future future2 = pool.lease("somehost", null);
        LocalPoolEntry entry2 = (LocalPoolEntry)((Object)future2.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry2));
        entry1.updateExpiry(1L, TimeUnit.MILLISECONDS);
        pool.release(entry1, true);
        Thread.sleep(200L);
        entry2.updateExpiry(1000L, TimeUnit.SECONDS);
        pool.release(entry2, true);
        pool.closeExpired();
        ((HttpConnection)Mockito.verify((Object)conn1)).close();
        ((HttpConnection)Mockito.verify((Object)conn2, (VerificationMode)Mockito.never())).close();
        PoolStats totals = pool.getTotalStats();
        Assert.assertEquals((long)1L, (long)totals.getAvailable());
        Assert.assertEquals((long)0L, (long)totals.getLeased());
        PoolStats stats = pool.getStats("somehost");
        Assert.assertEquals((long)1L, (long)stats.getAvailable());
        Assert.assertEquals((long)0L, (long)stats.getLeased());
    }

    @Test
    public void testLeaseTimeout() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn1.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"somehost"))).thenReturn((Object)conn1);
        LocalConnPool pool = new LocalConnPool(connFactory, 1, 1);
        Future future1 = pool.lease("somehost", null);
        GetPoolEntryThread t1 = new GetPoolEntryThread(future1);
        t1.start();
        t1.join(10000L);
        Assert.assertTrue((boolean)future1.isDone());
        LocalPoolEntry entry1 = t1.getEntry();
        Assert.assertNotNull((Object)((Object)entry1));
        Future future2 = pool.lease("somehost", null);
        GetPoolEntryThread t2 = new GetPoolEntryThread(future2, 50L, TimeUnit.MICROSECONDS);
        t2.start();
        t2.join(10000L);
        Assert.assertTrue((boolean)(t2.getException() instanceof TimeoutException));
        Assert.assertFalse((boolean)future2.isDone());
        Assert.assertFalse((boolean)future2.isCancelled());
    }

    @Test
    public void testLeaseIOException() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        ((LocalConnFactory)Mockito.doThrow((Throwable)new IOException("Oppsie")).when((Object)connFactory)).create("somehost");
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 10);
        Future future1 = pool.lease("somehost", null);
        GetPoolEntryThread t1 = new GetPoolEntryThread(future1);
        t1.start();
        t1.join(10000L);
        Assert.assertTrue((boolean)future1.isDone());
        Assert.assertTrue((boolean)(t1.getException() instanceof ExecutionException));
        Assert.assertTrue((boolean)(t1.getException().getCause() instanceof IOException));
        Assert.assertFalse((boolean)future1.isCancelled());
    }

    @Test
    public void testLeaseCancel() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn1.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"somehost"))).thenReturn((Object)conn1);
        LocalConnPool pool = new LocalConnPool(connFactory, 1, 1);
        Future future1 = pool.lease("somehost", null);
        GetPoolEntryThread t1 = new GetPoolEntryThread(future1);
        t1.start();
        t1.join(10000L);
        Assert.assertTrue((boolean)future1.isDone());
        LocalPoolEntry entry1 = t1.getEntry();
        Assert.assertNotNull((Object)((Object)entry1));
        Future future2 = pool.lease("somehost", null);
        GetPoolEntryThread t2 = new GetPoolEntryThread(future2);
        t2.start();
        Thread.sleep(5L);
        Assert.assertFalse((boolean)future2.isDone());
        Assert.assertFalse((boolean)future2.isCancelled());
        future2.cancel(true);
        t2.join(10000L);
        Assert.assertTrue((boolean)future2.isDone());
        Assert.assertTrue((boolean)future2.isCancelled());
        future2.cancel(true);
        future2.cancel(true);
    }

    @Test
    public void testCloseIdle() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn1.isOpen()).thenReturn((Object)true);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn2.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"somehost"))).thenReturn((Object)conn1, (Object[])new HttpConnection[]{conn2});
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 2);
        Future future1 = pool.lease("somehost", null);
        LocalPoolEntry entry1 = (LocalPoolEntry)((Object)future1.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry1));
        Future future2 = pool.lease("somehost", null);
        LocalPoolEntry entry2 = (LocalPoolEntry)((Object)future2.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry2));
        entry1.updateExpiry(0L, TimeUnit.MILLISECONDS);
        pool.release(entry1, true);
        Thread.sleep(200L);
        entry2.updateExpiry(0L, TimeUnit.MILLISECONDS);
        pool.release(entry2, true);
        pool.closeIdle(50L, TimeUnit.MILLISECONDS);
        ((HttpConnection)Mockito.verify((Object)conn1)).close();
        ((HttpConnection)Mockito.verify((Object)conn2, (VerificationMode)Mockito.never())).close();
        PoolStats totals = pool.getTotalStats();
        Assert.assertEquals((long)1L, (long)totals.getAvailable());
        Assert.assertEquals((long)0L, (long)totals.getLeased());
        PoolStats stats = pool.getStats("somehost");
        Assert.assertEquals((long)1L, (long)stats.getAvailable());
        Assert.assertEquals((long)0L, (long)stats.getLeased());
        pool.closeIdle(-1L, TimeUnit.MILLISECONDS);
        ((HttpConnection)Mockito.verify((Object)conn2)).close();
        totals = pool.getTotalStats();
        Assert.assertEquals((long)0L, (long)totals.getAvailable());
        Assert.assertEquals((long)0L, (long)totals.getLeased());
        stats = pool.getStats("somehost");
        Assert.assertEquals((long)0L, (long)stats.getAvailable());
        Assert.assertEquals((long)0L, (long)stats.getLeased());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCloseIdleInvalid() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 2);
        pool.closeIdle(50L, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetStatsInvalid() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 2);
        pool.getStats(null);
    }

    @Test
    public void testSetMaxInvalid() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 2);
        try {
            pool.setMaxTotal(-1);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            pool.setMaxPerRoute(null, 1);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            pool.setDefaultMaxPerRoute(-1);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetMaxPerRoute() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 2);
        pool.setMaxPerRoute("somehost", 1);
        Assert.assertEquals((long)1L, (long)pool.getMaxPerRoute("somehost"));
        pool.setMaxPerRoute("somehost", 0);
        Assert.assertEquals((long)0L, (long)pool.getMaxPerRoute("somehost"));
        pool.setMaxPerRoute("somehost", -1);
        Assert.assertEquals((long)2L, (long)pool.getMaxPerRoute("somehost"));
    }

    @Test
    public void testShutdown() throws Exception {
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn1.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"somehost"))).thenReturn((Object)conn1);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn2.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"otherhost"))).thenReturn((Object)conn2);
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 2);
        Future future1 = pool.lease("somehost", null);
        LocalPoolEntry entry1 = (LocalPoolEntry)((Object)future1.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry1));
        Future future2 = pool.lease("otherhost", null);
        LocalPoolEntry entry2 = (LocalPoolEntry)((Object)future2.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry2));
        pool.release(entry2, true);
        PoolStats totals = pool.getTotalStats();
        Assert.assertEquals((long)1L, (long)totals.getAvailable());
        Assert.assertEquals((long)1L, (long)totals.getLeased());
        pool.shutdown();
        Assert.assertTrue((boolean)pool.isShutdown());
        pool.shutdown();
        pool.shutdown();
        ((HttpConnection)Mockito.verify((Object)conn1, (VerificationMode)Mockito.atLeastOnce())).close();
        ((HttpConnection)Mockito.verify((Object)conn2, (VerificationMode)Mockito.atLeastOnce())).close();
        try {
            pool.lease("somehost", null);
            Assert.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        pool.release(new LocalPoolEntry("somehost", (HttpConnection)Mockito.mock(HttpConnection.class)), true);
    }

    @Test
    public void testValidateConnectionNotStale() throws Exception {
        HttpConnection conn = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)conn.isStale()).thenReturn((Object)false);
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"somehost"))).thenReturn((Object)conn);
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 10);
        pool.setValidateAfterInactivity(100);
        Future future1 = pool.lease("somehost", null);
        LocalPoolEntry entry1 = (LocalPoolEntry)((Object)future1.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry1));
        pool.release(entry1, true);
        Thread.sleep(150L);
        Future future2 = pool.lease("somehost", null);
        LocalPoolEntry entry2 = (LocalPoolEntry)((Object)future2.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry2));
        Assert.assertSame((Object)((Object)entry1), (Object)((Object)entry2));
        ((HttpConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)1))).isStale();
    }

    @Test
    public void testValidateConnectionStale() throws Exception {
        HttpConnection conn = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)conn.isStale()).thenReturn((Object)false);
        LocalConnFactory connFactory = (LocalConnFactory)Mockito.mock(LocalConnFactory.class);
        Mockito.when((Object)connFactory.create(Matchers.eq((Object)"somehost"))).thenReturn((Object)conn);
        LocalConnPool pool = new LocalConnPool(connFactory, 2, 10);
        pool.setValidateAfterInactivity(5);
        Future future1 = pool.lease("somehost", null);
        LocalPoolEntry entry1 = (LocalPoolEntry)((Object)future1.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry1));
        pool.release(entry1, true);
        Thread.sleep(10L);
        ((LocalConnFactory)Mockito.verify((Object)connFactory, (VerificationMode)Mockito.times((int)1))).create("somehost");
        Mockito.when((Object)conn.isStale()).thenReturn((Object)true);
        Future future2 = pool.lease("somehost", null);
        LocalPoolEntry entry2 = (LocalPoolEntry)((Object)future2.get(1L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)((Object)entry2));
        Assert.assertNotSame((Object)((Object)entry1), (Object)((Object)entry2));
        ((HttpConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)1))).isStale();
        ((HttpConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)1))).close();
        ((LocalConnFactory)Mockito.verify((Object)connFactory, (VerificationMode)Mockito.times((int)2))).create("somehost");
    }

    static class GetPoolEntryThread
    extends Thread {
        private final Future<LocalPoolEntry> future;
        private final long time;
        private final TimeUnit timeUnit;
        private volatile LocalPoolEntry entry;
        private volatile Exception ex;

        GetPoolEntryThread(Future<LocalPoolEntry> future, long time, TimeUnit timeUnit) {
            this.future = future;
            this.time = time;
            this.timeUnit = timeUnit;
            this.setDaemon(true);
        }

        GetPoolEntryThread(Future<LocalPoolEntry> future) {
            this(future, 1000L, TimeUnit.SECONDS);
        }

        @Override
        public void run() {
            try {
                this.entry = this.future.get(this.time, this.timeUnit);
            }
            catch (Exception ex) {
                this.ex = ex;
            }
        }

        public boolean isDone() {
            return this.future.isDone();
        }

        public LocalPoolEntry getEntry() {
            return this.entry;
        }

        public Exception getException() {
            return this.ex;
        }
    }

    static class LocalConnPool
    extends AbstractConnPool<String, HttpConnection, LocalPoolEntry> {
        public LocalConnPool(ConnFactory<String, HttpConnection> connFactory, int defaultMaxPerRoute, int maxTotal) {
            super(connFactory, defaultMaxPerRoute, maxTotal);
        }

        protected LocalPoolEntry createEntry(String route, HttpConnection conn) {
            return new LocalPoolEntry(route, conn);
        }

        protected boolean validate(LocalPoolEntry entry) {
            return !((HttpConnection)entry.getConnection()).isStale();
        }
    }

    static class LocalPoolEntry
    extends PoolEntry<String, HttpConnection> {
        private boolean closed;

        public LocalPoolEntry(String route, HttpConnection conn) {
            super(null, (Object)route, (Object)conn);
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                ((HttpConnection)this.getConnection()).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    static interface LocalConnFactory
    extends ConnFactory<String, HttpConnection> {
    }
}

