/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.pool;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpConnection;
import org.apache.http.pool.PoolEntry;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestPoolEntry {
    @Test
    public void testBasics() throws Exception {
        MockPoolEntry entry1 = new MockPoolEntry("route1", 10L, TimeUnit.MILLISECONDS);
        long now = System.currentTimeMillis();
        Assert.assertEquals((Object)"route1", (Object)entry1.getRoute());
        Assert.assertTrue((now >= entry1.getCreated() ? 1 : 0) != 0);
        Assert.assertEquals((long)entry1.getValidityDeadline(), (long)entry1.getExpiry());
        Assert.assertEquals((long)(entry1.getCreated() + 10L), (long)entry1.getValidityDeadline());
    }

    @Test
    public void testInvalidConstruction() throws Exception {
        try {
            new MockPoolEntry(null, (HttpConnection)Mockito.mock(HttpConnection.class), 0L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            new MockPoolEntry("stuff", null, 0L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            new MockPoolEntry("stuff", (HttpConnection)Mockito.mock(HttpConnection.class), 0L, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testValidInfinitely() throws Exception {
        MockPoolEntry entry1 = new MockPoolEntry("route1", 0L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)entry1.getValidityDeadline());
        Assert.assertEquals((long)entry1.getValidityDeadline(), (long)entry1.getExpiry());
    }

    @Test
    public void testExpiry() throws Exception {
        MockPoolEntry entry1 = new MockPoolEntry("route1", 0L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)entry1.getExpiry());
        entry1.updateExpiry(50L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)(entry1.getUpdated() + 50L), (long)entry1.getExpiry());
        entry1.updateExpiry(0L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)entry1.getExpiry());
        MockPoolEntry entry2 = new MockPoolEntry("route1", 100L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)(entry2.getCreated() + 100L), (long)entry2.getExpiry());
        entry2.updateExpiry(150L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)(entry2.getCreated() + 100L), (long)entry2.getExpiry());
        entry2.updateExpiry(50L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)(entry2.getUpdated() + 50L), (long)entry2.getExpiry());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidExpiry() throws Exception {
        MockPoolEntry entry1 = new MockPoolEntry("route1", 0L, TimeUnit.MILLISECONDS);
        entry1.updateExpiry(50L, null);
    }

    @Test
    public void testExpiryDoesNotOverflow() {
        MockPoolEntry entry = new MockPoolEntry("route1", Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)entry.getValidityDeadline(), (long)Long.MAX_VALUE);
    }

    static class MockPoolEntry
    extends PoolEntry<String, HttpConnection> {
        public MockPoolEntry(String route, long timeToLive, TimeUnit timeUnit) {
            super(null, (Object)route, Mockito.mock(HttpConnection.class), timeToLive, timeUnit);
        }

        public MockPoolEntry(String route, HttpConnection conn, long timeToLive, TimeUnit timeUnit) {
            super(null, (Object)route, (Object)conn, timeToLive, timeUnit);
        }

        public void close() {
            try {
                ((HttpConnection)this.getConnection()).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean isClosed() {
            return !((HttpConnection)this.getConnection()).isOpen();
        }
    }
}

