/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;

public class TestHttpExecutionContext {
    @Test
    public void testContextOperations() {
        BasicHttpContext parentContext = new BasicHttpContext(null);
        BasicHttpContext currentContext = new BasicHttpContext((HttpContext)parentContext);
        parentContext.setAttribute("param1", (Object)"1");
        parentContext.setAttribute("param2", (Object)"2");
        currentContext.setAttribute("param3", (Object)"3");
        currentContext.setAttribute("param2", (Object)"4");
        Assert.assertEquals((Object)"1", (Object)parentContext.getAttribute("param1"));
        Assert.assertEquals((Object)"2", (Object)parentContext.getAttribute("param2"));
        Assert.assertEquals(null, (Object)parentContext.getAttribute("param3"));
        Assert.assertEquals((Object)"1", (Object)currentContext.getAttribute("param1"));
        Assert.assertEquals((Object)"4", (Object)currentContext.getAttribute("param2"));
        Assert.assertEquals((Object)"3", (Object)currentContext.getAttribute("param3"));
        Assert.assertEquals(null, (Object)currentContext.getAttribute("param4"));
        currentContext.removeAttribute("param1");
        currentContext.removeAttribute("param2");
        currentContext.removeAttribute("param3");
        currentContext.removeAttribute("param4");
        Assert.assertEquals((Object)"1", (Object)currentContext.getAttribute("param1"));
        Assert.assertEquals((Object)"2", (Object)currentContext.getAttribute("param2"));
        Assert.assertEquals(null, (Object)currentContext.getAttribute("param3"));
        Assert.assertEquals(null, (Object)currentContext.getAttribute("param4"));
    }

    @Test
    public void testEmptyContextOperations() {
        BasicHttpContext currentContext = new BasicHttpContext(null);
        Assert.assertEquals(null, (Object)currentContext.getAttribute("param1"));
        currentContext.removeAttribute("param1");
        Assert.assertEquals(null, (Object)currentContext.getAttribute("param1"));
    }

    @Test
    public void testContextInvalidInput() throws Exception {
        BasicHttpContext currentContext = new BasicHttpContext(null);
        try {
            currentContext.setAttribute(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            currentContext.getAttribute(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            currentContext.removeAttribute(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

