/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import org.apache.http.HttpRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;
import org.apache.http.protocol.UriPatternMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestUriHttpRequestHandlerMapper {
    @Test
    public void testRegisterUnregister() throws Exception {
        HttpRequestHandler h = (HttpRequestHandler)Mockito.mock(HttpRequestHandler.class);
        UriPatternMatcher matcher = (UriPatternMatcher)Mockito.spy((Object)new UriPatternMatcher());
        UriHttpRequestHandlerMapper registry = new UriHttpRequestHandlerMapper(matcher);
        registry.register("/h1", h);
        registry.unregister("/h1");
        ((UriPatternMatcher)Mockito.verify((Object)matcher)).register("/h1", (Object)h);
        ((UriPatternMatcher)Mockito.verify((Object)matcher)).unregister("/h1");
    }

    @Test
    public void testLookup() throws Exception {
        UriPatternMatcher matcher = (UriPatternMatcher)Mockito.spy((Object)new UriPatternMatcher());
        UriHttpRequestHandlerMapper registry = new UriHttpRequestHandlerMapper(matcher);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        registry.lookup((HttpRequest)request);
        registry.unregister("/h1");
        ((UriPatternMatcher)Mockito.verify((Object)matcher)).lookup("/");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterNull() throws Exception {
        UriHttpRequestHandlerMapper registry = new UriHttpRequestHandlerMapper();
        registry.register(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLookupNull() throws Exception {
        UriHttpRequestHandlerMapper registry = new UriHttpRequestHandlerMapper();
        registry.register(null, null);
    }

    @Test
    public void testWildCardMatchingWithQuery() throws Exception {
        HttpRequestHandler h1 = (HttpRequestHandler)Mockito.mock(HttpRequestHandler.class);
        HttpRequestHandler h2 = (HttpRequestHandler)Mockito.mock(HttpRequestHandler.class);
        HttpRequestHandler def = (HttpRequestHandler)Mockito.mock(HttpRequestHandler.class);
        UriPatternMatcher matcher = (UriPatternMatcher)Mockito.spy((Object)new UriPatternMatcher());
        UriHttpRequestHandlerMapper registry = new UriHttpRequestHandlerMapper(matcher);
        registry.register("*", def);
        registry.register("*.view", h1);
        registry.register("*.form", h2);
        HttpRequestHandler h = registry.lookup((HttpRequest)new BasicHttpRequest("GET", "/that.view?param=value"));
        Assert.assertNotNull((Object)h);
        Assert.assertTrue((h1 == h ? 1 : 0) != 0);
        h = registry.lookup((HttpRequest)new BasicHttpRequest("GET", "/that.form?whatever"));
        Assert.assertNotNull((Object)h);
        Assert.assertTrue((h2 == h ? 1 : 0) != 0);
        h = registry.lookup((HttpRequest)new BasicHttpRequest("GET", "/whatever"));
        Assert.assertNotNull((Object)h);
        Assert.assertTrue((def == h ? 1 : 0) != 0);
    }
}

