/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.testserver;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.impl.DefaultBHttpClientConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.testserver.LoggingBHttpClientConnection;

public class HttpClient {
    private final HttpProcessor httpproc;
    private final HttpRequestExecutor httpexecutor;
    private final ConnectionReuseStrategy connStrategy;
    private final HttpCoreContext context;
    private volatile int timeout;

    public HttpClient(HttpProcessor httpproc) {
        this.httpproc = httpproc;
        this.connStrategy = DefaultConnectionReuseStrategy.INSTANCE;
        this.httpexecutor = new HttpRequestExecutor();
        this.context = new HttpCoreContext();
    }

    public HttpClient() {
        this((HttpProcessor)new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent("TEST-CLIENT/1.1"), new RequestExpectContinue(true)}));
    }

    public HttpContext getContext() {
        return this.context;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public DefaultBHttpClientConnection createConnection() {
        return new LoggingBHttpClientConnection(8192);
    }

    public void connect(HttpHost host, DefaultBHttpClientConnection conn) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(host.getHostName(), host.getPort()), this.timeout);
        conn.bind(socket);
        conn.setSocketTimeout(this.timeout);
    }

    public HttpResponse execute(HttpRequest request, HttpHost targetHost, HttpClientConnection conn) throws HttpException, IOException {
        this.context.setTargetHost(targetHost);
        this.httpexecutor.preProcess(request, this.httpproc, (HttpContext)this.context);
        HttpResponse response = this.httpexecutor.execute(request, conn, (HttpContext)this.context);
        this.httpexecutor.postProcess(response, this.httpproc, (HttpContext)this.context);
        return response;
    }

    public boolean keepAlive(HttpResponse response) {
        return this.connStrategy.keepAlive(response, (HttpContext)this.context);
    }
}

