/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.http.util.Args;
import org.junit.Assert;
import org.junit.Test;

public class TestArgs {
    @Test
    public void testArgCheckPass() {
        Args.check((boolean)true, (String)"All is well");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArgCheckFail() {
        Args.check((boolean)false, (String)"Oopsie");
    }

    @Test
    public void testArgNotNullPass() {
        String stuff = "stuff";
        Assert.assertSame((Object)"stuff", (Object)Args.notNull((Object)"stuff", (String)"Stuff"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArgNotNullFail() {
        Args.notNull(null, (String)"Stuff");
    }

    @Test
    public void testArgNotEmptyPass() {
        String stuff = "stuff";
        Assert.assertSame((Object)"stuff", (Object)Args.notEmpty((CharSequence)"stuff", (String)"Stuff"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArgNotEmptyFail1() {
        Args.notEmpty((CharSequence)null, (String)"Stuff");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArgNotEmptyFail2() {
        Args.notEmpty((CharSequence)"", (String)"Stuff");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArgNotBlankFail1() {
        Args.notBlank((CharSequence)null, (String)"Stuff");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArgNotBlankFail2() {
        Args.notBlank((CharSequence)"", (String)"Stuff");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArgNotBlankFail3() {
        Args.notBlank((CharSequence)" \t \n\r", (String)"Stuff");
    }

    @Test
    public void testArgCollectionNotEmptyPass() {
        List<String> list = Arrays.asList("stuff");
        Assert.assertSame(list, (Object)Args.notEmpty(list, (String)"List"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArgCollectionNotEmptyFail1() {
        Args.notEmpty((Collection)null, (String)"List");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testArgCollectionNotEmptyFail2() {
        Args.notEmpty(Collections.emptyList(), (String)"List");
    }

    @Test
    public void testPositiveIntPass() {
        Assert.assertEquals((long)1L, (long)Args.positive((int)1, (String)"Number"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPositiveIntFail1() {
        Args.positive((int)-1, (String)"Number");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPositiveIntFail2() {
        Args.positive((int)0, (String)"Number");
    }

    @Test
    public void testPositiveLongPass() {
        Assert.assertEquals((long)1L, (long)Args.positive((long)1L, (String)"Number"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPositiveLongFail1() {
        Args.positive((long)-1L, (String)"Number");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPositiveLongFail2() {
        Args.positive((long)0L, (String)"Number");
    }

    @Test
    public void testNotNegativeIntPass1() {
        Assert.assertEquals((long)1L, (long)Args.notNegative((int)1, (String)"Number"));
    }

    @Test
    public void testNotNegativeIntPass2() {
        Assert.assertEquals((long)0L, (long)Args.notNegative((int)0, (String)"Number"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotNegativeIntFail1() {
        Args.notNegative((int)-1, (String)"Number");
    }

    @Test
    public void testNotNegativeLongPass1() {
        Assert.assertEquals((long)1L, (long)Args.notNegative((long)1L, (String)"Number"));
    }

    @Test
    public void testNotNegativeLongPass2() {
        Assert.assertEquals((long)0L, (long)Args.notNegative((long)0L, (String)"Number"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotNegativeLongFail1() {
        Args.notNegative((long)-1L, (String)"Number");
    }
}

