/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.http.Consts;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestByteArrayBuffer {
    @Test
    public void testConstructor() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(16);
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)0L, (long)buffer.length());
        Assert.assertNotNull((Object)buffer.buffer());
        Assert.assertEquals((long)16L, (long)buffer.buffer().length);
        try {
            new ByteArrayBuffer(-1);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleAppend() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(16);
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)0L, (long)buffer.length());
        byte[] b1 = buffer.toByteArray();
        Assert.assertNotNull((Object)b1);
        Assert.assertEquals((long)0L, (long)b1.length);
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        byte[] tmp = new byte[]{1, 2, 3, 4};
        buffer.append(tmp, 0, tmp.length);
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)4L, (long)buffer.length());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        byte[] b2 = buffer.toByteArray();
        Assert.assertNotNull((Object)b2);
        Assert.assertEquals((long)4L, (long)b2.length);
        for (int i = 0; i < tmp.length; ++i) {
            Assert.assertEquals((long)tmp[i], (long)b2[i]);
            Assert.assertEquals((long)tmp[i], (long)buffer.byteAt(i));
        }
        buffer.clear();
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)0L, (long)buffer.length());
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
    }

    @Test
    public void testExpandAppend() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        Assert.assertEquals((long)4L, (long)buffer.capacity());
        byte[] tmp = new byte[]{1, 2, 3, 4};
        buffer.append(tmp, 0, 2);
        buffer.append(tmp, 0, 4);
        buffer.append(tmp, 0, 0);
        Assert.assertEquals((long)8L, (long)buffer.capacity());
        Assert.assertEquals((long)6L, (long)buffer.length());
        buffer.append(tmp, 0, 4);
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)10L, (long)buffer.length());
    }

    @Test
    public void testInvalidAppend() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        buffer.append((byte[])null, 0, 0);
        byte[] tmp = new byte[]{1, 2, 3, 4};
        try {
            buffer.append(tmp, -1, 0);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 0, -1);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 0, 8);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 10, Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 2, 4);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testAppendOneByte() throws Exception {
        byte[] tmp;
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        Assert.assertEquals((long)4L, (long)buffer.capacity());
        for (byte element : tmp = new byte[]{1, 127, -1, -128, 1, -2}) {
            buffer.append((int)element);
        }
        Assert.assertEquals((long)8L, (long)buffer.capacity());
        Assert.assertEquals((long)6L, (long)buffer.length());
        for (int i = 0; i < tmp.length; ++i) {
            Assert.assertEquals((long)tmp[i], (long)buffer.byteAt(i));
        }
    }

    @Test
    public void testSetLength() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        buffer.setLength(2);
        Assert.assertEquals((long)2L, (long)buffer.length());
    }

    @Test
    public void testSetInvalidLength() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        try {
            buffer.setLength(-2);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.setLength(200);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testEnsureCapacity() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        buffer.ensureCapacity(2);
        Assert.assertEquals((long)4L, (long)buffer.capacity());
        buffer.ensureCapacity(8);
        Assert.assertEquals((long)8L, (long)buffer.capacity());
    }

    @Test
    public void testIndexOf() throws Exception {
        int COLON = 58;
        int COMMA = 44;
        byte[] bytes = "name1: value1; name2: value2".getBytes(Consts.ASCII);
        int index1 = 5;
        int index2 = 20;
        ByteArrayBuffer buffer = new ByteArrayBuffer(16);
        buffer.append(bytes, 0, bytes.length);
        Assert.assertEquals((long)5L, (long)buffer.indexOf((byte)58));
        Assert.assertEquals((long)-1L, (long)buffer.indexOf((byte)44));
        Assert.assertEquals((long)5L, (long)buffer.indexOf((byte)58, -1, 11));
        Assert.assertEquals((long)5L, (long)buffer.indexOf((byte)58, 0, 1000));
        Assert.assertEquals((long)-1L, (long)buffer.indexOf((byte)58, 2, 1));
        Assert.assertEquals((long)20L, (long)buffer.indexOf((byte)58, 6, buffer.length()));
    }

    @Test
    public void testAppendCharArrayAsAscii() throws Exception {
        String s1 = "stuff";
        String s2 = " and more stuff";
        char[] b1 = "stuff".toCharArray();
        char[] b2 = " and more stuff".toCharArray();
        ByteArrayBuffer buffer = new ByteArrayBuffer(8);
        buffer.append(b1, 0, b1.length);
        buffer.append(b2, 0, b2.length);
        Assert.assertEquals((Object)"stuff and more stuff", (Object)new String(buffer.toByteArray(), "US-ASCII"));
    }

    @Test
    public void testAppendNullCharArray() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(8);
        buffer.append((char[])null, 0, 0);
        Assert.assertEquals((long)0L, (long)buffer.length());
    }

    @Test
    public void testAppendEmptyCharArray() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(8);
        buffer.append(new char[0], 0, 0);
        Assert.assertEquals((long)0L, (long)buffer.length());
    }

    @Test
    public void testAppendNullCharArrayBuffer() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(8);
        buffer.append((CharArrayBuffer)null, 0, 0);
        Assert.assertEquals((long)0L, (long)buffer.length());
    }

    @Test
    public void testInvalidAppendCharArrayAsAscii() throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        buffer.append((char[])null, 0, 0);
        char[] tmp = new char[]{'1', '2', '3', '4'};
        try {
            buffer.append(tmp, -1, 0);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 0, -1);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 0, 8);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 10, Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 2, 4);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSerialization() throws Exception {
        ByteArrayBuffer orig = new ByteArrayBuffer(32);
        orig.append(1);
        orig.append(2);
        orig.append(3);
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        ByteArrayBuffer clone = (ByteArrayBuffer)inStream.readObject();
        Assert.assertEquals((long)orig.capacity(), (long)clone.capacity());
        Assert.assertEquals((long)orig.length(), (long)clone.length());
        byte[] data = clone.toByteArray();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)3L, (long)data.length);
        Assert.assertEquals((long)1L, (long)data[0]);
        Assert.assertEquals((long)2L, (long)data[1]);
        Assert.assertEquals((long)3L, (long)data[2]);
    }

    @Test
    public void testControlCharFiltering() throws Exception {
        char[] chars = new char[256];
        for (int i = 0; i < 256; i = (int)((char)(i + 1))) {
            chars[i] = i;
        }
        byte[] bytes = TestByteArrayBuffer.asByteArray(chars);
        Assert.assertEquals((Object)"?????????\t?????????????????????? !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~?????????????????????????????????\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff", (Object)new String(bytes, "ISO-8859-1"));
    }

    @Test
    public void testUnicodeFiltering() throws Exception {
        Assert.assertEquals((Object)"?????", (Object)new String(TestByteArrayBuffer.asByteArray("\u0431\u0443\u043a\u0432\u044b".toCharArray()), "ISO-8859-1"));
        Assert.assertEquals((Object)"????", (Object)new String(TestByteArrayBuffer.asByteArray("\u56db\u5b57\u719f\u8a9e".toCharArray()), "ISO-8859-1"));
        Assert.assertEquals((Object)"?", (Object)new String(TestByteArrayBuffer.asByteArray("\u2603".toCharArray()), "ISO-8859-1"));
        Assert.assertEquals((Object)"??", (Object)new String(TestByteArrayBuffer.asByteArray("\ud83d\ude00".toCharArray()), "ISO-8859-1"));
    }

    private static byte[] asByteArray(char[] chars) {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(chars.length);
        byteArrayBuffer.append(chars, 0, chars.length);
        return byteArrayBuffer.toByteArray();
    }
}

