/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import org.apache.http.util.EncodingUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestEncodingUtils {
    static final int[] SWISS_GERMAN_HELLO = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};

    private static String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    public void testBytesToString() throws Exception {
        String s = TestEncodingUtils.constructString(SWISS_GERMAN_HELLO);
        byte[] utf = s.getBytes("UTF-8");
        byte[] latin1 = s.getBytes("ISO-8859-1");
        String s1 = EncodingUtils.getString((byte[])utf, (String)"UTF-8");
        String s2 = EncodingUtils.getString((byte[])latin1, (String)"ISO-8859-1");
        Assert.assertEquals((Object)s, (Object)s1);
        Assert.assertEquals((Object)s, (Object)s2);
        try {
            EncodingUtils.getString(null, (int)0, (int)0, (String)"UTF-8");
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            EncodingUtils.getString(null, (String)"UTF-8");
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            EncodingUtils.getString((byte[])new byte[0], null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            EncodingUtils.getString((byte[])new byte[0], (String)"");
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void testStringToBytesToString() throws Exception {
        int i;
        String s = TestEncodingUtils.constructString(SWISS_GERMAN_HELLO);
        byte[] utf = s.getBytes("UTF-8");
        byte[] latin1 = s.getBytes("ISO-8859-1");
        byte[] data1 = EncodingUtils.getBytes((String)s, (String)"UTF-8");
        byte[] data2 = EncodingUtils.getBytes((String)s, (String)"ISO-8859-1");
        Assert.assertNotNull((Object)data1);
        Assert.assertEquals((long)utf.length, (long)data1.length);
        for (i = 0; i < utf.length; ++i) {
            Assert.assertEquals((long)utf[i], (long)data1[i]);
        }
        Assert.assertNotNull((Object)data2);
        Assert.assertEquals((long)latin1.length, (long)data2.length);
        for (i = 0; i < latin1.length; ++i) {
            Assert.assertEquals((long)latin1[i], (long)data2[i]);
        }
        try {
            EncodingUtils.getBytes(null, (String)"UTF-8");
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            EncodingUtils.getBytes((String)"what not", null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            EncodingUtils.getBytes((String)"what not", (String)"");
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void testAsciiBytesToString() throws Exception {
        String s = "ascii only, I mean it!";
        Assert.assertEquals((Object)"ascii only, I mean it!", (Object)EncodingUtils.getAsciiString((byte[])"ascii only, I mean it!".getBytes("US-ASCII")));
        try {
            EncodingUtils.getAsciiString(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            EncodingUtils.getAsciiString(null, (int)0, (int)0);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAsciiStringToBytes() throws Exception {
        String s = "ascii only, I mean it!";
        byte[] ascii = "ascii only, I mean it!".getBytes("US-ASCII");
        byte[] data = EncodingUtils.getAsciiBytes((String)"ascii only, I mean it!");
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)ascii.length, (long)data.length);
        for (int i = 0; i < ascii.length; ++i) {
            Assert.assertEquals((long)ascii[i], (long)data[i]);
        }
        try {
            EncodingUtils.getAsciiBytes(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void testUnsupportedEncoding() {
        String s = TestEncodingUtils.constructString(SWISS_GERMAN_HELLO);
        byte[] b1 = s.getBytes();
        byte[] b2 = EncodingUtils.getBytes((String)s, (String)"ThisJustAintRight");
        Assert.assertEquals((long)b1.length, (long)b2.length);
        for (int i = 0; i < b1.length; ++i) {
            Assert.assertEquals((long)b1[i], (long)b2[i]);
        }
        String s1 = new String(b1);
        String s2 = EncodingUtils.getString((byte[])b1, (String)"ThisJustAintRight");
        Assert.assertEquals((Object)s1, (Object)s2);
    }
}

