/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestEntityUtils {
    static final int[] SWISS_GERMAN_HELLO = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] RUSSIAN_HELLO = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};

    @Test
    public void testNullEntityToByteArray() throws Exception {
        try {
            EntityUtils.toByteArray(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyContentToByteArray() throws Exception {
        NullHttpEntity httpentity = new NullHttpEntity();
        byte[] bytes = EntityUtils.toByteArray((HttpEntity)httpentity);
        Assert.assertNull((Object)bytes);
    }

    @Test
    public void testMaxIntContentToByteArray() throws Exception {
        byte[] content = "Message content".getBytes(Consts.ISO_8859_1);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent((InputStream)new ByteArrayInputStream(content));
        httpentity.setContentLength(2147483747L);
        try {
            EntityUtils.toByteArray((HttpEntity)httpentity);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnknownLengthContentToByteArray() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ISO_8859_1);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent((InputStream)new ByteArrayInputStream(bytes));
        httpentity.setContentLength(-1L);
        byte[] bytes2 = EntityUtils.toByteArray((HttpEntity)httpentity);
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)bytes.length, (long)bytes2.length);
        for (int i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)bytes2[i]);
        }
    }

    @Test
    public void testKnownLengthContentToByteArray() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ISO_8859_1);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent((InputStream)new ByteArrayInputStream(bytes));
        httpentity.setContentLength((long)bytes.length);
        byte[] bytes2 = EntityUtils.toByteArray((HttpEntity)httpentity);
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)bytes.length, (long)bytes2.length);
        for (int i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)bytes2[i]);
        }
    }

    @Test
    public void testNullEntityToString() throws Exception {
        try {
            EntityUtils.toString(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyContentToString() throws Exception {
        NullHttpEntity httpentity = new NullHttpEntity();
        String s = EntityUtils.toString((HttpEntity)httpentity);
        Assert.assertNull((Object)s);
    }

    @Test
    public void testMaxIntContentToString() throws Exception {
        byte[] content = "Message content".getBytes(Consts.ISO_8859_1);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent((InputStream)new ByteArrayInputStream(content));
        httpentity.setContentLength(2147483747L);
        try {
            EntityUtils.toString((HttpEntity)httpentity);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnknownLengthContentToString() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ISO_8859_1);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent((InputStream)new ByteArrayInputStream(bytes));
        httpentity.setContentLength(-1L);
        String s = EntityUtils.toString((HttpEntity)httpentity, (String)"ISO-8859-1");
        Assert.assertEquals((Object)"Message content", (Object)s);
    }

    @Test
    public void testKnownLengthContentToString() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ISO_8859_1);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent((InputStream)new ByteArrayInputStream(bytes));
        httpentity.setContentLength((long)bytes.length);
        String s = EntityUtils.toString((HttpEntity)httpentity, (String)"ISO-8859-1");
        Assert.assertEquals((Object)"Message content", (Object)s);
    }

    private static String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    public void testNoCharsetContentToString() throws Exception {
        String content = TestEntityUtils.constructString(SWISS_GERMAN_HELLO);
        byte[] bytes = content.getBytes(Consts.ISO_8859_1);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent((InputStream)new ByteArrayInputStream(bytes));
        httpentity.setContentType((Header)new BasicHeader("Content-Type", "text/plain"));
        String s = EntityUtils.toString((HttpEntity)httpentity);
        Assert.assertEquals((Object)content, (Object)s);
    }

    @Test
    public void testDefaultCharsetContentToString() throws Exception {
        String content = TestEntityUtils.constructString(RUSSIAN_HELLO);
        byte[] bytes = content.getBytes(Charset.forName("KOI8-R"));
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent((InputStream)new ByteArrayInputStream(bytes));
        httpentity.setContentType((Header)new BasicHeader("Content-Type", "text/plain"));
        String s = EntityUtils.toString((HttpEntity)httpentity, (String)"KOI8-R");
        Assert.assertEquals((Object)content, (Object)s);
    }

    @Test
    public void testContentWithContentTypeToString() throws Exception {
        String content = TestEntityUtils.constructString(RUSSIAN_HELLO);
        byte[] bytes = content.getBytes(Consts.UTF_8);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent((InputStream)new ByteArrayInputStream(bytes));
        httpentity.setContentType((Header)new BasicHeader("Content-Type", "text/plain; charset=UTF-8"));
        String s = EntityUtils.toString((HttpEntity)httpentity, (String)"ISO-8859-1");
        Assert.assertEquals((Object)content, (Object)s);
    }

    @Test
    public void testContentWithInvalidContentTypeToString() throws Exception {
        String content = TestEntityUtils.constructString(RUSSIAN_HELLO);
        byte[] bytes = content.getBytes("UTF-8");
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent((InputStream)new ByteArrayInputStream(bytes));
        httpentity.setContentType((Header)new BasicHeader("Content-Type", "text/plain; charset=nosuchcharset"));
        String s = EntityUtils.toString((HttpEntity)httpentity, (String)"UTF-8");
        Assert.assertEquals((Object)content, (Object)s);
    }

    public static class NullHttpEntity
    extends BasicHttpEntity {
        public InputStream getContent() {
            return null;
        }
    }
}

