/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.google;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.amazonaws.mobile.auth.core.signin.SignInManager;
import com.amazonaws.mobile.auth.core.signin.ui.DisplayUtils;
import com.amazonaws.mobile.auth.core.signin.ui.buttons.SignInButton;
import com.amazonaws.mobile.auth.core.signin.ui.buttons.SignInButtonAttributes;
import com.amazonaws.mobile.auth.google.GoogleSignInProvider;
import com.amazonaws.mobile.auth.google.R;

public class GoogleButton
extends SignInButton {
    private static final String LOG_TAG = GoogleButton.class.getSimpleName();
    private static final int CORNER_RADIUS = 4;
    private static final int GOOGLE_BACKGROUND_COLOR = -1;
    private static final int GOOGLE_BACKGROUND_COLOR_PRESSED = -3355444;
    private static final int TEXT_COLOR = -12303292;
    private static final int BUTTON_TOP_SHADOW_COLOR = -3355444;
    private static final int BUTTON_TOP_SHADOW_THICKNESS = DisplayUtils.dp((int)1);
    private static final int BUTTON_BOTTOM_SHADOW_THICKNESS = DisplayUtils.dp((int)2);

    public GoogleButton(@NonNull Context context) {
        this(context, null);
    }

    public GoogleButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GoogleButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr, new SignInButtonAttributes().withCornerRadius(4).withBackgroundColor(-1).withBackgroundColorPressed(-3355444).withTextColor(-12303292).withDefaultTextResourceId(R.string.default_google_button_text).withImageIconResourceId(R.drawable.google_icon).withTopShadowColor(-3355444).withTopShadowThickness(BUTTON_TOP_SHADOW_THICKNESS).withBottomShadowThickness(BUTTON_BOTTOM_SHADOW_THICKNESS));
        if (this.isInEditMode()) {
            return;
        }
        try {
            SignInManager signInManager = SignInManager.getInstance();
            signInManager.initializeSignInButton(GoogleSignInProvider.class, (View)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.e((String)LOG_TAG, (String)"Cannot initialize the SignInButton. Please check if IdentityManager : startUpAuth and setUpToAuthenticate are invoked");
        }
    }
}

