/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.google;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.View;
import com.amazonaws.mobile.auth.core.IdentityProvider;
import com.amazonaws.mobile.auth.core.internal.util.ThreadUtils;
import com.amazonaws.mobile.auth.core.signin.SignInPermissionsHandler;
import com.amazonaws.mobile.auth.core.signin.SignInProvider;
import com.amazonaws.mobile.auth.core.signin.SignInProviderResultHandler;
import com.amazonaws.mobile.auth.google.GoogleSignInException;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class GoogleSignInProvider
implements SignInProvider,
SignInPermissionsHandler {
    private static final String LOG_TAG = GoogleSignInProvider.class.getSimpleName();
    public static final String COGNITO_LOGIN_KEY_GOOGLE = "accounts.google.com";
    private static final int REQUEST_GOOGLE_PLAY_SERVICES = 1363;
    private static final int RC_SIGN_IN = 16723;
    private static final int GET_ACCOUNTS_PERMISSION_REQUEST_CODE = 93;
    private GoogleApiClient mGoogleApiClient;
    private Context context;
    private boolean signingIn = false;
    private SignInProviderResultHandler resultsHandler;
    private volatile GoogleSignInAccount signedInAccount = null;
    private volatile String authToken = null;
    private WeakReference<Activity> activityWeakReference = null;
    private AWSConfiguration awsConfiguration = null;
    private static ArrayList<String> loginScopeList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(@NonNull Context activityContext, AWSConfiguration awsConfig) {
        this.context = activityContext;
        this.awsConfiguration = awsConfig;
        Log.d((String)LOG_TAG, (String)"Initializing Google SDK...");
        try {
            GoogleSignInProvider.setPermissions(this.awsConfiguration.optJsonObject("GoogleSignIn").getString("Permissions").split(","));
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Failed to register the permissions with GoogleSignInProvider. Use GoogleSignInProvider.setPermissions() to register the permissions. Check if GoogleSignIn is present in `awsconfiguration.json`.");
        }
        GoogleSignInOptions.Builder builder = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN);
        ArrayList<String> arrayList = loginScopeList;
        synchronized (arrayList) {
            for (String loginScope : loginScopeList) {
                builder = builder.requestScopes(new Scope(loginScope), new Scope[0]);
            }
        }
        GoogleSignInOptions gso = builder.requestEmail().requestProfile().build();
        Log.d((String)LOG_TAG, (String)"Created Google SignInOptions.");
        this.mGoogleApiClient = new GoogleApiClient.Builder(this.context).addApi(Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions.HasOptions)gso).build();
        this.mGoogleApiClient.connect();
        Log.d((String)LOG_TAG, (String)"Connected to the Google SignIn API Client.");
    }

    public String getDisplayName() {
        return "Google";
    }

    public boolean refreshUserSignInState() {
        OptionalPendingResult opr = Auth.GoogleSignInApi.silentSignIn(this.mGoogleApiClient);
        if (opr.isDone()) {
            GoogleSignInResult result = (GoogleSignInResult)opr.get();
            if (result == null) {
                Log.d((String)LOG_TAG, (String)"GoogleSignInResult is null. Not signed-in with Google.");
                return false;
            }
            return this.handleGoogleSignInResultForIsUserSignedIn(result);
        }
        GoogleApiAvailability api = GoogleApiAvailability.getInstance();
        int code = api.isGooglePlayServicesAvailable(this.context.getApplicationContext());
        if (0 == code) {
            GoogleSignInResult googleSignInResult = (GoogleSignInResult)opr.await();
            return this.handleGoogleSignInResultForIsUserSignedIn(googleSignInResult);
        }
        Log.w((String)LOG_TAG, (String)"Google Play Services are not available. Assuming not signed-in with Google.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPermissions(String ... loginScopes) {
        ArrayList<String> arrayList = loginScopeList;
        synchronized (arrayList) {
            loginScopeList.clear();
            for (String scope : loginScopes) {
                loginScopeList.add(scope);
            }
        }
    }

    public String getCognitoLoginKey() {
        return COGNITO_LOGIN_KEY_GOOGLE;
    }

    public String getToken() {
        return this.authToken;
    }

    public String refreshToken() {
        Log.d((String)LOG_TAG, (String)"Google provider refreshing token...");
        try {
            this.authToken = this.getGoogleAuthToken(this.signedInAccount.getEmail());
        }
        catch (Exception ex) {
            Log.w((String)LOG_TAG, (String)"Failed to update Google token", (Throwable)ex);
            this.authToken = null;
        }
        return this.authToken;
    }

    public void signOut() {
        Log.d((String)LOG_TAG, (String)"Google provider signing out...");
        Status status = (Status)Auth.GoogleSignInApi.signOut(this.mGoogleApiClient).await();
        Log.d((String)LOG_TAG, (String)("signOut:onResult:" + status));
        this.authToken = null;
    }

    public boolean isRequestCodeOurs(int requestCode) {
        return requestCode == 16723;
    }

    public void handleActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 16723) {
            this.signingIn = false;
            final GoogleSignInResult result = Auth.GoogleSignInApi.getSignInResultFromIntent(data);
            if (result == null) {
                String errMsg = "GoogleSignInResult was null.";
                Log.wtf((String)LOG_TAG, (String)"GoogleSignInResult was null.");
                this.resultsHandler.onError((IdentityProvider)this, (Exception)new IllegalStateException("GoogleSignInResult was null."));
                return;
            }
            if (!result.isSuccess()) {
                if (12501 == result.getStatus().getStatusCode()) {
                    this.resultsHandler.onCancel((IdentityProvider)this);
                    return;
                }
                this.resultsHandler.onError((IdentityProvider)this, (Exception)new GoogleSignInException(result));
            }
            Log.i((String)LOG_TAG, (String)("Successful GoogleSignInResult, status=" + result.getStatus().toString()));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        GoogleSignInProvider.this.handleGoogleSignInSuccessResult(result);
                        Log.d((String)LOG_TAG, (String)"Google provider sign-in succeeded!");
                        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                GoogleSignInProvider.this.resultsHandler.onSuccess((IdentityProvider)GoogleSignInProvider.this);
                            }
                        });
                    }
                    catch (Exception ex) {
                        String errMsg = "Error retrieving Google token.";
                        Log.e((String)LOG_TAG, (String)"Error retrieving Google token.");
                        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                GoogleSignInProvider.this.resultsHandler.onError((IdentityProvider)GoogleSignInProvider.this, ex);
                            }
                        });
                    }
                }
            }).start();
        }
    }

    public View.OnClickListener initializeSignInButton(final Activity signInActivity, View buttonView, SignInProviderResultHandler providerResultsHandler) {
        this.resultsHandler = providerResultsHandler;
        GoogleApiAvailability api = GoogleApiAvailability.getInstance();
        int code = api.isGooglePlayServicesAvailable(this.context.getApplicationContext());
        if (0 != code) {
            if (api.isUserResolvableError(code)) {
                Log.w((String)LOG_TAG, (String)"Google Play services recoverable error.");
                api.showErrorDialogFragment(signInActivity, code, 1363);
            } else {
                boolean isDebugBuild;
                boolean bl = isDebugBuild = 0 != (signInActivity.getApplicationContext().getApplicationInfo().flags & 2);
                if (!isDebugBuild) {
                    buttonView.setVisibility(8);
                } else {
                    Log.w((String)LOG_TAG, (String)"Google Play Services are not available, but we are showing the Google Sign-in Button, anyway, because this is a debug build.");
                }
            }
            return null;
        }
        View.OnClickListener listener = new View.OnClickListener(){

            public void onClick(View v) {
                if (!GoogleSignInProvider.this.signingIn) {
                    GoogleSignInProvider.this.signingIn = true;
                    if (GoogleSignInProvider.this.getPermissionsIfNecessary(signInActivity)) {
                        return;
                    }
                    GoogleSignInProvider.this.initiateGoogleSignIn(signInActivity);
                }
            }
        };
        buttonView.setOnClickListener(listener);
        return listener;
    }

    public GoogleSignInAccount getSignedInAccount() {
        return this.signedInAccount;
    }

    public int getPermissionRequestCode() {
        return 93;
    }

    public void handleRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        try {
            if (requestCode == 93) {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    Activity activity = (Activity)this.activityWeakReference.get();
                    if (activity == null) {
                        throw new Exception("Cannot initiate GoogleSignIn. Activity context is null");
                    }
                    this.initiateGoogleSignIn(activity);
                } else {
                    Log.i((String)LOG_TAG, (String)"Permissions not granted for Google sign-in.");
                    this.signingIn = false;
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Cannot initiate GoogleSignIn. Check your permissions.", (Throwable)exception);
        }
    }

    private boolean handleGoogleSignInResultForIsUserSignedIn(@NonNull GoogleSignInResult result) {
        this.signedInAccount = result.getSignInAccount();
        if (this.signedInAccount == null) {
            Log.i((String)LOG_TAG, (String)("GoogleSignInResult indicates not signed in with an account: " + result.getStatus().toString()));
            this.authToken = null;
            return false;
        }
        String accountEmail = this.signedInAccount.getEmail();
        Log.d((String)LOG_TAG, (String)"Google sign-in was cached, attempting to retrieve auth token.");
        try {
            this.authToken = this.getGoogleAuthToken(accountEmail);
            return true;
        }
        catch (Exception ex) {
            Log.w((String)LOG_TAG, (String)"Couldn't obtain Google Auth token for account.", (Throwable)ex);
            return false;
        }
    }

    private boolean getPermissionsIfNecessary(Activity activity) {
        if (ContextCompat.checkSelfPermission((Context)activity.getApplicationContext(), (String)"android.permission.GET_ACCOUNTS") != 0) {
            this.activityWeakReference = new WeakReference<Activity>(activity);
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.GET_ACCOUNTS"}, (int)93);
            return true;
        }
        return false;
    }

    private void initiateGoogleSignIn(Activity signInActivity) {
        Log.d((String)LOG_TAG, (String)"Launching sign-in activity.");
        Intent signInIntent = Auth.GoogleSignInApi.getSignInIntent(this.mGoogleApiClient);
        signInActivity.startActivityForResult(signInIntent, 16723);
    }

    private void handleGoogleSignInSuccessResult(@NonNull GoogleSignInResult result) throws IOException, GoogleAuthException, GoogleSignInException {
        this.signedInAccount = result.getSignInAccount();
        if (this.signedInAccount == null) {
            Log.i((String)LOG_TAG, (String)"GoogleSignInResult indicates not signed in with an account.");
            GoogleSignInException ex = new GoogleSignInException(result);
            Log.d((String)LOG_TAG, (String)ex.getMessage(), (Throwable)ex);
            this.authToken = null;
            throw ex;
        }
        String accountEmail = this.signedInAccount.getEmail();
        this.authToken = this.getGoogleAuthToken(accountEmail);
    }

    private String getGoogleClientId() throws IOException {
        Log.d((String)LOG_TAG, (String)"Getting Google Client Id from AWSConfiguration...");
        try {
            String clientId = this.awsConfiguration.optJsonObject("GoogleSignIn").getString("ClientId-WebApp");
            Log.d((String)LOG_TAG, (String)("clientId=" + clientId));
            return clientId;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Couldn't find Google ClientId from the AWSConfiguration.Please check the awsconfiguration.json file", exception);
        }
    }

    private String getGoogleAuthToken(String accountEmail) throws GoogleAuthException, IOException {
        Log.d((String)LOG_TAG, (String)"Google provider getting token...");
        Account googleAccount = new Account(accountEmail, "com.google");
        String scopes = "audience:server:client_id:" + this.getGoogleClientId();
        String token = GoogleAuthUtil.getToken((Context)this.context, (Account)googleAccount, (String)scopes);
        if (token != null) {
            Log.d((String)LOG_TAG, (String)("Google Token is OK. Token hashcode = " + token.hashCode()));
        } else {
            Log.d((String)LOG_TAG, (String)"Google Token is NULL.");
        }
        return token;
    }
}

