/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.userpools;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.amazonaws.mobile.auth.core.internal.util.ViewHelper;
import com.amazonaws.mobile.auth.userpools.CognitoUserPoolsSignInProvider;
import com.amazonaws.mobile.auth.userpools.R;
import com.amazonaws.mobile.auth.userpools.SignUpView;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserAttributes;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserCodeDeliveryDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserPool;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.SignUpHandler;

public class SignUpActivity
extends Activity {
    private static final String LOG_TAG = SignUpActivity.class.getSimpleName();
    private SignUpView signUpView;
    private CognitoUserPool mUserPool;

    public static void startActivity(Activity callingActivity, int requestCode) {
        Intent intent = new Intent((Context)callingActivity, SignUpActivity.class);
        callingActivity.startActivityForResult(intent, requestCode);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_sign_up);
        this.signUpView = (SignUpView)this.findViewById(R.id.signup_view);
        Context appContext = this.getApplicationContext();
        this.mUserPool = new CognitoUserPool(appContext, new AWSConfiguration(appContext));
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        imm.toggleSoftInput(2, 1);
    }

    protected void onResume() {
        super.onResume();
    }

    public void signUp(View view) {
        final String username = this.signUpView.getUserName();
        final String password = this.signUpView.getPassword();
        String givenName = this.signUpView.getGivenName();
        String email = this.signUpView.getEmail();
        String phone = this.signUpView.getPhone();
        Log.d((String)LOG_TAG, (String)("username = " + username));
        Log.d((String)LOG_TAG, (String)("given_name = " + givenName));
        Log.d((String)LOG_TAG, (String)("email = " + email));
        Log.d((String)LOG_TAG, (String)("phone = " + phone));
        if (username.isEmpty()) {
            this.showError(this.getString(R.string.sign_up_username_missing));
            return;
        }
        if (password.length() < 6) {
            this.showError(this.getString(R.string.password_length_validation_failed));
            return;
        }
        CognitoUserAttributes userAttributes = new CognitoUserAttributes();
        userAttributes.addAttribute("given_name", givenName);
        userAttributes.addAttribute("email", email);
        if (!phone.isEmpty()) {
            userAttributes.addAttribute("phone_number", phone);
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(R.string.sign_up_in_progress)).setMessage((CharSequence)this.getString(R.string.please_wait)).setNeutralButton(17039370, null);
        final AlertDialog alertDialog = builder.show();
        this.mUserPool.signUpInBackground(username, password, userAttributes, null, new SignUpHandler(){

            public void onSuccess(CognitoUser user, boolean signUpConfirmationState, CognitoUserCodeDeliveryDetails cognitoUserCodeDeliveryDetails) {
                alertDialog.dismiss();
                Intent intent = new Intent();
                intent.putExtra("username", username);
                intent.putExtra("password", password);
                intent.putExtra("isSignUpConfirmed", signUpConfirmationState);
                intent.putExtra("destination", cognitoUserCodeDeliveryDetails.getDestination());
                SignUpActivity.this.setResult(-1, intent);
                SignUpActivity.this.finish();
            }

            public void onFailure(Exception exception) {
                alertDialog.dismiss();
                SignUpActivity.this.showError(exception.getLocalizedMessage() != null ? CognitoUserPoolsSignInProvider.getErrorMessageFromException(exception) : "");
            }
        });
    }

    protected void showError(String msg) {
        ViewHelper.showDialog((Activity)this, (String)this.getString(R.string.title_activity_sign_up), (String)(this.getString(R.string.sign_up_failed) + " " + msg));
    }
}

