/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.userpools;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.amazonaws.mobile.auth.core.IdentityProvider;
import com.amazonaws.mobile.auth.core.internal.util.ViewHelper;
import com.amazonaws.mobile.auth.core.signin.SignInProvider;
import com.amazonaws.mobile.auth.core.signin.SignInProviderResultHandler;
import com.amazonaws.mobile.auth.userpools.ForgotPasswordActivity;
import com.amazonaws.mobile.auth.userpools.MFAActivity;
import com.amazonaws.mobile.auth.userpools.R;
import com.amazonaws.mobile.auth.userpools.SignUpActivity;
import com.amazonaws.mobile.auth.userpools.SignUpConfirmActivity;
import com.amazonaws.mobile.auth.userpools.UserPoolSignInView;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoDevice;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserAttributes;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserCodeDeliveryDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserPool;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserSession;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.AuthenticationContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.AuthenticationDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ChallengeContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ForgotPasswordContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.MultiFactorAuthenticationContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.ForgotPasswordHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.GenericHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.SignUpHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.VerificationHandler;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidentityprovider.model.InvalidParameterException;
import com.amazonaws.services.cognitoidentityprovider.model.NotAuthorizedException;
import com.amazonaws.services.cognitoidentityprovider.model.UserNotConfirmedException;
import com.amazonaws.services.cognitoidentityprovider.model.UserNotFoundException;
import java.util.HashSet;
import java.util.Set;

public class CognitoUserPoolsSignInProvider
implements SignInProvider {
    private static final String LOG_TAG = CognitoUserPoolsSignInProvider.class.getSimpleName();
    private static final int REQUEST_CODE_START = 10608;
    private static final int FORGOT_PASSWORD_REQUEST_CODE = 10650;
    private static final int SIGN_UP_REQUEST_CODE = 10651;
    private static final int MFA_REQUEST_CODE = 10652;
    private static final int VERIFICATION_REQUEST_CODE = 10653;
    private static final Set<Integer> REQUEST_CODES = new HashSet<Integer>(){
        {
            this.add(10650);
            this.add(10651);
            this.add(10652);
            this.add(10653);
        }
    };
    private static final String AWS_CONFIGURATION_FILE = "AWSConfiguration";
    private static final int PASSWORD_MIN_LENGTH = 6;
    private static final String USERPOOLS_EXCEPTION_PREFIX = "(Service";
    private SignInProviderResultHandler resultsHandler;
    private ForgotPasswordContinuation forgotPasswordContinuation;
    private MultiFactorAuthenticationContinuation multiFactorAuthenticationContinuation;
    private Context context;
    private Activity activity;
    private String username;
    private String password;
    private String verificationCode;
    private String cognitoLoginKey;
    private CognitoUserPool cognitoUserPool;
    private CognitoUserSession cognitoUserSession;
    private AWSConfiguration awsConfiguration;
    private int backgroundColor;
    private ForgotPasswordHandler forgotPasswordHandler = new ForgotPasswordHandler(){

        public void onSuccess() {
            Log.d((String)LOG_TAG, (String)"Password change succeeded.");
            ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_forgot_password), (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.password_change_success));
        }

        public void getResetCode(ForgotPasswordContinuation continuation) {
            CognitoUserPoolsSignInProvider.this.forgotPasswordContinuation = continuation;
            Intent intent = new Intent(CognitoUserPoolsSignInProvider.this.context, ForgotPasswordActivity.class);
            intent.putExtra("signInBackgroundColor", CognitoUserPoolsSignInProvider.this.backgroundColor);
            CognitoUserPoolsSignInProvider.this.activity.startActivityForResult(intent, 10650);
        }

        public void onFailure(Exception exception) {
            Log.e((String)LOG_TAG, (String)"Password change failed.", (Throwable)exception);
            String message = exception instanceof InvalidParameterException ? CognitoUserPoolsSignInProvider.this.activity.getString(R.string.password_change_no_verification_failed) : CognitoUserPoolsSignInProvider.getErrorMessageFromException(exception);
            ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_forgot_password), (String)(CognitoUserPoolsSignInProvider.this.activity.getString(R.string.password_change_failed) + " " + message));
        }
    };
    private SignUpHandler signUpHandler = new SignUpHandler(){

        public void onSuccess(CognitoUser user, boolean signUpConfirmationState, CognitoUserCodeDeliveryDetails cognitoUserCodeDeliveryDetails) {
            if (signUpConfirmationState) {
                Log.d((String)LOG_TAG, (String)("Signed up. User ID = " + user.getUserId()));
                ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_sign_up), (String)(CognitoUserPoolsSignInProvider.this.activity.getString(R.string.sign_up_success) + " " + user.getUserId()));
            } else {
                Log.w((String)LOG_TAG, (String)"Additional confirmation for sign up.");
                CognitoUserPoolsSignInProvider.this.startVerificationActivity();
            }
        }

        public void onFailure(Exception exception) {
            Log.e((String)LOG_TAG, (String)"Sign up failed.", (Throwable)exception);
            ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_dialog_sign_up_failed), (String)(exception.getLocalizedMessage() != null ? CognitoUserPoolsSignInProvider.getErrorMessageFromException(exception) : CognitoUserPoolsSignInProvider.this.activity.getString(R.string.sign_up_failed)));
        }
    };
    private GenericHandler signUpConfirmationHandler = new GenericHandler(){

        public void onSuccess() {
            Log.i((String)LOG_TAG, (String)"Confirmed.");
            ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_sign_up_confirm), (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.sign_up_confirm_success));
        }

        public void onFailure(Exception exception) {
            Log.e((String)LOG_TAG, (String)"Failed to confirm user.", (Throwable)exception);
            ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_sign_up_confirm), (String)(CognitoUserPoolsSignInProvider.this.activity.getString(R.string.sign_up_confirm_failed) + " " + CognitoUserPoolsSignInProvider.getErrorMessageFromException(exception)));
        }
    };
    private AuthenticationHandler authenticationHandler = new AuthenticationHandler(){

        public void onSuccess(CognitoUserSession userSession, CognitoDevice newDevice) {
            Log.i((String)LOG_TAG, (String)("Logged in. " + userSession.getIdToken()));
            CognitoUserPoolsSignInProvider.this.cognitoUserSession = userSession;
            if (null != CognitoUserPoolsSignInProvider.this.resultsHandler) {
                CognitoUserPoolsSignInProvider.this.resultsHandler.onSuccess((IdentityProvider)CognitoUserPoolsSignInProvider.this);
            }
        }

        public void getAuthenticationDetails(AuthenticationContinuation authenticationContinuation, String userId) {
            if (null != CognitoUserPoolsSignInProvider.this.username && null != CognitoUserPoolsSignInProvider.this.password) {
                AuthenticationDetails authenticationDetails = new AuthenticationDetails(CognitoUserPoolsSignInProvider.this.username, CognitoUserPoolsSignInProvider.this.password, null);
                authenticationContinuation.setAuthenticationDetails(authenticationDetails);
                authenticationContinuation.continueTask();
            }
        }

        public void getMFACode(MultiFactorAuthenticationContinuation continuation) {
            CognitoUserPoolsSignInProvider.this.multiFactorAuthenticationContinuation = continuation;
            Intent intent = new Intent(CognitoUserPoolsSignInProvider.this.context, MFAActivity.class);
            intent.putExtra("signInBackgroundColor", CognitoUserPoolsSignInProvider.this.backgroundColor);
            CognitoUserPoolsSignInProvider.this.activity.startActivityForResult(intent, 10652);
        }

        public void authenticationChallenge(ChallengeContinuation continuation) {
            throw new UnsupportedOperationException("Not supported in this sample.");
        }

        public void onFailure(Exception exception) {
            Log.e((String)LOG_TAG, (String)"Failed to login.", (Throwable)exception);
            if (exception instanceof UserNotConfirmedException) {
                CognitoUserPoolsSignInProvider.this.resendConfirmationCode();
                return;
            }
            String message = exception instanceof UserNotFoundException ? CognitoUserPoolsSignInProvider.this.activity.getString(R.string.user_does_not_exist) : (exception instanceof NotAuthorizedException ? CognitoUserPoolsSignInProvider.this.activity.getString(R.string.incorrect_username_or_password) : CognitoUserPoolsSignInProvider.getErrorMessageFromException(exception));
            if (null != CognitoUserPoolsSignInProvider.this.resultsHandler) {
                ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_sign_in), (String)(CognitoUserPoolsSignInProvider.this.activity.getString(R.string.login_failed) + " " + message));
                CognitoUserPoolsSignInProvider.this.resultsHandler.onError((IdentityProvider)CognitoUserPoolsSignInProvider.this, exception);
            }
        }
    };

    private void startVerificationActivity() {
        Intent intent = new Intent(this.context, SignUpConfirmActivity.class);
        intent.putExtra("username", this.username);
        intent.putExtra("signInBackgroundColor", this.backgroundColor);
        this.activity.startActivityForResult(intent, 10653);
    }

    private void resendConfirmationCode() {
        CognitoUser cognitoUser = this.cognitoUserPool.getUser(this.username);
        cognitoUser.resendConfirmationCodeInBackground(new VerificationHandler(){

            public void onSuccess(CognitoUserCodeDeliveryDetails verificationCodeDeliveryMedium) {
                CognitoUserPoolsSignInProvider.this.startVerificationActivity();
            }

            public void onFailure(Exception exception) {
                if (null != CognitoUserPoolsSignInProvider.this.resultsHandler) {
                    ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_sign_in), (String)(CognitoUserPoolsSignInProvider.this.activity.getString(R.string.login_failed) + "\nUser was not verified and resending confirmation code failed.\n" + CognitoUserPoolsSignInProvider.getErrorMessageFromException(exception)));
                    CognitoUserPoolsSignInProvider.this.resultsHandler.onError((IdentityProvider)CognitoUserPoolsSignInProvider.this, exception);
                }
            }
        });
    }

    public void initialize(Context context, AWSConfiguration awsConfiguration) {
        this.context = context;
        this.awsConfiguration = awsConfiguration;
        Log.d((String)LOG_TAG, (String)"initalizing Cognito User Pools");
        String regionString = this.getCognitoUserPoolRegion();
        Regions region = Regions.fromName((String)regionString);
        this.cognitoUserPool = new CognitoUserPool(context, this.getCognitoUserPoolId(), this.getCognitoUserPoolClientId(), this.getCognitoUserPoolClientSecret(), region);
        this.cognitoLoginKey = "cognito-idp." + region.getName() + ".amazonaws.com/" + this.getCognitoUserPoolId();
        Log.d((String)LOG_TAG, (String)("CognitoLoginKey: " + this.cognitoLoginKey));
    }

    public boolean isRequestCodeOurs(int requestCode) {
        return REQUEST_CODES.contains(requestCode);
    }

    public void handleActivityResult(int requestCode, int resultCode, Intent data) {
        if (-1 == resultCode) {
            switch (requestCode) {
                case 10650: {
                    this.password = data.getStringExtra("password");
                    this.verificationCode = data.getStringExtra("verification_code");
                    if (this.password.length() < 6) {
                        ViewHelper.showDialog((Activity)this.activity, (String)this.activity.getString(R.string.title_activity_forgot_password), (String)(this.activity.getString(R.string.password_change_failed) + " " + this.activity.getString(R.string.password_length_validation_failed)));
                        return;
                    }
                    Log.d((String)LOG_TAG, (String)("verificationCode = " + this.verificationCode));
                    this.forgotPasswordContinuation.setPassword(this.password);
                    this.forgotPasswordContinuation.setVerificationCode(this.verificationCode);
                    this.forgotPasswordContinuation.continueTask();
                    break;
                }
                case 10651: {
                    this.username = data.getStringExtra("username");
                    this.password = data.getStringExtra("password");
                    String givenName = data.getStringExtra("given_name");
                    String email = data.getStringExtra("email");
                    String phone = data.getStringExtra("phone_number");
                    if (this.username.length() < 1) {
                        ViewHelper.showDialog((Activity)this.activity, (String)this.activity.getString(R.string.title_activity_sign_up), (String)(this.activity.getString(R.string.sign_up_failed) + " " + this.activity.getString(R.string.sign_up_username_missing)));
                        return;
                    }
                    if (this.password.length() < 6) {
                        ViewHelper.showDialog((Activity)this.activity, (String)this.activity.getString(R.string.title_activity_sign_up), (String)(this.activity.getString(R.string.sign_up_failed) + " " + this.activity.getString(R.string.password_length_validation_failed)));
                        return;
                    }
                    Log.d((String)LOG_TAG, (String)("username = " + this.username));
                    Log.d((String)LOG_TAG, (String)("given_name = " + givenName));
                    Log.d((String)LOG_TAG, (String)("email = " + email));
                    Log.d((String)LOG_TAG, (String)("phone = " + phone));
                    CognitoUserAttributes userAttributes = new CognitoUserAttributes();
                    userAttributes.addAttribute("given_name", givenName);
                    userAttributes.addAttribute("email", email);
                    if (null != phone && phone.length() > 0) {
                        userAttributes.addAttribute("phone_number", phone);
                    }
                    this.cognitoUserPool.signUpInBackground(this.username, this.password, userAttributes, null, this.signUpHandler);
                    break;
                }
                case 10652: {
                    this.verificationCode = data.getStringExtra("verification_code");
                    if (this.verificationCode.length() < 1) {
                        ViewHelper.showDialog((Activity)this.activity, (String)this.activity.getString(R.string.title_activity_mfa), (String)(this.activity.getString(R.string.mfa_failed) + " " + this.activity.getString(R.string.mfa_code_empty)));
                        return;
                    }
                    Log.d((String)LOG_TAG, (String)("verificationCode = " + this.verificationCode));
                    this.multiFactorAuthenticationContinuation.setMfaCode(this.verificationCode);
                    this.multiFactorAuthenticationContinuation.continueTask();
                    break;
                }
                case 10653: {
                    this.username = data.getStringExtra("username");
                    this.verificationCode = data.getStringExtra("verification_code");
                    if (this.username.length() < 1) {
                        ViewHelper.showDialog((Activity)this.activity, (String)this.activity.getString(R.string.title_activity_sign_up_confirm), (String)(this.activity.getString(R.string.sign_up_confirm_title) + " " + this.activity.getString(R.string.sign_up_username_missing)));
                        return;
                    }
                    if (this.verificationCode.length() < 1) {
                        ViewHelper.showDialog((Activity)this.activity, (String)this.activity.getString(R.string.title_activity_sign_up_confirm), (String)(this.activity.getString(R.string.sign_up_confirm_title) + " " + this.activity.getString(R.string.sign_up_confirm_code_missing)));
                        return;
                    }
                    Log.d((String)LOG_TAG, (String)("username = " + this.username));
                    Log.d((String)LOG_TAG, (String)("verificationCode = " + this.verificationCode));
                    CognitoUser cognitoUser = this.cognitoUserPool.getUser(this.username);
                    cognitoUser.confirmSignUpInBackground(this.verificationCode, true, this.signUpConfirmationHandler);
                    break;
                }
                default: {
                    Log.e((String)LOG_TAG, (String)"Unknown Request Code sent.");
                }
            }
        }
    }

    public View.OnClickListener initializeSignInButton(Activity signInActivity, View buttonView, SignInProviderResultHandler providerResultsHandler) {
        this.activity = signInActivity;
        this.resultsHandler = providerResultsHandler;
        final UserPoolSignInView userPoolSignInView = (UserPoolSignInView)this.activity.findViewById(R.id.user_pool_sign_in_view_id);
        this.backgroundColor = userPoolSignInView.getBackgroundColor();
        userPoolSignInView.getSignUpTextView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent(CognitoUserPoolsSignInProvider.this.context, SignUpActivity.class);
                intent.putExtra("signInBackgroundColor", CognitoUserPoolsSignInProvider.this.backgroundColor);
                CognitoUserPoolsSignInProvider.this.activity.startActivityForResult(intent, 10651);
            }
        });
        TextView forgotPasswordTextView = userPoolSignInView.getForgotPasswordTextView();
        forgotPasswordTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CognitoUserPoolsSignInProvider.this.username = userPoolSignInView.getEnteredUserName();
                if (CognitoUserPoolsSignInProvider.this.username.length() < 1) {
                    Log.w((String)LOG_TAG, (String)"Missing username.");
                    ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_sign_in), (String)"Missing username.");
                } else {
                    CognitoUser cognitoUser = CognitoUserPoolsSignInProvider.this.cognitoUserPool.getUser(CognitoUserPoolsSignInProvider.this.username);
                    cognitoUser.forgotPasswordInBackground(CognitoUserPoolsSignInProvider.this.forgotPasswordHandler);
                }
            }
        });
        View.OnClickListener listener = new View.OnClickListener(){

            public void onClick(View view) {
                CognitoUserPoolsSignInProvider.this.username = userPoolSignInView.getEnteredUserName();
                CognitoUserPoolsSignInProvider.this.password = userPoolSignInView.getEnteredPassword();
                CognitoUser cognitoUser = CognitoUserPoolsSignInProvider.this.cognitoUserPool.getUser(CognitoUserPoolsSignInProvider.this.username);
                cognitoUser.getSessionInBackground(CognitoUserPoolsSignInProvider.this.authenticationHandler);
            }
        };
        buttonView.setOnClickListener(listener);
        return listener;
    }

    public String getDisplayName() {
        return "Amazon Cognito Your User Pools";
    }

    public String getCognitoLoginKey() {
        return this.cognitoLoginKey;
    }

    public boolean refreshUserSignInState() {
        if (null != this.cognitoUserSession && this.cognitoUserSession.isValid()) {
            return true;
        }
        RefreshSessionAuthenticationHandler refreshSessionAuthenticationHandler = new RefreshSessionAuthenticationHandler();
        this.cognitoUserPool.getCurrentUser().getSession((AuthenticationHandler)refreshSessionAuthenticationHandler);
        if (null != refreshSessionAuthenticationHandler.getUserSession()) {
            this.cognitoUserSession = refreshSessionAuthenticationHandler.getUserSession();
            Log.i((String)LOG_TAG, (String)"refreshUserSignInState: Signed in with Cognito.");
            return true;
        }
        Log.i((String)LOG_TAG, (String)"refreshUserSignInState: Not signed in with Cognito.");
        this.cognitoUserSession = null;
        return false;
    }

    public String getToken() {
        return null == this.cognitoUserSession ? null : this.cognitoUserSession.getIdToken().getJWTToken();
    }

    public String refreshToken() {
        if (this.cognitoUserSession != null && !this.cognitoUserSession.isValid()) {
            RefreshSessionAuthenticationHandler refreshSessionAuthenticationHandler = new RefreshSessionAuthenticationHandler();
            this.cognitoUserPool.getCurrentUser().getSession((AuthenticationHandler)refreshSessionAuthenticationHandler);
            if (null != refreshSessionAuthenticationHandler.getUserSession()) {
                this.cognitoUserSession = refreshSessionAuthenticationHandler.getUserSession();
            } else {
                Log.e((String)LOG_TAG, (String)"Could not refresh the Cognito User Pool Token.");
            }
        }
        return this.getToken();
    }

    public void signOut() {
        if (null != this.cognitoUserPool && null != this.cognitoUserPool.getCurrentUser()) {
            this.cognitoUserPool.getCurrentUser().signOut();
            this.cognitoUserSession = null;
            this.username = null;
            this.password = null;
        }
    }

    public CognitoUserPool getCognitoUserPool() {
        return this.cognitoUserPool;
    }

    private String getCognitoUserPoolId() throws IllegalArgumentException {
        try {
            return this.awsConfiguration.optJsonObject("CognitoUserPool").getString("PoolId");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot find the PoolId from the AWSConfiguration file.", exception);
        }
    }

    private String getCognitoUserPoolClientId() throws IllegalArgumentException {
        try {
            return this.awsConfiguration.optJsonObject("CognitoUserPool").getString("AppClientId");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot find the CognitoUserPool AppClientId from the AWSConfiguration file.", exception);
        }
    }

    private String getCognitoUserPoolClientSecret() throws IllegalArgumentException {
        try {
            return this.awsConfiguration.optJsonObject("CognitoUserPool").getString("AppClientSecret");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot find the CognitoUserPool AppClientSecret from the AWSConfiguration file.", exception);
        }
    }

    private String getCognitoUserPoolRegion() throws IllegalArgumentException {
        try {
            return this.awsConfiguration.optJsonObject("CognitoUserPool").getString("Region");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot find the CognitoUserPool Region from the AWSConfiguration file.", exception);
        }
    }

    private static String getErrorMessageFromException(Exception exception) {
        String message = exception.getLocalizedMessage();
        if (message == null) {
            return exception.getMessage();
        }
        int index = message.indexOf(USERPOOLS_EXCEPTION_PREFIX);
        if (index == -1) {
            return message;
        }
        return message.substring(0, index);
    }

    private static class RefreshSessionAuthenticationHandler
    implements AuthenticationHandler {
        private CognitoUserSession userSession = null;

        private RefreshSessionAuthenticationHandler() {
        }

        private CognitoUserSession getUserSession() {
            return this.userSession;
        }

        public void onSuccess(CognitoUserSession userSession, CognitoDevice newDevice) {
            this.userSession = userSession;
        }

        public void getAuthenticationDetails(AuthenticationContinuation authenticationContinuation, String UserId) {
            Log.d((String)LOG_TAG, (String)"Can't refresh the session silently, due to authentication details needed.");
        }

        public void getMFACode(MultiFactorAuthenticationContinuation continuation) {
            Log.wtf((String)LOG_TAG, (String)"Refresh flow can not trigger request for MFA code.");
        }

        public void authenticationChallenge(ChallengeContinuation continuation) {
            Log.wtf((String)LOG_TAG, (String)"Refresh flow can not trigger request for authentication challenge.");
        }

        public void onFailure(Exception exception) {
            Log.e((String)LOG_TAG, (String)"Can't refresh session.", (Throwable)exception);
        }
    }

    public static final class AttributeKeys {
        public static final String USERNAME = "username";
        public static final String PASSWORD = "password";
        public static final String VERIFICATION_CODE = "verification_code";
        public static final String GIVEN_NAME = "given_name";
        public static final String EMAIL_ADDRESS = "email";
        public static final String PHONE_NUMBER = "phone_number";
        public static final String BACKGROUND_COLOR = "signInBackgroundColor";
    }
}

