/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.userpools;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import com.amazonaws.mobile.auth.core.signin.ui.DisplayUtils;
import com.amazonaws.mobile.auth.core.signin.ui.SplitBackgroundDrawable;
import com.amazonaws.mobile.auth.userpools.FormView;
import com.amazonaws.mobile.auth.userpools.R;
import com.amazonaws.mobile.auth.userpools.UserPoolFormConstants;

public class SignUpConfirmView
extends LinearLayout {
    private FormView confirmForm;
    private EditText userNameEditText;
    private EditText confirmCodeEditText;
    private SplitBackgroundDrawable splitBackgroundDrawable;

    public SignUpConfirmView(Context context) {
        this(context, null);
    }

    public SignUpConfirmView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignUpConfirmView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int backgroundColor;
        this.setOrientation(1);
        if (this.isInEditMode()) {
            backgroundColor = -12303292;
        } else {
            TypedArray styledAttributes = context.obtainStyledAttributes(attrs, R.styleable.SignUpConfirmView);
            backgroundColor = styledAttributes.getInt(0, -12303292);
            styledAttributes.recycle();
        }
        this.splitBackgroundDrawable = new SplitBackgroundDrawable(0, this.getBackgroundColor(context, backgroundColor));
    }

    private int getBackgroundColor(Context context, int defaultBackgroundColor) {
        Intent intent = ((Activity)context).getIntent();
        return intent.getIntExtra("signInBackgroundColor", defaultBackgroundColor);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.confirmForm = (FormView)this.findViewById(R.id.signup_confirm_form);
        this.userNameEditText = this.confirmForm.addFormField(this.getContext(), 97, this.getContext().getString(R.string.username_text));
        this.confirmCodeEditText = this.confirmForm.addFormField(this.getContext(), 2, this.getContext().getString(R.string.sign_up_confirm_code));
        this.setupConfirmButtonColor();
    }

    private void setupConfirmButtonColor() {
        Button confirmButton = (Button)this.findViewById(R.id.confirm_account_button);
        confirmButton.setBackgroundDrawable((Drawable)DisplayUtils.getRoundedRectangleBackground((int)UserPoolFormConstants.FORM_BUTTON_CORNER_RADIUS, (int)-12215809));
        LinearLayout.LayoutParams signUpButtonLayoutParams = (LinearLayout.LayoutParams)confirmButton.getLayoutParams();
        signUpButtonLayoutParams.setMargins(this.confirmForm.getFormShadowMargin(), signUpButtonLayoutParams.topMargin, this.confirmForm.getFormShadowMargin(), signUpButtonLayoutParams.bottomMargin);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int maxWidth = Math.min((int)((double)parentWidth * 0.85), UserPoolFormConstants.MAX_FORM_WIDTH_IN_PIXELS);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)maxWidth, (int)Integer.MIN_VALUE), heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.setupSplitBackground();
    }

    private void setupSplitBackground() {
        this.splitBackgroundDrawable.setSplitPointDistanceFromTop(this.confirmForm.getTop() + this.confirmForm.getMeasuredHeight() / 2);
        ((ViewGroup)this.getParent()).setBackgroundDrawable((Drawable)this.splitBackgroundDrawable);
    }

    public EditText getUserNameEditText() {
        return this.userNameEditText;
    }

    public EditText getConfirmCodeEditText() {
        return this.confirmCodeEditText;
    }
}

