/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.userpools;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.amazonaws.mobile.auth.core.signin.ui.DisplayUtils;
import com.amazonaws.mobile.auth.core.signin.ui.SplitBackgroundDrawable;
import com.amazonaws.mobile.auth.userpools.FormView;
import com.amazonaws.mobile.auth.userpools.R;
import com.amazonaws.mobile.auth.userpools.UserPoolFormConstants;

public class SignUpView
extends LinearLayout {
    private TextView signUpMessage;
    private Button signUpButton;
    private FormView signUpForm;
    private EditText userNameEditText;
    private EditText passwordEditText;
    private EditText givenNameEditText;
    private EditText emailEditText;
    private EditText phoneEditText;
    private SplitBackgroundDrawable splitBackgroundDrawable;

    public SignUpView(Context context) {
        this(context, null);
    }

    public SignUpView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignUpView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int backgroundColor;
        this.setOrientation(1);
        if (this.isInEditMode()) {
            backgroundColor = -12303292;
        } else {
            TypedArray styledAttributes = context.obtainStyledAttributes(attrs, R.styleable.SignUpView);
            backgroundColor = styledAttributes.getInt(0, -12303292);
            styledAttributes.recycle();
        }
        this.splitBackgroundDrawable = new SplitBackgroundDrawable(0, this.getBackgroundColor(context, backgroundColor));
    }

    private int getBackgroundColor(Context context, int defaultBackgroundColor) {
        Intent intent = ((Activity)context).getIntent();
        return intent.getIntExtra("signInBackgroundColor", defaultBackgroundColor);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.signUpForm = (FormView)this.findViewById(R.id.signup_form);
        this.userNameEditText = this.signUpForm.addFormField(this.getContext(), 97, this.getContext().getString(R.string.username_text));
        this.passwordEditText = this.signUpForm.addFormField(this.getContext(), 129, this.getContext().getString(R.string.sign_in_password));
        this.givenNameEditText = this.signUpForm.addFormField(this.getContext(), 97, this.getContext().getString(R.string.given_name_text));
        this.emailEditText = this.signUpForm.addFormField(this.getContext(), 33, this.getContext().getString(R.string.email_address_text));
        this.phoneEditText = this.signUpForm.addFormField(this.getContext(), 3, this.getContext().getString(R.string.phone_number_text));
        this.signUpMessage = (TextView)this.findViewById(R.id.signup_message);
        this.signUpButton = (Button)this.findViewById(R.id.signup_button);
        this.setupSignUpButtonBackground();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int maxWidth = Math.min((int)((double)parentWidth * 0.85), UserPoolFormConstants.MAX_FORM_WIDTH_IN_PIXELS);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)maxWidth, (int)Integer.MIN_VALUE), heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.setupSplitBackground();
    }

    private void setupSignUpButtonBackground() {
        this.signUpButton.setBackgroundDrawable((Drawable)DisplayUtils.getRoundedRectangleBackground((int)UserPoolFormConstants.FORM_BUTTON_CORNER_RADIUS, (int)-12215809));
        LinearLayout.LayoutParams signUpButtonLayoutParams = (LinearLayout.LayoutParams)this.signUpButton.getLayoutParams();
        signUpButtonLayoutParams.setMargins(this.signUpForm.getFormShadowMargin(), signUpButtonLayoutParams.topMargin, this.signUpForm.getFormShadowMargin(), signUpButtonLayoutParams.bottomMargin);
    }

    private void setupSplitBackground() {
        this.splitBackgroundDrawable.setSplitPointDistanceFromTop(this.signUpForm.getTop() + this.signUpForm.getMeasuredHeight() / 2);
        ((ViewGroup)this.getParent()).setBackgroundDrawable((Drawable)this.splitBackgroundDrawable);
    }

    public String getUserName() {
        return this.userNameEditText.getText().toString();
    }

    public String getPassword() {
        return this.passwordEditText.getText().toString();
    }

    public String getGivenName() {
        return this.givenNameEditText.getText().toString();
    }

    public String getEmail() {
        return this.emailEditText.getText().toString();
    }

    public String getPhone() {
        return this.phoneEditText.getText().toString();
    }
}

