/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.userpools;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.amazonaws.mobile.auth.core.IdentityProvider;
import com.amazonaws.mobile.auth.core.internal.util.ViewHelper;
import com.amazonaws.mobile.auth.core.signin.SignInProvider;
import com.amazonaws.mobile.auth.core.signin.SignInProviderResultHandler;
import com.amazonaws.mobile.auth.userpools.ForceChangePasswordActivity;
import com.amazonaws.mobile.auth.userpools.ForgotPasswordActivity;
import com.amazonaws.mobile.auth.userpools.MFAActivity;
import com.amazonaws.mobile.auth.userpools.R;
import com.amazonaws.mobile.auth.userpools.SignUpActivity;
import com.amazonaws.mobile.auth.userpools.SignUpConfirmActivity;
import com.amazonaws.mobile.auth.userpools.UserPoolSignInView;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoDevice;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserCodeDeliveryDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserPool;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserSession;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.AuthenticationContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.AuthenticationDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ChallengeContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ForgotPasswordContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.MultiFactorAuthenticationContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.NewPasswordContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.ForgotPasswordHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.GenericHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.VerificationHandler;
import com.amazonaws.services.cognitoidentityprovider.model.InvalidParameterException;
import com.amazonaws.services.cognitoidentityprovider.model.NotAuthorizedException;
import com.amazonaws.services.cognitoidentityprovider.model.UserNotConfirmedException;
import com.amazonaws.services.cognitoidentityprovider.model.UserNotFoundException;
import org.json.JSONException;

public class CognitoUserPoolsSignInProvider
implements SignInProvider {
    private String signUpConfirmationDestination;
    private NewPasswordContinuation mForceChangePasswordContinuation;
    private static final String LOG_TAG = CognitoUserPoolsSignInProvider.class.getSimpleName();
    private static final int REQUEST_CODE_START = 10608;
    private static final int PASSWORD_MIN_LENGTH = 6;
    private static final String USERPOOLS_EXCEPTION_PREFIX = "(Service";
    private SignInProviderResultHandler resultsHandler;
    private ForgotPasswordContinuation forgotPasswordContinuation;
    private MultiFactorAuthenticationContinuation multiFactorAuthenticationContinuation;
    private Context context;
    private Activity activity;
    private String username;
    private String password;
    private String verificationCode;
    private String cognitoLoginKey;
    private CognitoUserPool cognitoUserPool;
    private CognitoUserSession cognitoUserSession;
    private AWSConfiguration awsConfiguration;
    private static int backgroundColor;
    private static boolean isBackgroundColorFullScreenEnabled;
    private static String fontFamily;
    private ForgotPasswordHandler forgotPasswordHandler = new ForgotPasswordHandler(){

        public void onSuccess() {
            Log.d((String)LOG_TAG, (String)"Password change succeeded.");
            ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_forgot_password), (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.password_change_success));
            CognitoUser cognitoUser = CognitoUserPoolsSignInProvider.this.cognitoUserPool.getUser(CognitoUserPoolsSignInProvider.this.username);
            cognitoUser.getSessionInBackground(CognitoUserPoolsSignInProvider.this.authenticationHandler);
        }

        public void getResetCode(ForgotPasswordContinuation continuation) {
            CognitoUserPoolsSignInProvider.this.forgotPasswordContinuation = continuation;
            Intent intent = new Intent(CognitoUserPoolsSignInProvider.this.context, ForgotPasswordActivity.class);
            CognitoUserPoolsSignInProvider.this.activity.startActivityForResult(intent, RequestCodes.FORGOT_PASSWORD_REQUEST_CODE.value);
        }

        public void onFailure(Exception exception) {
            Log.e((String)LOG_TAG, (String)"Password change failed.", (Throwable)exception);
            String message = exception instanceof InvalidParameterException ? CognitoUserPoolsSignInProvider.this.activity.getString(R.string.password_change_no_verification_failed) : CognitoUserPoolsSignInProvider.getErrorMessageFromException(exception);
            ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_forgot_password), (String)(CognitoUserPoolsSignInProvider.this.activity.getString(R.string.password_change_failed) + " " + message));
        }
    };
    private GenericHandler signUpConfirmationHandler = new GenericHandler(){

        public void onSuccess() {
            Log.i((String)LOG_TAG, (String)"Confirmed.");
            ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_sign_up_confirm), (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.sign_up_confirm_success));
            CognitoUser cognitoUser = CognitoUserPoolsSignInProvider.this.cognitoUserPool.getUser(CognitoUserPoolsSignInProvider.this.username);
            cognitoUser.getSessionInBackground(CognitoUserPoolsSignInProvider.this.authenticationHandler);
        }

        public void onFailure(Exception exception) {
            Log.e((String)LOG_TAG, (String)"Failed to confirm user.", (Throwable)exception);
            ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_sign_up_confirm), (String)(CognitoUserPoolsSignInProvider.this.activity.getString(R.string.sign_up_confirm_failed) + " " + CognitoUserPoolsSignInProvider.getErrorMessageFromException(exception)));
        }
    };
    private AuthenticationHandler authenticationHandler = new AuthenticationHandler(){

        public void onSuccess(CognitoUserSession userSession, CognitoDevice newDevice) {
            Log.i((String)LOG_TAG, (String)("Logged in. " + userSession.getIdToken()));
            CognitoUserPoolsSignInProvider.this.cognitoUserSession = userSession;
            if (null != CognitoUserPoolsSignInProvider.this.resultsHandler) {
                CognitoUserPoolsSignInProvider.this.resultsHandler.onSuccess((IdentityProvider)CognitoUserPoolsSignInProvider.this);
            }
        }

        public void getAuthenticationDetails(AuthenticationContinuation authenticationContinuation, String userId) {
            if (null != CognitoUserPoolsSignInProvider.this.username && null != CognitoUserPoolsSignInProvider.this.password) {
                AuthenticationDetails authenticationDetails = new AuthenticationDetails(CognitoUserPoolsSignInProvider.this.username, CognitoUserPoolsSignInProvider.this.password, null);
                authenticationContinuation.setAuthenticationDetails(authenticationDetails);
                authenticationContinuation.continueTask();
            }
        }

        public void getMFACode(MultiFactorAuthenticationContinuation continuation) {
            CognitoUserPoolsSignInProvider.this.multiFactorAuthenticationContinuation = continuation;
            Intent intent = new Intent(CognitoUserPoolsSignInProvider.this.context, MFAActivity.class);
            CognitoUserPoolsSignInProvider.this.activity.startActivityForResult(intent, RequestCodes.MFA_REQUEST_CODE.value);
        }

        public void authenticationChallenge(ChallengeContinuation continuation) {
            if (!(continuation instanceof NewPasswordContinuation)) {
                throw new UnsupportedOperationException("Not supported in this sample.");
            }
            CognitoUserPoolsSignInProvider.this.mForceChangePasswordContinuation = (NewPasswordContinuation)continuation;
            Intent intent = new Intent(CognitoUserPoolsSignInProvider.this.context, ForceChangePasswordActivity.class);
            CognitoUserPoolsSignInProvider.this.activity.startActivityForResult(intent, RequestCodes.FORCE_CHANGE_PASSWORD_REQUEST_CODE.value);
        }

        public void onFailure(Exception exception) {
            Log.e((String)LOG_TAG, (String)"Failed to login.", (Throwable)exception);
            if (exception instanceof UserNotConfirmedException) {
                CognitoUserPoolsSignInProvider.this.resendConfirmationCode();
                return;
            }
            String message = exception instanceof UserNotFoundException ? CognitoUserPoolsSignInProvider.this.activity.getString(R.string.user_does_not_exist) : (exception instanceof NotAuthorizedException ? CognitoUserPoolsSignInProvider.this.activity.getString(R.string.incorrect_username_or_password) : CognitoUserPoolsSignInProvider.getErrorMessageFromException(exception));
            if (null != CognitoUserPoolsSignInProvider.this.resultsHandler) {
                ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_sign_in), (String)(CognitoUserPoolsSignInProvider.this.activity.getString(R.string.login_failed) + " " + message));
                CognitoUserPoolsSignInProvider.this.resultsHandler.onError((IdentityProvider)CognitoUserPoolsSignInProvider.this, exception);
            }
        }
    };

    private void startVerificationActivity() {
        Intent intent = new Intent(this.context, SignUpConfirmActivity.class);
        intent.putExtra("username", this.username);
        intent.putExtra("destination", this.signUpConfirmationDestination);
        this.activity.startActivityForResult(intent, RequestCodes.VERIFICATION_REQUEST_CODE.value);
    }

    private void resendConfirmationCode() {
        CognitoUser cognitoUser = this.cognitoUserPool.getUser(this.username);
        cognitoUser.resendConfirmationCodeInBackground(new VerificationHandler(){

            public void onSuccess(CognitoUserCodeDeliveryDetails verificationCodeDeliveryMedium) {
                CognitoUserPoolsSignInProvider.this.startVerificationActivity();
            }

            public void onFailure(Exception exception) {
                if (null != CognitoUserPoolsSignInProvider.this.resultsHandler) {
                    ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_sign_in), (String)(CognitoUserPoolsSignInProvider.this.activity.getString(R.string.login_failed) + "\nUser was not verified and resending confirmation code failed.\n" + CognitoUserPoolsSignInProvider.getErrorMessageFromException(exception)));
                    CognitoUserPoolsSignInProvider.this.resultsHandler.onError((IdentityProvider)CognitoUserPoolsSignInProvider.this, exception);
                }
            }
        });
    }

    public void initialize(Context context, AWSConfiguration awsConfiguration) {
        this.context = context;
        this.awsConfiguration = awsConfiguration;
        Log.d((String)LOG_TAG, (String)"Initializing Cognito User Pools");
        this.cognitoUserPool = new CognitoUserPool(context, awsConfiguration);
        this.cognitoLoginKey = "cognito-idp." + this.getValueFromConfig("Region") + ".amazonaws.com/" + this.cognitoUserPool.getUserPoolId();
    }

    protected String getValueFromConfig(String valueName) {
        try {
            return this.awsConfiguration.optJsonObject("CognitoUserPool").getString(valueName);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Cannot find the CognitoUserPool " + valueName + " from the AWSConfiguration file.", e);
        }
    }

    public boolean isRequestCodeOurs(int requestCode) {
        return RequestCodes.valueOf(requestCode) != null;
    }

    public void handleActivityResult(int requestCode, int resultCode, Intent data) {
        RequestCodes requestCodeEnum = RequestCodes.valueOf(requestCode);
        if (-1 == resultCode && requestCodeEnum != null) {
            switch (requestCodeEnum) {
                case FORGOT_PASSWORD_REQUEST_CODE: {
                    this.password = data.getStringExtra("password");
                    this.verificationCode = data.getStringExtra("verification_code");
                    if (this.password.length() < 6) {
                        ViewHelper.showDialog((Activity)this.activity, (String)this.activity.getString(R.string.title_activity_forgot_password), (String)(this.activity.getString(R.string.password_change_failed) + " " + this.activity.getString(R.string.password_length_validation_failed)));
                        return;
                    }
                    Log.d((String)LOG_TAG, (String)("verificationCode = " + this.verificationCode));
                    this.forgotPasswordContinuation.setPassword(this.password);
                    this.forgotPasswordContinuation.setVerificationCode(this.verificationCode);
                    this.forgotPasswordContinuation.continueTask();
                    break;
                }
                case SIGN_UP_REQUEST_CODE: {
                    this.username = data.getStringExtra("username");
                    this.password = data.getStringExtra("password");
                    boolean isSignUpConfirmed = data.getBooleanExtra("isSignUpConfirmed", true);
                    this.signUpConfirmationDestination = data.getStringExtra("destination");
                    Log.d((String)LOG_TAG, (String)("sign up result username = " + this.username));
                    if (isSignUpConfirmed) {
                        Log.d((String)LOG_TAG, (String)("Signed up. User ID = " + this.username));
                        ViewHelper.showDialog((Activity)this.activity, (String)this.activity.getString(R.string.title_activity_sign_up), (String)(this.activity.getString(R.string.sign_up_success) + " " + this.username));
                        this.signInUser();
                        break;
                    }
                    Log.w((String)LOG_TAG, (String)"Additional confirmation for sign up.");
                    this.startVerificationActivity();
                    break;
                }
                case MFA_REQUEST_CODE: {
                    this.verificationCode = data.getStringExtra("verification_code");
                    if (this.verificationCode.length() < 1) {
                        ViewHelper.showDialog((Activity)this.activity, (String)this.activity.getString(R.string.title_activity_mfa), (String)(this.activity.getString(R.string.mfa_failed) + " " + this.activity.getString(R.string.mfa_code_empty)));
                        return;
                    }
                    Log.d((String)LOG_TAG, (String)("verificationCode = " + this.verificationCode));
                    this.multiFactorAuthenticationContinuation.setMfaCode(this.verificationCode);
                    this.multiFactorAuthenticationContinuation.continueTask();
                    break;
                }
                case VERIFICATION_REQUEST_CODE: {
                    Log.d((String)LOG_TAG, (String)"handleActivityResult: VERIFICATION_REQUEST_CODE");
                    this.username = data.getStringExtra("username");
                    this.verificationCode = data.getStringExtra("verification_code");
                    if (this.username.length() < 1) {
                        ViewHelper.showDialog((Activity)this.activity, (String)this.activity.getString(R.string.title_activity_sign_up_confirm), (String)(this.activity.getString(R.string.sign_up_confirm_title) + " " + this.activity.getString(R.string.sign_up_username_missing)));
                        return;
                    }
                    if (this.verificationCode.length() < 1) {
                        ViewHelper.showDialog((Activity)this.activity, (String)this.activity.getString(R.string.title_activity_sign_up_confirm), (String)(this.activity.getString(R.string.sign_up_confirm_title) + " " + this.activity.getString(R.string.sign_up_confirm_code_missing)));
                        return;
                    }
                    Log.d((String)LOG_TAG, (String)("username = " + this.username));
                    Log.d((String)LOG_TAG, (String)("verificationCode = " + this.verificationCode));
                    CognitoUser cognitoUser = this.cognitoUserPool.getUser(this.username);
                    cognitoUser.confirmSignUpInBackground(this.verificationCode, true, this.signUpConfirmationHandler);
                    break;
                }
                case FORCE_CHANGE_PASSWORD_REQUEST_CODE: {
                    Log.d((String)LOG_TAG, (String)"handleActivityResult: FORCE_CHANGE_PASSWORD_REQUEST_CODE");
                    this.password = data.getStringExtra("password");
                    this.mForceChangePasswordContinuation.setPassword(this.password);
                    this.mForceChangePasswordContinuation.continueTask();
                    break;
                }
                default: {
                    Log.e((String)LOG_TAG, (String)"Unknown Request Code sent.");
                }
            }
        }
    }

    protected void signInUser() {
        CognitoUser cognitoUser = this.cognitoUserPool.getUser(this.username);
        cognitoUser.getSessionInBackground(this.authenticationHandler);
    }

    public View.OnClickListener initializeSignInButton(Activity signInActivity, View buttonView, SignInProviderResultHandler providerResultsHandler) {
        this.activity = signInActivity;
        this.resultsHandler = providerResultsHandler;
        final UserPoolSignInView userPoolSignInView = (UserPoolSignInView)this.activity.findViewById(R.id.user_pool_sign_in_view_id);
        backgroundColor = userPoolSignInView.getBackgroundColor();
        fontFamily = userPoolSignInView.getFontFamily();
        isBackgroundColorFullScreenEnabled = userPoolSignInView.isBackgroundColorFullScreen();
        userPoolSignInView.getSignUpTextView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SignUpActivity.startActivity(CognitoUserPoolsSignInProvider.this.activity, RequestCodes.SIGN_UP_REQUEST_CODE.value);
            }
        });
        TextView forgotPasswordTextView = userPoolSignInView.getForgotPasswordTextView();
        forgotPasswordTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CognitoUserPoolsSignInProvider.this.username = userPoolSignInView.getEnteredUserName();
                if (CognitoUserPoolsSignInProvider.this.username.length() < 1) {
                    Log.w((String)LOG_TAG, (String)"Missing username.");
                    ViewHelper.showDialog((Activity)CognitoUserPoolsSignInProvider.this.activity, (String)CognitoUserPoolsSignInProvider.this.activity.getString(R.string.title_activity_sign_in), (String)"Missing username.");
                    return;
                }
                CognitoUser cognitoUser = CognitoUserPoolsSignInProvider.this.cognitoUserPool.getUser(CognitoUserPoolsSignInProvider.this.username);
                cognitoUser.forgotPasswordInBackground(CognitoUserPoolsSignInProvider.this.forgotPasswordHandler);
            }
        });
        View.OnClickListener signInClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                CognitoUserPoolsSignInProvider.this.username = userPoolSignInView.getEnteredUserName();
                CognitoUserPoolsSignInProvider.this.password = userPoolSignInView.getEnteredPassword();
                CognitoUserPoolsSignInProvider.this.signInUser();
            }
        };
        buttonView.setOnClickListener(signInClickListener);
        return signInClickListener;
    }

    public String getDisplayName() {
        return "Amazon Cognito Your User Pools";
    }

    public String getCognitoLoginKey() {
        return this.cognitoLoginKey;
    }

    public boolean refreshUserSignInState() {
        if (null != this.cognitoUserSession && this.cognitoUserSession.isValid()) {
            return true;
        }
        RefreshSessionAuthenticationHandler refreshSessionAuthenticationHandler = new RefreshSessionAuthenticationHandler();
        this.cognitoUserPool.getCurrentUser().getSession((AuthenticationHandler)refreshSessionAuthenticationHandler);
        if (null != refreshSessionAuthenticationHandler.getUserSession()) {
            this.cognitoUserSession = refreshSessionAuthenticationHandler.getUserSession();
            Log.i((String)LOG_TAG, (String)"refreshUserSignInState: Signed in with Cognito.");
            return true;
        }
        Log.i((String)LOG_TAG, (String)"refreshUserSignInState: Not signed in with Cognito.");
        this.cognitoUserSession = null;
        return false;
    }

    public String getToken() {
        return null == this.cognitoUserSession ? null : this.cognitoUserSession.getIdToken().getJWTToken();
    }

    public String refreshToken() {
        if (this.cognitoUserSession != null && !this.cognitoUserSession.isValid()) {
            RefreshSessionAuthenticationHandler refreshSessionAuthenticationHandler = new RefreshSessionAuthenticationHandler();
            this.cognitoUserPool.getCurrentUser().getSession((AuthenticationHandler)refreshSessionAuthenticationHandler);
            if (null != refreshSessionAuthenticationHandler.getUserSession()) {
                this.cognitoUserSession = refreshSessionAuthenticationHandler.getUserSession();
            } else {
                Log.e((String)LOG_TAG, (String)"Could not refresh the Cognito User Pool Token.");
            }
        }
        return this.getToken();
    }

    public void signOut() {
        if (null != this.cognitoUserPool && null != this.cognitoUserPool.getCurrentUser()) {
            this.cognitoUserPool.getCurrentUser().signOut();
            this.cognitoUserSession = null;
            this.username = null;
            this.password = null;
        }
    }

    public CognitoUserPool getCognitoUserPool() {
        return this.cognitoUserPool;
    }

    static String getErrorMessageFromException(Exception exception) {
        String message = exception.getLocalizedMessage();
        if (message == null) {
            return exception.getMessage();
        }
        int index = message.indexOf(USERPOOLS_EXCEPTION_PREFIX);
        if (index == -1) {
            return message;
        }
        return message.substring(0, index);
    }

    static boolean isBackgroundColorFullScreen() {
        return isBackgroundColorFullScreenEnabled;
    }

    static int getBackgroundColor() {
        return backgroundColor;
    }

    static String getFontFamily() {
        return fontFamily;
    }

    private static class RefreshSessionAuthenticationHandler
    implements AuthenticationHandler {
        private CognitoUserSession userSession = null;

        private RefreshSessionAuthenticationHandler() {
        }

        private CognitoUserSession getUserSession() {
            return this.userSession;
        }

        public void onSuccess(CognitoUserSession userSession, CognitoDevice newDevice) {
            this.userSession = userSession;
        }

        public void getAuthenticationDetails(AuthenticationContinuation authenticationContinuation, String UserId) {
            Log.d((String)LOG_TAG, (String)"Can't refresh the session silently, due to authentication details needed.");
        }

        public void getMFACode(MultiFactorAuthenticationContinuation continuation) {
            Log.wtf((String)LOG_TAG, (String)"Refresh flow can not trigger request for MFA code.");
        }

        public void authenticationChallenge(ChallengeContinuation continuation) {
            Log.wtf((String)LOG_TAG, (String)"Refresh flow can not trigger request for authentication challenge.");
        }

        public void onFailure(Exception exception) {
            Log.e((String)LOG_TAG, (String)"Can't refresh session.", (Throwable)exception);
        }
    }

    private static enum RequestCodes {
        FORGOT_PASSWORD_REQUEST_CODE(10650),
        SIGN_UP_REQUEST_CODE(10651),
        MFA_REQUEST_CODE(10652),
        VERIFICATION_REQUEST_CODE(10653),
        FORCE_CHANGE_PASSWORD_REQUEST_CODE(10654);

        public final int value;

        private RequestCodes(int value) {
            this.value = value;
        }

        static RequestCodes valueOf(int value) {
            Log.e((String)LOG_TAG, (String)("valueOf: " + value), (Throwable)new RuntimeException(""));
            for (RequestCodes requestCodes : RequestCodes.values()) {
                Log.e((String)LOG_TAG, (String)("valueOf: compare " + requestCodes.value));
                if (value != requestCodes.value) continue;
                return requestCodes;
            }
            return null;
        }
    }

    public static final class AttributeKeys {
        public static final String USERNAME = "username";
        public static final String PASSWORD = "password";
        public static final String VERIFICATION_CODE = "verification_code";
        public static final String GIVEN_NAME = "given_name";
        public static final String EMAIL_ADDRESS = "email";
        public static final String PHONE_NUMBER = "phone_number";
        public static final String BACKGROUND_COLOR = "signInBackgroundColor";
        public static final String FULL_SCREEN_BACKGROUND_COLOR = "fullScreenBackgroundColor";
        public static final String FONT_FAMILY = "fontFamily";
        public static final String IS_SIGN_UP_CONFIRMED = "isSignUpConfirmed";
        public static final String CONFIRMATION_DESTINATION = "destination";
    }
}

