/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.userpools;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.amazonaws.mobile.auth.core.signin.ui.BackgroundDrawable;
import com.amazonaws.mobile.auth.core.signin.ui.DisplayUtils;
import com.amazonaws.mobile.auth.core.signin.ui.SplitBackgroundDrawable;
import com.amazonaws.mobile.auth.userpools.CognitoUserPoolsSignInProvider;
import com.amazonaws.mobile.auth.userpools.FormView;
import com.amazonaws.mobile.auth.userpools.R;
import com.amazonaws.mobile.auth.userpools.UserPoolFormConstants;

public class SignUpView
extends LinearLayout {
    private static final String LOG_TAG = SignUpView.class.getSimpleName();
    private TextView signUpMessage;
    private Button signUpButton;
    private FormView signUpForm;
    private EditText userNameEditText;
    private EditText passwordEditText;
    private EditText givenNameEditText;
    private EditText emailEditText;
    private EditText phoneEditText;
    private SplitBackgroundDrawable splitBackgroundDrawable;
    private BackgroundDrawable backgroundDrawable;
    private String fontFamily;
    private boolean fullScreenBackgroundColor;
    private Typeface typeFace;
    private int backgroundColor;

    public SignUpView(Context context) {
        this(context, null);
    }

    public SignUpView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignUpView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        if (this.isInEditMode()) {
            int backgroundColor = -12303292;
        } else {
            TypedArray styledAttributes = context.obtainStyledAttributes(attrs, R.styleable.SignUpView);
            int backgroundColor = styledAttributes.getInt(0, -12303292);
            styledAttributes.recycle();
        }
        this.fontFamily = CognitoUserPoolsSignInProvider.getFontFamily();
        this.typeFace = Typeface.create((String)this.fontFamily, (int)0);
        this.fullScreenBackgroundColor = CognitoUserPoolsSignInProvider.isBackgroundColorFullScreen();
        this.backgroundColor = CognitoUserPoolsSignInProvider.getBackgroundColor();
        if (this.fullScreenBackgroundColor) {
            this.backgroundDrawable = new BackgroundDrawable(this.backgroundColor);
        } else {
            this.splitBackgroundDrawable = new SplitBackgroundDrawable(0, this.backgroundColor);
        }
    }

    private void setupFontFamily() {
        if (this.typeFace != null) {
            Log.d((String)LOG_TAG, (String)("Setup font in SignUpView: " + this.fontFamily));
            this.userNameEditText.setTypeface(this.typeFace);
            this.passwordEditText.setTypeface(this.typeFace);
            this.givenNameEditText.setTypeface(this.typeFace);
            this.emailEditText.setTypeface(this.typeFace);
            this.phoneEditText.setTypeface(this.typeFace);
            this.signUpMessage.setTypeface(this.typeFace);
            this.signUpButton.setTypeface(this.typeFace);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.signUpForm = (FormView)this.findViewById(R.id.signup_form);
        this.userNameEditText = this.signUpForm.addFormField(this.getContext(), 97, this.getContext().getString(R.string.username_text));
        this.passwordEditText = this.signUpForm.addFormField(this.getContext(), 129, this.getContext().getString(R.string.sign_in_password));
        this.givenNameEditText = this.signUpForm.addFormField(this.getContext(), 97, this.getContext().getString(R.string.given_name_text));
        this.emailEditText = this.signUpForm.addFormField(this.getContext(), 33, this.getContext().getString(R.string.email_address_text));
        this.phoneEditText = this.signUpForm.addFormField(this.getContext(), 3, this.getContext().getString(R.string.phone_number_text));
        this.signUpMessage = (TextView)this.findViewById(R.id.signup_message);
        this.signUpButton = (Button)this.findViewById(R.id.signup_button);
        this.setupSignUpButtonBackground();
        this.setupFontFamily();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int maxWidth = Math.min((int)((double)parentWidth * 0.85), UserPoolFormConstants.MAX_FORM_WIDTH_IN_PIXELS);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)maxWidth, (int)Integer.MIN_VALUE), heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.setupBackground();
    }

    private void setupSignUpButtonBackground() {
        this.signUpButton.setBackgroundDrawable((Drawable)DisplayUtils.getRoundedRectangleBackground((int)UserPoolFormConstants.FORM_BUTTON_CORNER_RADIUS, (int)-12215809));
        LinearLayout.LayoutParams signUpButtonLayoutParams = (LinearLayout.LayoutParams)this.signUpButton.getLayoutParams();
        signUpButtonLayoutParams.setMargins(this.signUpForm.getFormShadowMargin(), signUpButtonLayoutParams.topMargin, this.signUpForm.getFormShadowMargin(), signUpButtonLayoutParams.bottomMargin);
    }

    private void setupBackground() {
        if (!this.fullScreenBackgroundColor) {
            this.splitBackgroundDrawable.setSplitPointDistanceFromTop(this.signUpForm.getTop() + this.signUpForm.getMeasuredHeight() / 2);
            ((ViewGroup)this.getParent()).setBackgroundDrawable((Drawable)this.splitBackgroundDrawable);
        } else {
            ((ViewGroup)this.getParent()).setBackgroundDrawable((Drawable)this.backgroundDrawable);
        }
    }

    public String getUserName() {
        return this.userNameEditText.getText().toString();
    }

    public String getPassword() {
        return this.passwordEditText.getText().toString();
    }

    public void setPassword(String password) {
        this.passwordEditText.setText((CharSequence)password);
    }

    public String getGivenName() {
        return this.givenNameEditText.getText().toString();
    }

    public String getEmail() {
        return this.emailEditText.getText().toString();
    }

    public String getPhone() {
        return this.phoneEditText.getText().toString();
    }
}

