/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoauth;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.util.Patterns;
import com.amazonaws.internal.keyvaluestore.AWSKeyValueStore;
import com.amazonaws.mobileconnectors.cognitoauth.AuthClient;
import com.amazonaws.mobileconnectors.cognitoauth.exceptions.AuthInvalidParameterException;
import com.amazonaws.mobileconnectors.cognitoauth.handlers.AuthHandler;
import com.amazonaws.mobileconnectors.cognitoauth.util.LocalDataManager;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONObject;

public final class Auth {
    private final Context context;
    private final String userPoolId;
    private final String identityProvider;
    private final String idpIdentifier;
    private final Bundle customTabExtras;
    AWSKeyValueStore awsKeyValueStore;
    private boolean advancedSecurityDataCollectionFlag;
    private final String appWebDomain;
    private final String appId;
    private final String appSecret;
    private final String signInRedirectUri;
    private final String signOutRedirectUri;
    private final Set<String> scopes;
    private AuthClient user;
    private boolean isPersistenceEnabled = true;

    public void setAdvancedSecurityDataCollection(boolean isEnabled) {
        this.advancedSecurityDataCollectionFlag = isEnabled;
    }

    public boolean isAdvancedSecurityDataCollectionEnabled() {
        return this.advancedSecurityDataCollectionFlag;
    }

    public void setPersistenceEnabled(boolean isPersistenceEnabled) {
        this.isPersistenceEnabled = isPersistenceEnabled;
        this.awsKeyValueStore.setPersistenceEnabled(this.isPersistenceEnabled);
    }

    private Auth(Context context, String userPoolId, String appWebDomain, String appId, String appSecret, String signInRedirectUri, String signOutRedirectUri, Set<String> scopes, AuthHandler userHandler, boolean advancedSecurityDataCollectionFlag, String identityProvider, String idpIdentifier, Bundle customTabExtras, boolean isPersistenceEnabled) {
        this.context = context;
        this.appWebDomain = appWebDomain;
        this.appId = appId;
        this.appSecret = appSecret;
        this.signInRedirectUri = signInRedirectUri;
        this.signOutRedirectUri = signOutRedirectUri;
        this.scopes = scopes;
        this.user = new AuthClient(context, this);
        this.user.setUserHandler(userHandler);
        this.userPoolId = userPoolId;
        this.advancedSecurityDataCollectionFlag = advancedSecurityDataCollectionFlag;
        this.identityProvider = identityProvider;
        this.idpIdentifier = idpIdentifier;
        this.customTabExtras = customTabExtras;
        this.isPersistenceEnabled = isPersistenceEnabled;
        this.awsKeyValueStore = new AWSKeyValueStore(context, "CognitoIdentityProviderCache", this.isPersistenceEnabled);
        this.getCurrentUser();
    }

    public Auth getCurrentUser() {
        this.user.setUsername(LocalDataManager.getLastAuthUser(this.awsKeyValueStore, this.context, this.appId));
        return this;
    }

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public String getAppWebDomain() {
        return this.appWebDomain;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public String getSignInRedirectUri() {
        return this.signInRedirectUri;
    }

    public String getSignOutRedirectUri() {
        return this.signOutRedirectUri;
    }

    public String getIdentityProvider() {
        return this.identityProvider;
    }

    public String getIdpIdentifier() {
        return this.idpIdentifier;
    }

    public Bundle getCustomTabExtras() {
        return this.customTabExtras;
    }

    public void getSession() {
        this.user.getSession(true);
    }

    public void getSession(boolean launchWebUIIfExpired) {
        this.user.getSession(launchWebUIIfExpired);
    }

    public void setAuthHandler(AuthHandler authHandler) {
        this.user.setUserHandler(authHandler);
    }

    public void signOut() {
        this.user.signOut(false);
    }

    public void signOut(boolean clearLocalTokensOnly) {
        this.user.signOut(clearLocalTokensOnly);
    }

    public boolean isAuthenticated() {
        return this.user.isAuthenticated();
    }

    public void getTokens(Uri uri) {
        this.user.getTokens(uri);
    }

    public Auth setUsername(String username) {
        this.user.setUsername(username);
        return this;
    }

    public void release() {
        this.user.unbindServiceConnection();
    }

    public static final class Builder {
        private Context mAppContext;
        private String mAppWebDomain;
        private String mAppClientId;
        private String mAppSecret;
        private String mSignInRedirect;
        private String mSignOutRedirect;
        private Set<String> mScopes;
        private AuthHandler mUserHandler;
        private String mUserPoolId;
        private String mIdentityProvider;
        private String mIdpIdentifier;
        private Bundle mCustomTabsExtras;
        private boolean mAdvancedSecurityDataCollectionFlag = true;
        private boolean mIsCachingEnabled = true;

        public Builder setPersistenceEnabled(boolean isPersistenceEnabled) {
            this.mIsCachingEnabled = isPersistenceEnabled;
            return this;
        }

        public Builder setAdvancedSecurityDataCollection(boolean advancedSecurityDataCollectionFlag) {
            this.mAdvancedSecurityDataCollectionFlag = advancedSecurityDataCollectionFlag;
            return this;
        }

        public Builder setUserPoolId(String userPoolId) {
            this.mUserPoolId = userPoolId;
            return this;
        }

        public Builder setAppClientId(String mAppClientId) {
            this.mAppClientId = mAppClientId;
            return this;
        }

        public Builder setApplicationContext(Context mAppContext) {
            this.mAppContext = mAppContext;
            return this;
        }

        public Builder setAppClientSecret(String mAppSecret) {
            this.mAppSecret = mAppSecret;
            return this;
        }

        public Builder setAppCognitoWebDomain(String mAppWebDomain) {
            this.mAppWebDomain = mAppWebDomain;
            return this;
        }

        public Builder setSignInRedirect(String mSignInRedirect) {
            this.mSignInRedirect = mSignInRedirect;
            return this;
        }

        public Builder setSignOutRedirect(String mSignOutRedirect) {
            this.mSignOutRedirect = mSignOutRedirect;
            return this;
        }

        public Builder setScopes(Set<String> mScopes) {
            this.mScopes = mScopes;
            return this;
        }

        public Builder setAuthHandler(AuthHandler mUserHandler) {
            this.mUserHandler = mUserHandler;
            return this;
        }

        public Builder setIdentityProvider(String mIdentityProvider) {
            this.mIdentityProvider = mIdentityProvider;
            return this;
        }

        public Builder setIdpIdentifier(String mIdpIdentifier) {
            this.mIdpIdentifier = mIdpIdentifier;
            return this;
        }

        public Builder setCustomTabsExtras(Bundle mCustomTabsExtras) {
            this.mCustomTabsExtras = mCustomTabsExtras;
            return this;
        }

        public Auth build() {
            this.validateCognitoAuthParameters();
            return new Auth(this.mAppContext, this.mUserPoolId, this.mAppWebDomain, this.mAppClientId, this.mAppSecret, this.mSignInRedirect, this.mSignOutRedirect, this.mScopes, this.mUserHandler, this.mAdvancedSecurityDataCollectionFlag, this.mIdentityProvider, this.mIdpIdentifier, this.mCustomTabsExtras, this.mIsCachingEnabled);
        }

        private void validateCognitoAuthParameters() {
            StringBuilder errorStringBuilder = new StringBuilder();
            boolean error = false;
            JSONObject errorMessage = new JSONObject();
            try {
                if (this.mAppContext == null) {
                    errorMessage.put("ApplicationContext", (Object)"cannot be null");
                    error = true;
                }
                if (this.mAppClientId == null || this.mAppClientId.length() < 1) {
                    errorMessage.put("AppClientId", (Object)"invalid");
                    error = true;
                }
                if (!this.isValidDomain(this.mAppWebDomain)) {
                    errorMessage.put("AppCognitoWebDomain", (Object)"invalid");
                    error = true;
                }
                if (this.mSignInRedirect == null) {
                    errorMessage.put("SignInRedirect", (Object)"cannot be null");
                    error = true;
                }
                if (this.mSignOutRedirect == null) {
                    errorMessage.put("SignOutRedirect", (Object)"cannot be null");
                    error = true;
                }
                if (this.mScopes == null) {
                    this.mScopes = new HashSet<String>();
                }
                if (this.mAppSecret != null && this.mAppSecret.length() < 1) {
                    this.mAppSecret = null;
                }
                if (this.mUserHandler == null) {
                    errorMessage.put("AuthHandler", (Object)"cannot be null");
                    error = true;
                }
                if (error) {
                    throw new AuthInvalidParameterException(errorMessage.toString());
                }
            }
            catch (Exception e) {
                throw new AuthInvalidParameterException("validation failed", e);
            }
        }

        private boolean isValidDomain(String uri) {
            if (uri == null) {
                return false;
            }
            return Patterns.DOMAIN_NAME.matcher(uri).matches();
        }
    }
}

