/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoauth;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.support.customtabs.CustomTabsCallback;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import android.text.TextUtils;
import android.util.Log;
import com.amazonaws.cognito.clientcontext.data.UserContextDataProvider;
import com.amazonaws.mobileconnectors.cognitoauth.Auth;
import com.amazonaws.mobileconnectors.cognitoauth.AuthUserSession;
import com.amazonaws.mobileconnectors.cognitoauth.exceptions.AuthInvalidGrantException;
import com.amazonaws.mobileconnectors.cognitoauth.exceptions.AuthNavigationException;
import com.amazonaws.mobileconnectors.cognitoauth.exceptions.AuthServiceException;
import com.amazonaws.mobileconnectors.cognitoauth.handlers.AuthHandler;
import com.amazonaws.mobileconnectors.cognitoauth.util.AuthHttpClient;
import com.amazonaws.mobileconnectors.cognitoauth.util.AuthHttpResponseParser;
import com.amazonaws.mobileconnectors.cognitoauth.util.LocalDataManager;
import com.amazonaws.mobileconnectors.cognitoauth.util.Pkce;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AuthClient {
    private final Context context;
    private final Auth pool;
    private String userId;
    private String proofKey;
    private String proofKeyHash;
    private String state;
    private AuthHandler userHandler;
    private CustomTabsClient mCustomTabsClient;
    private CustomTabsSession mCustomTabsSession;
    private CustomTabsIntent mCustomTabsIntent;
    private CustomTabsServiceConnection mCustomTabsServiceConnection;
    private final CustomTabsCallback customTabsCallback = new CustomTabsCallback(){

        public void onNavigationEvent(int navigationEvent, Bundle extras) {
            super.onNavigationEvent(navigationEvent, extras);
            if (navigationEvent == 6) {
                boolean hasReceivedRedirect = LocalDataManager.hasReceivedRedirect(((AuthClient)AuthClient.this).pool.awsKeyValueStore, AuthClient.this.context, AuthClient.this.pool.getAppId());
                Log.i((String)"AuthClient", (String)("customTab hidden callback, code has already been received: " + hasReceivedRedirect));
                if (!hasReceivedRedirect) {
                    AuthClient.this.userHandler.onFailure(new AuthNavigationException("user cancelled"));
                    LocalDataManager.cacheHasReceivedRedirect(((AuthClient)AuthClient.this).pool.awsKeyValueStore, AuthClient.this.context, AuthClient.this.pool.getAppId(), false);
                }
            }
        }
    };

    protected AuthClient(Context context, Auth pool) {
        this(context, pool, null);
    }

    protected AuthClient(Context context, Auth pool, String username) {
        this.context = context;
        this.pool = pool;
        this.userId = username;
        this.preWarmChrome();
    }

    protected void setUserHandler(AuthHandler handler) {
        if (handler == null) {
            throw new InvalidParameterException("Callback handler cannot be null");
        }
        this.userHandler = handler;
    }

    protected void setUsername(String username) {
        this.userId = username;
    }

    protected void getSession(boolean showSignInIfExpired) {
        try {
            this.proofKey = Pkce.generateRandom();
            this.proofKeyHash = Pkce.generateHash(this.proofKey);
            this.state = Pkce.generateRandom();
        }
        catch (Exception e) {
            this.userHandler.onFailure(e);
        }
        AuthUserSession session = LocalDataManager.getCachedSession(this.pool.awsKeyValueStore, this.context, this.pool.getAppId(), this.userId, this.pool.getScopes());
        if (session.isValidForThreshold()) {
            this.userHandler.onSuccess(session);
            return;
        }
        if (session.getRefreshToken() != null && session.getRefreshToken().getToken() != null) {
            this.refreshSession(session, this.pool.getSignInRedirectUri(), this.pool.getScopes(), this.userHandler);
        } else if (showSignInIfExpired) {
            this.launchCognitoAuth(this.pool.getSignInRedirectUri(), this.pool.getScopes());
        } else {
            this.userHandler.onFailure(new Exception("No cached session"));
        }
    }

    protected String getUsername() {
        return this.userId;
    }

    public void signOut() {
        LocalDataManager.clearCache(this.pool.awsKeyValueStore, this.context, this.pool.getAppId(), this.userId);
        this.launchSignOut(this.pool.getSignOutRedirectUri());
    }

    public void signOut(boolean clearLocalTokensOnly) {
        LocalDataManager.clearCache(this.pool.awsKeyValueStore, this.context, this.pool.getAppId(), this.userId);
        if (!clearLocalTokensOnly) {
            this.launchSignOut(this.pool.getSignOutRedirectUri());
        }
    }

    public boolean isAuthenticated() {
        AuthUserSession session = LocalDataManager.getCachedSession(this.pool.awsKeyValueStore, this.context, this.pool.getAppId(), this.userId, this.pool.getScopes());
        return session.isValidForThreshold();
    }

    public void getTokens(Uri uri) {
        if (uri == null) {
            return;
        }
        LocalDataManager.cacheHasReceivedRedirect(this.pool.awsKeyValueStore, this.context, this.pool.getAppId(), true);
        this.getTokens(uri, this.userHandler);
    }

    public void unbindServiceConnection() {
        if (this.mCustomTabsServiceConnection != null) {
            this.context.unbindService((ServiceConnection)this.mCustomTabsServiceConnection);
        }
    }

    private void getTokens(final Uri uri, final AuthHandler callback) {
        new Thread(new Runnable(){
            final Handler handler;
            Runnable returnCallback;
            {
                this.handler = new Handler(AuthClient.this.context.getMainLooper());
                this.returnCallback = new Runnable(){

                    @Override
                    public void run() {
                        callback.onFailure(new InvalidParameterException());
                    }
                };
            }

            @Override
            public void run() {
                Uri fqdn = new Uri.Builder().scheme("https").authority(AuthClient.this.pool.getAppWebDomain()).appendPath("oauth2").appendPath("token").build();
                String callbackState = uri.getQueryParameter("state");
                if (callbackState != null) {
                    Set<String> tokenScopes = LocalDataManager.getCachedScopes(((AuthClient)AuthClient.this).pool.awsKeyValueStore, AuthClient.this.context, callbackState);
                    String proofKeyPlain = LocalDataManager.getCachedProofKey(((AuthClient)AuthClient.this).pool.awsKeyValueStore, AuthClient.this.context, callbackState);
                    if (proofKeyPlain == null) {
                        return;
                    }
                    final String errorText = uri.getQueryParameter("error");
                    if (errorText != null) {
                        this.returnCallback = new Runnable(){

                            @Override
                            public void run() {
                                callback.onFailure(new AuthServiceException(errorText));
                            }
                        };
                    } else {
                        AuthHttpClient httpClient = new AuthHttpClient();
                        Map httpHeaderParams = AuthClient.this.getHttpHeader();
                        Map httpBodyParams = AuthClient.this.generateTokenExchangeRequest(uri, proofKeyPlain);
                        try {
                            String response = httpClient.httpPost(new URL(fqdn.toString()), httpHeaderParams, httpBodyParams);
                            final AuthUserSession session = AuthHttpResponseParser.parseHttpResponse(response);
                            AuthClient.this.userId = session.getUsername();
                            LocalDataManager.cacheSession(((AuthClient)AuthClient.this).pool.awsKeyValueStore, AuthClient.this.context, AuthClient.this.pool.getAppId(), AuthClient.this.userId, session, tokenScopes);
                            this.returnCallback = new Runnable(){

                                @Override
                                public void run() {
                                    callback.onSuccess(session);
                                }
                            };
                        }
                        catch (Exception e) {
                            this.returnCallback = new Runnable(){

                                @Override
                                public void run() {
                                    callback.onFailure(e);
                                }
                            };
                        }
                    }
                } else {
                    this.returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSignout();
                        }
                    };
                }
                this.handler.post(this.returnCallback);
            }
        }).start();
    }

    private void refreshSession(final AuthUserSession session, final String redirectUri, final Set<String> tokenScopes, final AuthHandler callback) {
        new Thread(new Runnable(){
            final Handler handler;
            Runnable returnCallback;
            {
                this.handler = new Handler(AuthClient.this.context.getMainLooper());
                this.returnCallback = new Runnable(){

                    @Override
                    public void run() {
                        AuthClient.this.launchCognitoAuth(redirectUri, tokenScopes);
                    }
                };
            }

            @Override
            public void run() {
                Uri fqdn = new Uri.Builder().scheme("https").authority(AuthClient.this.pool.getAppWebDomain()).appendPath("oauth2").appendPath("token").build();
                AuthHttpClient httpClient = new AuthHttpClient();
                Map httpHeaderParams = AuthClient.this.getHttpHeader();
                Map httpBodyParams = AuthClient.this.generateTokenRefreshRequest(redirectUri, session);
                try {
                    String response = httpClient.httpPost(new URL(fqdn.toString()), httpHeaderParams, httpBodyParams);
                    AuthUserSession parsedSession = AuthHttpResponseParser.parseHttpResponse(response);
                    final AuthUserSession refreshedSession = new AuthUserSession(parsedSession.getIdToken(), parsedSession.getAccessToken(), session.getRefreshToken());
                    String username = refreshedSession.getUsername();
                    LocalDataManager.cacheSession(((AuthClient)AuthClient.this).pool.awsKeyValueStore, AuthClient.this.context, AuthClient.this.pool.getAppId(), username, refreshedSession, AuthClient.this.pool.getScopes());
                    this.returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(refreshedSession);
                        }
                    };
                }
                catch (AuthInvalidGrantException invg) {
                    this.returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            AuthClient.this.launchCognitoAuth(redirectUri, tokenScopes);
                        }
                    };
                }
                catch (Exception e) {
                    this.returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                this.handler.post(this.returnCallback);
            }
        }).start();
    }

    private Map<String, String> getHttpHeader() {
        HashMap<String, String> httpHeaderParams = new HashMap<String, String>();
        httpHeaderParams.put("Content-Type", "application/x-www-form-urlencoded");
        if (this.pool.getAppSecret() != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.pool.getAppId()).append(":").append(this.pool.getAppSecret());
            httpHeaderParams.put("Authorization", "Basic " + Pkce.encodeBase64(builder.toString()));
        }
        return httpHeaderParams;
    }

    private Map<String, String> generateTokenExchangeRequest(Uri redirectUri, String proofKey) {
        HashMap<String, String> httpBodyParams = new HashMap<String, String>();
        httpBodyParams.put("grant_type", "authorization_code");
        httpBodyParams.put("client_id", this.pool.getAppId());
        httpBodyParams.put("redirect_uri", this.pool.getSignInRedirectUri());
        httpBodyParams.put("code_verifier", proofKey);
        httpBodyParams.put("code", redirectUri.getQueryParameter("code"));
        return httpBodyParams;
    }

    private Map<String, String> generateTokenRefreshRequest(String redirectUri, AuthUserSession session) {
        HashMap<String, String> httpBodyParams = new HashMap<String, String>();
        httpBodyParams.put("grant_type", "refresh_token");
        httpBodyParams.put("redirect_uri", redirectUri);
        httpBodyParams.put("client_id", this.pool.getAppId());
        httpBodyParams.put("refresh_token", session.getRefreshToken().getToken());
        String userContextData = this.getUserContextData();
        if (userContextData != null) {
            httpBodyParams.put("userContextData", userContextData);
        }
        return httpBodyParams;
    }

    private void launchCognitoAuth(String redirectUri, Set<String> tokenScopes) {
        int noOfScopes;
        Uri.Builder builder = new Uri.Builder().scheme("https").authority(this.pool.getAppWebDomain()).appendPath("oauth2").appendPath("authorize").appendQueryParameter("client_id", this.pool.getAppId()).appendQueryParameter("redirect_uri", redirectUri).appendQueryParameter("response_type", "code").appendQueryParameter("code_challenge", this.proofKeyHash).appendQueryParameter("code_challenge_method", "S256").appendQueryParameter("state", this.state).appendQueryParameter("userContextData", this.getUserContextData());
        if (!TextUtils.isEmpty((CharSequence)this.pool.getIdentityProvider())) {
            builder.appendQueryParameter("identity_provider", this.pool.getIdentityProvider());
        }
        if (!TextUtils.isEmpty((CharSequence)this.pool.getIdpIdentifier())) {
            builder.appendQueryParameter("idp_identifier", this.pool.getIdpIdentifier());
        }
        if ((noOfScopes = tokenScopes.size()) > 0) {
            StringBuilder strBuilder = new StringBuilder();
            int index = 0;
            for (String scope : tokenScopes) {
                strBuilder.append(scope);
                if (index++ >= noOfScopes - 1) continue;
                strBuilder.append(" ");
            }
            String scopesStr = strBuilder.toString();
            builder.appendQueryParameter("scope", scopesStr);
        }
        Uri fqdn = builder.build();
        LocalDataManager.cacheState(this.pool.awsKeyValueStore, this.context, this.state, this.proofKey, tokenScopes);
        this.launchCustomTabs(fqdn);
    }

    private void launchSignOut(String redirectUri) {
        Uri.Builder builder = new Uri.Builder().scheme("https").authority(this.pool.getAppWebDomain()).appendPath("logout").appendQueryParameter("client_id", this.pool.getAppId()).appendQueryParameter("logout_uri", redirectUri);
        Uri fqdn = builder.build();
        this.launchCustomTabs(fqdn);
    }

    private void launchCustomTabs(Uri uri) {
        try {
            LocalDataManager.cacheHasReceivedRedirect(this.pool.awsKeyValueStore, this.context, this.pool.getAppId(), false);
            CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder(this.mCustomTabsSession);
            this.mCustomTabsIntent = builder.build();
            if (this.pool.getCustomTabExtras() != null) {
                this.mCustomTabsIntent.intent.putExtras(this.pool.getCustomTabExtras());
            }
            this.mCustomTabsIntent.intent.setPackage("com.android.chrome");
            this.mCustomTabsIntent.intent.addFlags(0x40000000);
            this.mCustomTabsIntent.intent.addFlags(0x10000000);
            this.mCustomTabsIntent.launchUrl(this.context, uri);
        }
        catch (Exception e) {
            this.userHandler.onFailure(e);
        }
    }

    private String getUserContextData() {
        String userContextData = null;
        if (this.pool.isAdvancedSecurityDataCollectionEnabled()) {
            UserContextDataProvider dataProvider = UserContextDataProvider.getInstance();
            userContextData = dataProvider.getEncodedContextData(this.context, this.userId, this.pool.getUserPoolId(), this.pool.getAppId());
        }
        return userContextData;
    }

    private void preWarmChrome() {
        this.mCustomTabsServiceConnection = new CustomTabsServiceConnection(){

            public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
                AuthClient.this.mCustomTabsClient = client;
                AuthClient.this.mCustomTabsClient.warmup(0L);
                AuthClient.this.mCustomTabsSession = AuthClient.this.mCustomTabsClient.newSession(AuthClient.this.customTabsCallback);
            }

            public void onServiceDisconnected(ComponentName name) {
                AuthClient.this.mCustomTabsClient = null;
            }
        };
        boolean chromeState = CustomTabsClient.bindCustomTabsService((Context)this.context, (String)"com.android.chrome", (CustomTabsServiceConnection)this.mCustomTabsServiceConnection);
    }
}

