/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoauth;

import com.amazonaws.mobileconnectors.cognitoauth.tokens.AccessToken;
import com.amazonaws.mobileconnectors.cognitoauth.tokens.IdToken;
import com.amazonaws.mobileconnectors.cognitoauth.tokens.RefreshToken;
import com.amazonaws.mobileconnectors.cognitoauth.util.AuthClientConfig;
import java.util.Date;

public class AuthUserSession {
    private IdToken idToken;
    private AccessToken accessToken;
    private RefreshToken refreshToken;

    public AuthUserSession(IdToken idToken, AccessToken accessToken, RefreshToken refreshToken) {
        this.idToken = idToken;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public IdToken getIdToken() {
        return this.idToken;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public boolean isValid() {
        if (this.accessToken == null || this.accessToken.getJWTToken() == null) {
            return false;
        }
        try {
            Date currentTimeStamp = new Date();
            return currentTimeStamp.before(this.accessToken.getExpiration());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValidForThreshold() {
        if (this.accessToken == null) {
            return false;
        }
        if (this.accessToken.getJWTToken() == null) {
            return false;
        }
        try {
            long currentTime = System.currentTimeMillis();
            long expiresInMilliSeconds = this.accessToken.getExpiration().getTime() - currentTime;
            return expiresInMilliSeconds > AuthClientConfig.getRefreshThreshold();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getUsername() {
        if (this.accessToken != null) {
            try {
                return this.accessToken.getUsername();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

