/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoauth.tokens;

import com.amazonaws.mobileconnectors.cognitoauth.tokens.UserToken;
import com.amazonaws.mobileconnectors.cognitoauth.util.JWTParser;
import java.util.Date;

public class IdToken
extends UserToken {
    private long SEC_IN_MILLSEC = 1000L;

    public IdToken(String jwtToken) {
        super(jwtToken);
    }

    public String getJWTToken() {
        return super.getToken();
    }

    public Date getExpiration() throws Exception {
        String claim = JWTParser.getClaim(super.getToken(), "exp");
        if (claim == null) {
            return null;
        }
        long epocTimeSec = Long.parseLong(claim);
        long epocTimeMilliSec = epocTimeSec * this.SEC_IN_MILLSEC;
        return new Date(epocTimeMilliSec);
    }

    public Date getNotBefore() throws Exception {
        String claim = JWTParser.getClaim(super.getToken(), "nbf");
        if (claim == null) {
            return null;
        }
        long epocTimeSec = Long.parseLong(claim);
        long epocTimeMilliSec = epocTimeSec * this.SEC_IN_MILLSEC;
        return new Date(epocTimeMilliSec);
    }

    public Date getIssuedAt() throws Exception {
        String claim = JWTParser.getClaim(super.getToken(), "iat");
        if (claim == null) {
            return null;
        }
        long epocTimeSec = Long.parseLong(claim);
        long epocTimeMilliSec = epocTimeSec * this.SEC_IN_MILLSEC;
        return new Date(epocTimeMilliSec);
    }

    public String getCognitoUsername() throws Exception {
        return JWTParser.getClaim(super.getToken(), "cognito:username");
    }
}

