/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoauth.util;

import com.amazonaws.mobileconnectors.cognitoauth.exceptions.AuthClientException;
import com.amazonaws.mobileconnectors.cognitoauth.exceptions.AuthServiceException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public final class AuthHttpClient {
    public String httpPost(URL uri, Map<String, String> headerParams, Map<String, String> bodyParams) throws Exception {
        if (uri == null || bodyParams == null || bodyParams.size() < 1) {
            throw new AuthClientException("Invalid http request parameters");
        }
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uri.openConnection();
        FilterOutputStream httpOutputStream = null;
        BufferedReader br = null;
        try {
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setDoOutput(true);
            for (Map.Entry<String, String> param : headerParams.entrySet()) {
                httpsURLConnection.addRequestProperty(param.getKey(), param.getValue());
            }
            StringBuilder reqBuilder = new StringBuilder();
            int index = bodyParams.size();
            for (Map.Entry<String, String> param : bodyParams.entrySet()) {
                reqBuilder.append(URLEncoder.encode(param.getKey(), "UTF-8")).append('=').append(URLEncoder.encode(param.getValue(), "UTF-8"));
                if (index-- <= 1) continue;
                reqBuilder.append('&');
            }
            String requestBody = reqBuilder.toString();
            httpOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
            ((DataOutputStream)httpOutputStream).writeBytes(requestBody);
            ((DataOutputStream)httpOutputStream).flush();
            Map<String, List<String>> respHeaders = httpsURLConnection.getHeaderFields();
            int responseCode = httpsURLConnection.getResponseCode();
            if (responseCode >= 200 && responseCode < 500) {
                InputStream httpDataStream = responseCode < 400 ? httpsURLConnection.getInputStream() : httpsURLConnection.getErrorStream();
                br = new BufferedReader(new InputStreamReader(httpDataStream));
                String line = "";
                StringBuilder responseOutput = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    responseOutput.append(line);
                }
                String string = responseOutput.toString();
                return string;
            }
            throw new AuthServiceException(httpsURLConnection.getResponseMessage());
        }
        finally {
            if (httpOutputStream != null) {
                httpOutputStream.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }
}

