/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoauth.util;

import com.amazonaws.mobileconnectors.cognitoauth.AuthUserSession;
import com.amazonaws.mobileconnectors.cognitoauth.exceptions.AuthClientException;
import com.amazonaws.mobileconnectors.cognitoauth.exceptions.AuthInvalidGrantException;
import com.amazonaws.mobileconnectors.cognitoauth.exceptions.AuthInvalidParameterException;
import com.amazonaws.mobileconnectors.cognitoauth.exceptions.AuthServiceException;
import com.amazonaws.mobileconnectors.cognitoauth.tokens.AccessToken;
import com.amazonaws.mobileconnectors.cognitoauth.tokens.IdToken;
import com.amazonaws.mobileconnectors.cognitoauth.tokens.RefreshToken;
import org.json.JSONObject;

public class AuthHttpResponseParser {
    private AuthHttpResponseParser() {
    }

    public static final AuthUserSession parseHttpResponse(String responseStr) {
        if (responseStr == null || responseStr.isEmpty()) {
            throw new AuthInvalidParameterException("Invalid (null) response from Amazon Cognito Auth endpoint");
        }
        AccessToken accessToken = new AccessToken(null);
        IdToken idToken = new IdToken(null);
        RefreshToken refreshToken = new RefreshToken(null);
        try {
            JSONObject responseJson = new JSONObject(responseStr);
            if (responseJson.has("error")) {
                String errorText = responseJson.getString("error");
                if ("invalid_grant".equals(errorText)) {
                    throw new AuthInvalidGrantException(errorText);
                }
                throw new AuthServiceException(errorText);
            }
            if (responseJson.has("access_token")) {
                accessToken = new AccessToken(responseJson.getString("access_token"));
            }
            if (responseJson.has("id_token")) {
                idToken = new IdToken(responseJson.getString("id_token"));
            }
            if (responseJson.has("refresh_token")) {
                refreshToken = new RefreshToken(responseJson.getString("refresh_token"));
            }
        }
        catch (AuthInvalidGrantException invg) {
            throw invg;
        }
        catch (AuthServiceException seve) {
            throw seve;
        }
        catch (Exception e) {
            throw new AuthClientException(e.getMessage(), e);
        }
        return new AuthUserSession(idToken, accessToken, refreshToken);
    }
}

