/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoauth.util;

import android.util.Base64;
import com.amazonaws.mobileconnectors.cognitoauth.exceptions.AuthInvalidParameterException;
import org.json.JSONObject;

public class JWTParser {
    private static int HEADER = 0;
    private static int PAYLOAD = 1;
    private static int SIGNATURE = 2;
    private static int JWT_PARTS = 3;

    public static JSONObject getHeader(String JWT) {
        try {
            JWTParser.validateJWT(JWT);
            byte[] sectionDecoded = Base64.decode((String)JWT.split("\\.")[HEADER], (int)8);
            String jwtSection = new String(sectionDecoded, "UTF-8");
            return new JSONObject(jwtSection);
        }
        catch (Exception e) {
            throw new AuthInvalidParameterException("error while parsing JSON", e);
        }
    }

    public static JSONObject getPayload(String JWT) {
        try {
            JWTParser.validateJWT(JWT);
            String payload = JWT.split("\\.")[PAYLOAD];
            byte[] sectionDecoded = Base64.decode((String)payload, (int)8);
            String jwtSection = new String(sectionDecoded, "UTF-8");
            return new JSONObject(jwtSection);
        }
        catch (Exception e) {
            throw new AuthInvalidParameterException("error while parsing JSON", e);
        }
    }

    public static String getSignature(String JWT) {
        try {
            JWTParser.validateJWT(JWT);
            byte[] sectionDecoded = Base64.decode((String)JWT.split("\\.")[SIGNATURE], (int)8);
            return new String(sectionDecoded, "UTF-8");
        }
        catch (Exception e) {
            throw new AuthInvalidParameterException("error while parsing JSON", e);
        }
    }

    public static String getClaim(String JWT, String claim) {
        try {
            JSONObject payload = JWTParser.getPayload(JWT);
            Object claimValue = payload.get(claim);
            if (claimValue != null) {
                return claimValue.toString();
            }
        }
        catch (Exception e) {
            throw new AuthInvalidParameterException("error while parsing JSON", e);
        }
        return null;
    }

    public static void validateJWT(String JWT) {
        String[] jwtParts = JWT.split("\\.");
        if (jwtParts.length < JWT_PARTS) {
            throw new AuthInvalidParameterException("Not a JSON Web Token");
        }
    }
}

