/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoauth.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.amazonaws.internal.keyvaluestore.AWSKeyValueStore;
import com.amazonaws.mobileconnectors.cognitoauth.AuthUserSession;
import com.amazonaws.mobileconnectors.cognitoauth.tokens.AccessToken;
import com.amazonaws.mobileconnectors.cognitoauth.tokens.IdToken;
import com.amazonaws.mobileconnectors.cognitoauth.tokens.RefreshToken;
import com.amazonaws.util.StringUtils;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class LocalDataManager {
    static final String TAG = LocalDataManager.class.getSimpleName();

    public static String getLastAuthUser(Context context, String clientId) {
        if (context == null || clientId == null) {
            throw new InvalidParameterException("Application context, and application domain cannot be null");
        }
        try {
            SharedPreferences localCache = context.getSharedPreferences("CognitoIdentityProviderCache", 0);
            String lastAuthUserKey = String.format(Locale.US, "%s.%s.%s", "CognitoIdentityProvider", clientId, "LastAuthUser");
            return localCache.getString(lastAuthUserKey, null);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to read from SharedPreferences", (Throwable)e);
            return null;
        }
    }

    public static String getLastAuthUser(AWSKeyValueStore awsKeyValueStore, Context context, String clientId) {
        if (context == null || clientId == null) {
            throw new InvalidParameterException("Application context, and application domain cannot be null");
        }
        try {
            String lastAuthUserKey = String.format(Locale.US, "%s.%s.%s", "CognitoIdentityProvider", clientId, "LastAuthUser");
            return awsKeyValueStore.get(lastAuthUserKey);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to read from SharedPreferences", (Throwable)e);
            return null;
        }
    }

    public static AuthUserSession getCachedSession(Context context, String clientId, String username, Set<String> scopes) {
        AuthUserSession session = new AuthUserSession(null, null, null);
        if (username != null) {
            if (context == null || clientId == null || clientId.isEmpty()) {
                throw new InvalidParameterException("Application context, and application domain cannot be null");
            }
            String cachedIdTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "idToken");
            String cachedAccessTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "accessToken");
            String cachedRefreshTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "refreshToken");
            String cachedTokenScopes = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "tokenScopes");
            try {
                SharedPreferences localCache = context.getSharedPreferences("CognitoIdentityProviderCache", 0);
                Set cachedScopes = localCache.getStringSet(cachedTokenScopes, new HashSet());
                if (!cachedScopes.equals(scopes)) {
                    return session;
                }
                IdToken idToken = new IdToken(localCache.getString(cachedIdTokenKey, null));
                AccessToken accessToken = new AccessToken(localCache.getString(cachedAccessTokenKey, null));
                RefreshToken refreshToken = new RefreshToken(localCache.getString(cachedRefreshTokenKey, null));
                session = new AuthUserSession(idToken, accessToken, refreshToken);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed to read from SharedPreferences", (Throwable)e);
            }
        }
        return session;
    }

    public static AuthUserSession getCachedSession(AWSKeyValueStore awsKeyValueStore, Context context, String clientId, String username, Set<String> scopes) {
        AuthUserSession session = new AuthUserSession(null, null, null);
        if (username != null) {
            if (context == null || clientId == null || clientId.isEmpty()) {
                throw new InvalidParameterException("Application context, and application domain cannot be null");
            }
            String cachedIdTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "idToken");
            String cachedAccessTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "accessToken");
            String cachedRefreshTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "refreshToken");
            String cachedTokenScopes = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "tokenScopes");
            try {
                String cachedSetString = awsKeyValueStore.get(cachedTokenScopes);
                Set<String> cachedScopes = LocalDataManager.setFromString(cachedSetString);
                if (!cachedScopes.equals(scopes)) {
                    return session;
                }
                IdToken idToken = new IdToken(awsKeyValueStore.get(cachedIdTokenKey));
                AccessToken accessToken = new AccessToken(awsKeyValueStore.get(cachedAccessTokenKey));
                RefreshToken refreshToken = new RefreshToken(awsKeyValueStore.get(cachedRefreshTokenKey));
                session = new AuthUserSession(idToken, accessToken, refreshToken);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed to read from SharedPreferences", (Throwable)e);
            }
        }
        return session;
    }

    public static void cacheSession(Context context, String clientId, String username, AuthUserSession session, Set<String> scopes) {
        if (context == null || clientId == null || clientId.isEmpty() || username == null || session == null) {
            Log.e((String)TAG, (String)"Application context, and application domain cannot be null");
            return;
        }
        String cachedIdTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "idToken");
        String cachedAccessTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "accessToken");
        String cachedRefreshTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "refreshToken");
        String cachedTokenTypeKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "tokenType");
        String cachedTokenScopes = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "tokenScopes");
        String lastAuthUserKey = String.format(Locale.US, "%s.%s.%s", "CognitoIdentityProvider", clientId, "LastAuthUser");
        try {
            SharedPreferences.Editor localCacheEditor = context.getSharedPreferences("CognitoIdentityProviderCache", 0).edit();
            localCacheEditor.putString(cachedTokenTypeKey, "JWT");
            localCacheEditor.putString(cachedIdTokenKey, session.getIdToken().getJWTToken());
            localCacheEditor.putString(cachedAccessTokenKey, session.getAccessToken().getJWTToken());
            localCacheEditor.putString(cachedRefreshTokenKey, session.getRefreshToken().getToken());
            if (scopes != null && scopes.size() > 0) {
                localCacheEditor.putStringSet(cachedTokenScopes, scopes);
            }
            localCacheEditor.putString(lastAuthUserKey, username).apply();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed while writing to SharedPreferences", (Throwable)e);
        }
    }

    public static void cacheSession(AWSKeyValueStore awsKeyValueStore, Context context, String clientId, String username, AuthUserSession session, Set<String> scopes) {
        if (context == null || clientId == null || clientId.isEmpty() || username == null || session == null) {
            Log.e((String)TAG, (String)"Application context, and application domain cannot be null");
            return;
        }
        String cachedIdTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "idToken");
        String cachedAccessTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "accessToken");
        String cachedRefreshTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "refreshToken");
        String cachedTokenTypeKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "tokenType");
        String cachedTokenScopes = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "tokenScopes");
        String lastAuthUserKey = String.format(Locale.US, "%s.%s.%s", "CognitoIdentityProvider", clientId, "LastAuthUser");
        try {
            awsKeyValueStore.put(cachedTokenTypeKey, "JWT");
            awsKeyValueStore.put(cachedIdTokenKey, session.getIdToken().getJWTToken());
            awsKeyValueStore.put(cachedAccessTokenKey, session.getAccessToken().getJWTToken());
            awsKeyValueStore.put(cachedRefreshTokenKey, session.getRefreshToken().getToken());
            if (scopes != null && scopes.size() > 0) {
                awsKeyValueStore.put(cachedTokenScopes, LocalDataManager.setToString(scopes));
            }
            awsKeyValueStore.put(lastAuthUserKey, username);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed while writing to SharedPreferences", (Throwable)e);
        }
    }

    public static void cacheState(Context context, String key, String proofKey, Set<String> scopes) {
        try {
            SharedPreferences.Editor localCacheEditor = context.getSharedPreferences("CognitoIdentityProviderCache", 0).edit();
            localCacheEditor.putString(key + "code_challenge", proofKey);
            localCacheEditor.putStringSet(key + "scope", scopes).apply();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed while writing to SharedPreferences", (Throwable)e);
        }
    }

    public static void cacheState(AWSKeyValueStore awsKeyValueStore, Context context, String key, String proofKey, Set<String> scopes) {
        try {
            awsKeyValueStore.put(key + "code_challenge", proofKey);
            awsKeyValueStore.put(key + "scope", LocalDataManager.setToString(scopes));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed while writing to SharedPreferences", (Throwable)e);
        }
    }

    public static String getCachedProofKey(Context context, String key) {
        try {
            SharedPreferences localCache = context.getSharedPreferences("CognitoIdentityProviderCache", 0);
            return localCache.getString(key + "code_challenge", null);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to read from SharedPreferences", (Throwable)e);
            return null;
        }
    }

    public static String getCachedProofKey(AWSKeyValueStore awsKeyValueStore, Context context, String key) {
        try {
            return awsKeyValueStore.get(key + "code_challenge");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to read from SharedPreferences", (Throwable)e);
            return null;
        }
    }

    public static Set<String> getCachedScopes(Context context, String key) {
        HashSet<String> cachedSet = new HashSet<String>();
        try {
            SharedPreferences localCache = context.getSharedPreferences("CognitoIdentityProviderCache", 0);
            return localCache.getStringSet(key + "scope", cachedSet);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to read from SharedPreferences", (Throwable)e);
            return cachedSet;
        }
    }

    public static Set<String> getCachedScopes(AWSKeyValueStore awsKeyValueStore, Context context, String key) {
        HashSet<String> cachedSet = new HashSet<String>();
        try {
            String cachedSetString = awsKeyValueStore.get(key + "scope");
            return LocalDataManager.setFromString(cachedSetString);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to read from SharedPreferences", (Throwable)e);
            return cachedSet;
        }
    }

    public static void clearCache(Context context, String clientId, String username) {
        if (username == null) {
            return;
        }
        String cachedIdTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "idToken");
        String cachedAccessTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "accessToken");
        String cachedRefreshTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "refreshToken");
        String cachedTokenTypeKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "tokenType");
        String cachedTokenScopes = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "tokenScopes");
        String lastAuthUserKey = String.format(Locale.US, "%s.%s.%s", "CognitoIdentityProvider", clientId, "LastAuthUser");
        try {
            SharedPreferences.Editor localCacheEditor = context.getSharedPreferences("CognitoIdentityProviderCache", 0).edit();
            localCacheEditor.remove(cachedIdTokenKey);
            localCacheEditor.remove(cachedAccessTokenKey);
            localCacheEditor.remove(cachedRefreshTokenKey);
            localCacheEditor.remove(cachedTokenTypeKey);
            localCacheEditor.remove(cachedTokenScopes);
            localCacheEditor.remove(lastAuthUserKey).apply();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed while writing to SharedPreferences", (Throwable)e);
        }
    }

    public static void clearCache(AWSKeyValueStore awsKeyValueStore, Context context, String clientId, String username) {
        if (username == null) {
            return;
        }
        String cachedIdTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "idToken");
        String cachedAccessTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "accessToken");
        String cachedRefreshTokenKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "refreshToken");
        String cachedTokenTypeKey = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "tokenType");
        String cachedTokenScopes = String.format(Locale.US, "%s.%s.%s.%s", "CognitoIdentityProvider", clientId, username, "tokenScopes");
        String lastAuthUserKey = String.format(Locale.US, "%s.%s.%s", "CognitoIdentityProvider", clientId, "LastAuthUser");
        try {
            awsKeyValueStore.remove(cachedIdTokenKey);
            awsKeyValueStore.remove(cachedAccessTokenKey);
            awsKeyValueStore.remove(cachedRefreshTokenKey);
            awsKeyValueStore.remove(cachedTokenTypeKey);
            awsKeyValueStore.remove(cachedTokenScopes);
            awsKeyValueStore.remove(lastAuthUserKey);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed while writing to SharedPreferences", (Throwable)e);
        }
    }

    public static void clearCacheAll(AWSKeyValueStore awsKeyValueStore) {
        try {
            awsKeyValueStore.clear();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed while clearing data from SharedPreferences", (Throwable)e);
        }
    }

    static String setToString(Set<String> stringSet) {
        StringBuilder strBuilder = new StringBuilder();
        int index = 0;
        for (String str : stringSet) {
            strBuilder.append(str);
            if (index++ >= stringSet.size() - 1) continue;
            strBuilder.append(",");
        }
        return strBuilder.toString();
    }

    static Set<String> setFromString(String str) {
        HashSet<String> stringSet = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)str)) {
            return stringSet;
        }
        String[] stringArray = str.split(",");
        stringSet.addAll(Arrays.asList(stringArray));
        return stringSet;
    }

    public static void cacheHasReceivedRedirect(AWSKeyValueStore awsKeyValueStore, Context context, String clientId, boolean hasReceivedRedirect) {
        if (context == null || clientId == null) {
            throw new InvalidParameterException("Application context, and application domain cannot be null");
        }
        try {
            String hasReceivedRedirectKey = String.format(Locale.US, "%s.%s.%s", "CognitoIdentityProvider", clientId, "HasReceivedRedirect");
            awsKeyValueStore.put(hasReceivedRedirectKey, hasReceivedRedirect ? "true" : "false");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed while writing to SharedPreferences", (Throwable)e);
        }
    }

    public static boolean hasReceivedRedirect(AWSKeyValueStore awsKeyValueStore, Context context, String clientId) {
        if (context == null || clientId == null) {
            throw new InvalidParameterException("Application context, and application domain cannot be null");
        }
        try {
            String hasReceivedRedirectKey = String.format(Locale.US, "%s.%s.%s", "CognitoIdentityProvider", clientId, "HasReceivedRedirect");
            return "true".equals(awsKeyValueStore.get(hasReceivedRedirectKey));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to read from SharedPreferences", (Throwable)e);
            return false;
        }
    }
}

