/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import com.amazonaws.services.cognitoidentityprovider.model.ChallengeNameType;
import com.amazonaws.services.cognitoidentityprovider.model.ContextDataType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AdminRespondToAuthChallengeRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String userPoolId;
    private String clientId;
    private String challengeName;
    private Map<String, String> challengeResponses;
    private String session;
    private AnalyticsMetadataType analyticsMetadata;
    private ContextDataType contextData;
    private Map<String, String> clientMetadata;

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public void setUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
    }

    public AdminRespondToAuthChallengeRequest withUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AdminRespondToAuthChallengeRequest withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getChallengeName() {
        return this.challengeName;
    }

    public void setChallengeName(String challengeName) {
        this.challengeName = challengeName;
    }

    public AdminRespondToAuthChallengeRequest withChallengeName(String challengeName) {
        this.challengeName = challengeName;
        return this;
    }

    public void setChallengeName(ChallengeNameType challengeName) {
        this.challengeName = challengeName.toString();
    }

    public AdminRespondToAuthChallengeRequest withChallengeName(ChallengeNameType challengeName) {
        this.challengeName = challengeName.toString();
        return this;
    }

    public Map<String, String> getChallengeResponses() {
        return this.challengeResponses;
    }

    public void setChallengeResponses(Map<String, String> challengeResponses) {
        this.challengeResponses = challengeResponses;
    }

    public AdminRespondToAuthChallengeRequest withChallengeResponses(Map<String, String> challengeResponses) {
        this.challengeResponses = challengeResponses;
        return this;
    }

    public AdminRespondToAuthChallengeRequest addChallengeResponsesEntry(String key, String value) {
        if (null == this.challengeResponses) {
            this.challengeResponses = new HashMap<String, String>();
        }
        if (this.challengeResponses.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.challengeResponses.put(key, value);
        return this;
    }

    public AdminRespondToAuthChallengeRequest clearChallengeResponsesEntries() {
        this.challengeResponses = null;
        return this;
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public AdminRespondToAuthChallengeRequest withSession(String session) {
        this.session = session;
        return this;
    }

    public AnalyticsMetadataType getAnalyticsMetadata() {
        return this.analyticsMetadata;
    }

    public void setAnalyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
        this.analyticsMetadata = analyticsMetadata;
    }

    public AdminRespondToAuthChallengeRequest withAnalyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
        this.analyticsMetadata = analyticsMetadata;
        return this;
    }

    public ContextDataType getContextData() {
        return this.contextData;
    }

    public void setContextData(ContextDataType contextData) {
        this.contextData = contextData;
    }

    public AdminRespondToAuthChallengeRequest withContextData(ContextDataType contextData) {
        this.contextData = contextData;
        return this;
    }

    public Map<String, String> getClientMetadata() {
        return this.clientMetadata;
    }

    public void setClientMetadata(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
    }

    public AdminRespondToAuthChallengeRequest withClientMetadata(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
        return this;
    }

    public AdminRespondToAuthChallengeRequest addClientMetadataEntry(String key, String value) {
        if (null == this.clientMetadata) {
            this.clientMetadata = new HashMap<String, String>();
        }
        if (this.clientMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.clientMetadata.put(key, value);
        return this;
    }

    public AdminRespondToAuthChallengeRequest clearClientMetadataEntries() {
        this.clientMetadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolId() != null) {
            sb.append("UserPoolId: " + this.getUserPoolId() + ",");
        }
        if (this.getClientId() != null) {
            sb.append("ClientId: " + this.getClientId() + ",");
        }
        if (this.getChallengeName() != null) {
            sb.append("ChallengeName: " + this.getChallengeName() + ",");
        }
        if (this.getChallengeResponses() != null) {
            sb.append("ChallengeResponses: " + this.getChallengeResponses() + ",");
        }
        if (this.getSession() != null) {
            sb.append("Session: " + this.getSession() + ",");
        }
        if (this.getAnalyticsMetadata() != null) {
            sb.append("AnalyticsMetadata: " + this.getAnalyticsMetadata() + ",");
        }
        if (this.getContextData() != null) {
            sb.append("ContextData: " + this.getContextData() + ",");
        }
        if (this.getClientMetadata() != null) {
            sb.append("ClientMetadata: " + this.getClientMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolId() == null ? 0 : this.getUserPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getClientId() == null ? 0 : this.getClientId().hashCode());
        hashCode = 31 * hashCode + (this.getChallengeName() == null ? 0 : this.getChallengeName().hashCode());
        hashCode = 31 * hashCode + (this.getChallengeResponses() == null ? 0 : this.getChallengeResponses().hashCode());
        hashCode = 31 * hashCode + (this.getSession() == null ? 0 : this.getSession().hashCode());
        hashCode = 31 * hashCode + (this.getAnalyticsMetadata() == null ? 0 : this.getAnalyticsMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getContextData() == null ? 0 : this.getContextData().hashCode());
        hashCode = 31 * hashCode + (this.getClientMetadata() == null ? 0 : this.getClientMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminRespondToAuthChallengeRequest)) {
            return false;
        }
        AdminRespondToAuthChallengeRequest other = (AdminRespondToAuthChallengeRequest)obj;
        if (other.getUserPoolId() == null ^ this.getUserPoolId() == null) {
            return false;
        }
        if (other.getUserPoolId() != null && !other.getUserPoolId().equals(this.getUserPoolId())) {
            return false;
        }
        if (other.getClientId() == null ^ this.getClientId() == null) {
            return false;
        }
        if (other.getClientId() != null && !other.getClientId().equals(this.getClientId())) {
            return false;
        }
        if (other.getChallengeName() == null ^ this.getChallengeName() == null) {
            return false;
        }
        if (other.getChallengeName() != null && !other.getChallengeName().equals(this.getChallengeName())) {
            return false;
        }
        if (other.getChallengeResponses() == null ^ this.getChallengeResponses() == null) {
            return false;
        }
        if (other.getChallengeResponses() != null && !other.getChallengeResponses().equals(this.getChallengeResponses())) {
            return false;
        }
        if (other.getSession() == null ^ this.getSession() == null) {
            return false;
        }
        if (other.getSession() != null && !other.getSession().equals(this.getSession())) {
            return false;
        }
        if (other.getAnalyticsMetadata() == null ^ this.getAnalyticsMetadata() == null) {
            return false;
        }
        if (other.getAnalyticsMetadata() != null && !other.getAnalyticsMetadata().equals(this.getAnalyticsMetadata())) {
            return false;
        }
        if (other.getContextData() == null ^ this.getContextData() == null) {
            return false;
        }
        if (other.getContextData() != null && !other.getContextData().equals(this.getContextData())) {
            return false;
        }
        if (other.getClientMetadata() == null ^ this.getClientMetadata() == null) {
            return false;
        }
        return other.getClientMetadata() == null || other.getClientMetadata().equals(this.getClientMetadata());
    }
}

