/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class AdminUpdateDeviceStatusRequestMarshaller
implements Marshaller<Request<AdminUpdateDeviceStatusRequest>, AdminUpdateDeviceStatusRequest> {
    public Request<AdminUpdateDeviceStatusRequest> marshall(AdminUpdateDeviceStatusRequest adminUpdateDeviceStatusRequest) {
        if (adminUpdateDeviceStatusRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AdminUpdateDeviceStatusRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)adminUpdateDeviceStatusRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.AdminUpdateDeviceStatus";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (adminUpdateDeviceStatusRequest.getUserPoolId() != null) {
                String userPoolId = adminUpdateDeviceStatusRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (adminUpdateDeviceStatusRequest.getUsername() != null) {
                String username = adminUpdateDeviceStatusRequest.getUsername();
                jsonWriter.name("Username");
                jsonWriter.value(username);
            }
            if (adminUpdateDeviceStatusRequest.getDeviceKey() != null) {
                String deviceKey = adminUpdateDeviceStatusRequest.getDeviceKey();
                jsonWriter.name("DeviceKey");
                jsonWriter.value(deviceKey);
            }
            if (adminUpdateDeviceStatusRequest.getDeviceRememberedStatus() != null) {
                String deviceRememberedStatus = adminUpdateDeviceStatusRequest.getDeviceRememberedStatus();
                jsonWriter.name("DeviceRememberedStatus");
                jsonWriter.value(deviceRememberedStatus);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

