/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.ResourceServerScopeType;
import com.amazonaws.services.cognitoidentityprovider.model.UpdateResourceServerRequest;
import com.amazonaws.services.cognitoidentityprovider.model.transform.ResourceServerScopeTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class UpdateResourceServerRequestMarshaller
implements Marshaller<Request<UpdateResourceServerRequest>, UpdateResourceServerRequest> {
    public Request<UpdateResourceServerRequest> marshall(UpdateResourceServerRequest updateResourceServerRequest) {
        if (updateResourceServerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateResourceServerRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateResourceServerRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.UpdateResourceServer";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateResourceServerRequest.getUserPoolId() != null) {
                String userPoolId = updateResourceServerRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (updateResourceServerRequest.getIdentifier() != null) {
                String identifier = updateResourceServerRequest.getIdentifier();
                jsonWriter.name("Identifier");
                jsonWriter.value(identifier);
            }
            if (updateResourceServerRequest.getName() != null) {
                String name = updateResourceServerRequest.getName();
                jsonWriter.name("Name");
                jsonWriter.value(name);
            }
            if (updateResourceServerRequest.getScopes() != null) {
                List<ResourceServerScopeType> scopes = updateResourceServerRequest.getScopes();
                jsonWriter.name("Scopes");
                jsonWriter.beginArray();
                for (ResourceServerScopeType scopesItem : scopes) {
                    if (scopesItem == null) continue;
                    ResourceServerScopeTypeJsonMarshaller.getInstance().marshall(scopesItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

