/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.AccountRecoverySettingType;
import com.amazonaws.services.cognitoidentityprovider.model.AdminCreateUserConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.DeviceConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.EmailConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.LambdaConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.SchemaAttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.SmsConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType;
import com.amazonaws.services.cognitoidentityprovider.model.UserPoolAddOnsType;
import com.amazonaws.services.cognitoidentityprovider.model.UserPoolPolicyType;
import com.amazonaws.services.cognitoidentityprovider.model.UserPoolType;
import com.amazonaws.services.cognitoidentityprovider.model.UsernameConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.VerificationMessageTemplateType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AccountRecoverySettingTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AdminCreateUserConfigTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.DeviceConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.EmailConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.LambdaConfigTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.SchemaAttributeTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.SmsConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.UserAttributeUpdateSettingsTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.UserPoolAddOnsTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.UserPoolPolicyTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.UsernameConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.VerificationMessageTemplateTypeJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;

class UserPoolTypeJsonMarshaller {
    private static UserPoolTypeJsonMarshaller instance;

    UserPoolTypeJsonMarshaller() {
    }

    public void marshall(UserPoolType userPoolType, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (userPoolType.getId() != null) {
            String id = userPoolType.getId();
            jsonWriter.name("Id");
            jsonWriter.value(id);
        }
        if (userPoolType.getName() != null) {
            String name = userPoolType.getName();
            jsonWriter.name("Name");
            jsonWriter.value(name);
        }
        if (userPoolType.getPolicies() != null) {
            UserPoolPolicyType policies = userPoolType.getPolicies();
            jsonWriter.name("Policies");
            UserPoolPolicyTypeJsonMarshaller.getInstance().marshall(policies, jsonWriter);
        }
        if (userPoolType.getDeletionProtection() != null) {
            String deletionProtection = userPoolType.getDeletionProtection();
            jsonWriter.name("DeletionProtection");
            jsonWriter.value(deletionProtection);
        }
        if (userPoolType.getLambdaConfig() != null) {
            LambdaConfigType lambdaConfig = userPoolType.getLambdaConfig();
            jsonWriter.name("LambdaConfig");
            LambdaConfigTypeJsonMarshaller.getInstance().marshall(lambdaConfig, jsonWriter);
        }
        if (userPoolType.getStatus() != null) {
            String status = userPoolType.getStatus();
            jsonWriter.name("Status");
            jsonWriter.value(status);
        }
        if (userPoolType.getLastModifiedDate() != null) {
            Date lastModifiedDate = userPoolType.getLastModifiedDate();
            jsonWriter.name("LastModifiedDate");
            jsonWriter.value(lastModifiedDate);
        }
        if (userPoolType.getCreationDate() != null) {
            Date creationDate = userPoolType.getCreationDate();
            jsonWriter.name("CreationDate");
            jsonWriter.value(creationDate);
        }
        if (userPoolType.getSchemaAttributes() != null) {
            List<SchemaAttributeType> schemaAttributes = userPoolType.getSchemaAttributes();
            jsonWriter.name("SchemaAttributes");
            jsonWriter.beginArray();
            for (SchemaAttributeType schemaAttributeType : schemaAttributes) {
                if (schemaAttributeType == null) continue;
                SchemaAttributeTypeJsonMarshaller.getInstance().marshall(schemaAttributeType, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (userPoolType.getAutoVerifiedAttributes() != null) {
            List<String> autoVerifiedAttributes = userPoolType.getAutoVerifiedAttributes();
            jsonWriter.name("AutoVerifiedAttributes");
            jsonWriter.beginArray();
            for (String string : autoVerifiedAttributes) {
                if (string == null) continue;
                jsonWriter.value(string);
            }
            jsonWriter.endArray();
        }
        if (userPoolType.getAliasAttributes() != null) {
            List<String> aliasAttributes = userPoolType.getAliasAttributes();
            jsonWriter.name("AliasAttributes");
            jsonWriter.beginArray();
            for (String string : aliasAttributes) {
                if (string == null) continue;
                jsonWriter.value(string);
            }
            jsonWriter.endArray();
        }
        if (userPoolType.getUsernameAttributes() != null) {
            List<String> usernameAttributes = userPoolType.getUsernameAttributes();
            jsonWriter.name("UsernameAttributes");
            jsonWriter.beginArray();
            for (String string : usernameAttributes) {
                if (string == null) continue;
                jsonWriter.value(string);
            }
            jsonWriter.endArray();
        }
        if (userPoolType.getSmsVerificationMessage() != null) {
            String smsVerificationMessage = userPoolType.getSmsVerificationMessage();
            jsonWriter.name("SmsVerificationMessage");
            jsonWriter.value(smsVerificationMessage);
        }
        if (userPoolType.getEmailVerificationMessage() != null) {
            String emailVerificationMessage = userPoolType.getEmailVerificationMessage();
            jsonWriter.name("EmailVerificationMessage");
            jsonWriter.value(emailVerificationMessage);
        }
        if (userPoolType.getEmailVerificationSubject() != null) {
            String emailVerificationSubject = userPoolType.getEmailVerificationSubject();
            jsonWriter.name("EmailVerificationSubject");
            jsonWriter.value(emailVerificationSubject);
        }
        if (userPoolType.getVerificationMessageTemplate() != null) {
            VerificationMessageTemplateType verificationMessageTemplate = userPoolType.getVerificationMessageTemplate();
            jsonWriter.name("VerificationMessageTemplate");
            VerificationMessageTemplateTypeJsonMarshaller.getInstance().marshall(verificationMessageTemplate, jsonWriter);
        }
        if (userPoolType.getSmsAuthenticationMessage() != null) {
            String smsAuthenticationMessage = userPoolType.getSmsAuthenticationMessage();
            jsonWriter.name("SmsAuthenticationMessage");
            jsonWriter.value(smsAuthenticationMessage);
        }
        if (userPoolType.getUserAttributeUpdateSettings() != null) {
            UserAttributeUpdateSettingsType userAttributeUpdateSettings = userPoolType.getUserAttributeUpdateSettings();
            jsonWriter.name("UserAttributeUpdateSettings");
            UserAttributeUpdateSettingsTypeJsonMarshaller.getInstance().marshall(userAttributeUpdateSettings, jsonWriter);
        }
        if (userPoolType.getMfaConfiguration() != null) {
            String mfaConfiguration = userPoolType.getMfaConfiguration();
            jsonWriter.name("MfaConfiguration");
            jsonWriter.value(mfaConfiguration);
        }
        if (userPoolType.getDeviceConfiguration() != null) {
            DeviceConfigurationType deviceConfiguration = userPoolType.getDeviceConfiguration();
            jsonWriter.name("DeviceConfiguration");
            DeviceConfigurationTypeJsonMarshaller.getInstance().marshall(deviceConfiguration, jsonWriter);
        }
        if (userPoolType.getEstimatedNumberOfUsers() != null) {
            Integer estimatedNumberOfUsers = userPoolType.getEstimatedNumberOfUsers();
            jsonWriter.name("EstimatedNumberOfUsers");
            jsonWriter.value((Number)estimatedNumberOfUsers);
        }
        if (userPoolType.getEmailConfiguration() != null) {
            EmailConfigurationType emailConfiguration = userPoolType.getEmailConfiguration();
            jsonWriter.name("EmailConfiguration");
            EmailConfigurationTypeJsonMarshaller.getInstance().marshall(emailConfiguration, jsonWriter);
        }
        if (userPoolType.getSmsConfiguration() != null) {
            SmsConfigurationType smsConfiguration = userPoolType.getSmsConfiguration();
            jsonWriter.name("SmsConfiguration");
            SmsConfigurationTypeJsonMarshaller.getInstance().marshall(smsConfiguration, jsonWriter);
        }
        if (userPoolType.getUserPoolTags() != null) {
            Map<String, String> userPoolTags = userPoolType.getUserPoolTags();
            jsonWriter.name("UserPoolTags");
            jsonWriter.beginObject();
            for (Map.Entry entry : userPoolTags.entrySet()) {
                String userPoolTagsValue = (String)entry.getValue();
                if (userPoolTagsValue == null) continue;
                jsonWriter.name((String)entry.getKey());
                jsonWriter.value(userPoolTagsValue);
            }
            jsonWriter.endObject();
        }
        if (userPoolType.getSmsConfigurationFailure() != null) {
            String smsConfigurationFailure = userPoolType.getSmsConfigurationFailure();
            jsonWriter.name("SmsConfigurationFailure");
            jsonWriter.value(smsConfigurationFailure);
        }
        if (userPoolType.getEmailConfigurationFailure() != null) {
            String emailConfigurationFailure = userPoolType.getEmailConfigurationFailure();
            jsonWriter.name("EmailConfigurationFailure");
            jsonWriter.value(emailConfigurationFailure);
        }
        if (userPoolType.getDomain() != null) {
            String domain = userPoolType.getDomain();
            jsonWriter.name("Domain");
            jsonWriter.value(domain);
        }
        if (userPoolType.getCustomDomain() != null) {
            String customDomain = userPoolType.getCustomDomain();
            jsonWriter.name("CustomDomain");
            jsonWriter.value(customDomain);
        }
        if (userPoolType.getAdminCreateUserConfig() != null) {
            AdminCreateUserConfigType adminCreateUserConfig = userPoolType.getAdminCreateUserConfig();
            jsonWriter.name("AdminCreateUserConfig");
            AdminCreateUserConfigTypeJsonMarshaller.getInstance().marshall(adminCreateUserConfig, jsonWriter);
        }
        if (userPoolType.getUserPoolAddOns() != null) {
            UserPoolAddOnsType userPoolAddOns = userPoolType.getUserPoolAddOns();
            jsonWriter.name("UserPoolAddOns");
            UserPoolAddOnsTypeJsonMarshaller.getInstance().marshall(userPoolAddOns, jsonWriter);
        }
        if (userPoolType.getUsernameConfiguration() != null) {
            UsernameConfigurationType usernameConfiguration = userPoolType.getUsernameConfiguration();
            jsonWriter.name("UsernameConfiguration");
            UsernameConfigurationTypeJsonMarshaller.getInstance().marshall(usernameConfiguration, jsonWriter);
        }
        if (userPoolType.getArn() != null) {
            String arn = userPoolType.getArn();
            jsonWriter.name("Arn");
            jsonWriter.value(arn);
        }
        if (userPoolType.getAccountRecoverySetting() != null) {
            AccountRecoverySettingType accountRecoverySetting = userPoolType.getAccountRecoverySetting();
            jsonWriter.name("AccountRecoverySetting");
            AccountRecoverySettingTypeJsonMarshaller.getInstance().marshall(accountRecoverySetting, jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static UserPoolTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new UserPoolTypeJsonMarshaller();
        }
        return instance;
    }
}

