/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import android.content.Context;
import android.util.Log;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCognitoIdentityProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.CognitoCredentialsProvider;
import com.amazonaws.auth.IdentityChangedListener;
import com.amazonaws.internal.keyvaluestore.AWSKeyValueStore;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.cognitoidentity.model.NotAuthorizedException;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.util.VersionInfoUtils;
import java.util.Date;
import java.util.Map;

public class CognitoCachingCredentialsProvider
extends CognitoCredentialsProvider {
    private final String DEFAULT_SHAREDPREFERENCES_NAME = "com.amazonaws.android.auth";
    private static final String USER_AGENT = CognitoCachingCredentialsProvider.class.getName() + "/" + VersionInfoUtils.getVersion();
    private String identityId;
    private static final String ID_KEY = "identityId";
    private static final String AK_KEY = "accessKey";
    private static final String SK_KEY = "secretKey";
    private static final String ST_KEY = "sessionToken";
    private static final String EXP_KEY = "expirationDate";
    volatile boolean needIdentityRefresh = false;
    private boolean isPersistenceEnabled = true;
    private static final String TAG = "CognitoCachingCredentialsProvider";
    private AWSKeyValueStore awsKeyValueStore;
    private final IdentityChangedListener listener = new IdentityChangedListener(){

        @Override
        public void identityChanged(String oldIdentityId, String newIdentityId) {
            Log.d((String)CognitoCachingCredentialsProvider.TAG, (String)"Identity id is changed");
            CognitoCachingCredentialsProvider.this.saveIdentityId(newIdentityId);
            CognitoCachingCredentialsProvider.this.clearCredentials();
        }
    };

    public CognitoCachingCredentialsProvider(Context context, String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, Regions region) {
        super(accountId, identityPoolId, unauthRoleArn, authRoleArn, region);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.initialize(context);
    }

    public CognitoCachingCredentialsProvider(Context context, String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, Regions region, ClientConfiguration clientConfiguration) {
        super(accountId, identityPoolId, unauthRoleArn, authRoleArn, region, clientConfiguration);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.initialize(context);
    }

    public CognitoCachingCredentialsProvider(Context context, String identityPoolId, Regions region) {
        super(identityPoolId, region);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.initialize(context);
    }

    public CognitoCachingCredentialsProvider(Context context, AWSConfiguration awsConfiguration) {
        super(awsConfiguration);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.initialize(context);
    }

    public CognitoCachingCredentialsProvider(Context context, String identityPoolId, Regions region, ClientConfiguration clientConfiguration) {
        super(identityPoolId, region, clientConfiguration);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.initialize(context);
    }

    public CognitoCachingCredentialsProvider(Context context, String accountId, String identityPoolId, String unauthArn, String authArn, AmazonCognitoIdentityClient cibClient, AWSSecurityTokenService stsClient) {
        super(accountId, identityPoolId, unauthArn, authArn, cibClient, stsClient);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.initialize(context);
    }

    public CognitoCachingCredentialsProvider(Context context, AWSCognitoIdentityProvider provider, String unauthArn, String authArn) {
        super(provider, unauthArn, authArn);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.initialize(context);
    }

    public CognitoCachingCredentialsProvider(Context context, AWSCognitoIdentityProvider provider, String unauthArn, String authArn, AWSSecurityTokenService stsClient) {
        super(provider, unauthArn, authArn, stsClient);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.initialize(context);
    }

    public CognitoCachingCredentialsProvider(Context context, AWSCognitoIdentityProvider provider, Regions region) {
        super(provider, region);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.initialize(context);
    }

    public CognitoCachingCredentialsProvider(Context context, AWSCognitoIdentityProvider provider, Regions region, ClientConfiguration clientConfiguration) {
        super(provider, region, clientConfiguration);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.initialize(context);
    }

    private void initialize(Context context) {
        try {
            this.awsKeyValueStore = new AWSKeyValueStore(context, "com.amazonaws.android.auth", this.isPersistenceEnabled);
            this.checkUpgrade();
            this.identityId = this.getCachedIdentityId();
            this.loadCachedCredentials();
            this.registerIdentityChangedListener(this.listener);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Error in initializing the CognitoCachingCredentialsProvider. " + ex));
            throw new IllegalStateException("Error in initializing the CognitoCachingCredentialsProvider. ", ex);
        }
    }

    @Override
    public String getIdentityId() {
        if (this.needIdentityRefresh) {
            this.needIdentityRefresh = false;
            this.refresh();
            this.identityId = super.getIdentityId();
            this.saveIdentityId(this.identityId);
        }
        this.identityId = this.getCachedIdentityId();
        if (this.identityId == null) {
            this.identityId = super.getIdentityId();
            this.saveIdentityId(this.identityId);
        }
        return this.identityId;
    }

    @Override
    public AWSSessionCredentials getCredentials() {
        this.credentialsLock.writeLock().lock();
        try {
            if (this.sessionCredentials == null) {
                this.loadCachedCredentials();
            }
            if (this.sessionCredentialsExpiration != null && !this.needsNewSession()) {
                AWSSessionCredentials aWSSessionCredentials = this.sessionCredentials;
                return aWSSessionCredentials;
            }
            Log.d((String)TAG, (String)"Making a network call to fetch credentials.");
            super.getCredentials();
            if (this.sessionCredentialsExpiration != null) {
                this.saveCredentials(this.sessionCredentials, this.sessionCredentialsExpiration.getTime());
            }
            AWSSessionCredentials aWSSessionCredentials = this.sessionCredentials;
            return aWSSessionCredentials;
        }
        catch (NotAuthorizedException e) {
            Log.e((String)TAG, (String)"Failure to get credentials", (Throwable)e);
            if (this.getLogins() != null) {
                super.setIdentityId(null);
                super.getCredentials();
                AWSSessionCredentials aWSSessionCredentials = this.sessionCredentials;
                return aWSSessionCredentials;
            }
            throw e;
        }
        finally {
            this.credentialsLock.writeLock().unlock();
        }
    }

    @Override
    public void refresh() {
        this.credentialsLock.writeLock().lock();
        try {
            super.refresh();
            if (this.sessionCredentialsExpiration != null) {
                this.saveCredentials(this.sessionCredentials, this.sessionCredentialsExpiration.getTime());
            }
        }
        finally {
            this.credentialsLock.writeLock().unlock();
        }
    }

    @Override
    public void setLogins(Map<String, String> logins) {
        this.credentialsLock.writeLock().lock();
        try {
            super.setLogins(logins);
            this.needIdentityRefresh = true;
            this.clearCredentials();
        }
        finally {
            this.credentialsLock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.awsKeyValueStore.clear();
    }

    @Override
    public void clearCredentials() {
        this.credentialsLock.writeLock().lock();
        try {
            super.clearCredentials();
            Log.d((String)TAG, (String)"Clearing credentials from SharedPreferences");
            this.awsKeyValueStore.remove(this.namespace(AK_KEY));
            this.awsKeyValueStore.remove(this.namespace(SK_KEY));
            this.awsKeyValueStore.remove(this.namespace(ST_KEY));
            this.awsKeyValueStore.remove(this.namespace(EXP_KEY));
        }
        finally {
            this.credentialsLock.writeLock().unlock();
        }
    }

    public String getCachedIdentityId() {
        String cachedIdentityId = this.awsKeyValueStore.get(this.namespace(ID_KEY));
        if (cachedIdentityId != null && this.identityId == null) {
            super.setIdentityId(cachedIdentityId);
        }
        return cachedIdentityId;
    }

    private void loadCachedCredentials() {
        Log.d((String)TAG, (String)"Loading credentials from SharedPreferences");
        this.sessionCredentialsExpiration = this.awsKeyValueStore.get(this.namespace(EXP_KEY)) != null ? new Date(Long.parseLong(this.awsKeyValueStore.get(this.namespace(EXP_KEY)))) : new Date(0L);
        boolean hasAK = this.awsKeyValueStore.contains(this.namespace(AK_KEY));
        boolean hasSK = this.awsKeyValueStore.contains(this.namespace(SK_KEY));
        boolean hasST = this.awsKeyValueStore.contains(this.namespace(ST_KEY));
        if (!(hasAK && hasSK && hasST)) {
            Log.d((String)TAG, (String)"No valid credentials found in SharedPreferences");
            this.sessionCredentialsExpiration = null;
            return;
        }
        String accessKey = this.awsKeyValueStore.get(this.namespace(AK_KEY));
        String secretAccessKey = this.awsKeyValueStore.get(this.namespace(SK_KEY));
        String sessionToken = this.awsKeyValueStore.get(this.namespace(ST_KEY));
        if (accessKey == null || secretAccessKey == null || sessionToken == null) {
            Log.d((String)TAG, (String)"No valid credentials found in SharedPreferences");
            this.sessionCredentialsExpiration = null;
            return;
        }
        this.sessionCredentials = new BasicSessionCredentials(accessKey, secretAccessKey, sessionToken);
    }

    private void saveCredentials(AWSSessionCredentials sessionCredentials, long time) {
        Log.d((String)TAG, (String)"Saving credentials to SharedPreferences");
        if (sessionCredentials != null) {
            this.awsKeyValueStore.put(this.namespace(AK_KEY), sessionCredentials.getAWSAccessKeyId());
            this.awsKeyValueStore.put(this.namespace(SK_KEY), sessionCredentials.getAWSSecretKey());
            this.awsKeyValueStore.put(this.namespace(ST_KEY), sessionCredentials.getSessionToken());
            this.awsKeyValueStore.put(this.namespace(EXP_KEY), String.valueOf(time));
        }
    }

    private void saveIdentityId(String identityId) {
        Log.d((String)TAG, (String)"Saving identity id to SharedPreferences");
        this.identityId = identityId;
        this.awsKeyValueStore.put(this.namespace(ID_KEY), identityId);
    }

    @Override
    protected String getUserAgent() {
        return USER_AGENT;
    }

    private void checkUpgrade() {
        if (this.awsKeyValueStore.contains(ID_KEY)) {
            Log.i((String)TAG, (String)"Identity id without namespace is detected. It will be saved under new namespace.");
            String identityId = this.awsKeyValueStore.get(ID_KEY);
            this.awsKeyValueStore.clear();
            this.awsKeyValueStore.put(this.namespace(ID_KEY), identityId);
        }
    }

    private String namespace(String key) {
        return this.getIdentityPoolId() + "." + key;
    }

    public void setPersistenceEnabled(boolean isPersistenceEnabled) {
        this.isPersistenceEnabled = isPersistenceEnabled;
        this.awsKeyValueStore.setPersistenceEnabled(isPersistenceEnabled);
    }
}

