/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.lambdainvoker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.amazonaws.mobileconnectors.lambdainvoker.LambdaDataBinder;
import com.amazonaws.util.StringUtils;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class LambdaJsonBinder
implements LambdaDataBinder {
    @NonNull
    private final Gson gson;

    public LambdaJsonBinder() {
        this(new Gson());
    }

    public LambdaJsonBinder(@NonNull Gson gson) {
        this.gson = gson;
    }

    @Override
    @Nullable
    public <T> T deserialize(@Nullable byte[] content, @NonNull Class<T> clazz) {
        if (content == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(content), StringUtils.UTF8));
        return (T)this.gson.fromJson((Reader)reader, clazz);
    }

    @Override
    public byte[] serialize(@Nullable Object object) {
        return this.gson.toJson(object).getBytes(StringUtils.UTF8);
    }
}

