/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.services.lambda.model.InvokeResult;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.IOUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class InvokeResultJsonUnmarshaller
implements Unmarshaller<InvokeResult, JsonUnmarshallerContext> {
    private static InvokeResultJsonUnmarshaller instance;

    public InvokeResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        InputStream is;
        InvokeResult invokeResult = new InvokeResult();
        invokeResult.setStatusCode(context.getHttpResponse().getStatusCode());
        if (context.getHeader("X-Amz-Function-Error") != null) {
            invokeResult.setFunctionError(context.getHeader("X-Amz-Function-Error"));
        }
        if (context.getHeader("X-Amz-Log-Result") != null) {
            invokeResult.setLogResult(context.getHeader("X-Amz-Log-Result"));
        }
        if ((is = context.getHttpResponse().getContent()) != null) {
            invokeResult.setPayload(ByteBuffer.wrap(IOUtils.toByteArray((InputStream)is)));
        }
        if (context.getHeader("X-Amz-Executed-Version") != null) {
            invokeResult.setExecutedVersion(context.getHeader("X-Amz-Executed-Version"));
        }
        return invokeResult;
    }

    public static InvokeResultJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InvokeResultJsonUnmarshaller();
        }
        return instance;
    }
}

