/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transfermanager.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.mobileconnectors.s3.transfermanager.PauseResult;
import com.amazonaws.mobileconnectors.s3.transfermanager.PauseStatus;
import com.amazonaws.mobileconnectors.s3.transfermanager.PersistableUpload;
import com.amazonaws.mobileconnectors.s3.transfermanager.TransferProgress;
import com.amazonaws.mobileconnectors.s3.transfermanager.Upload;
import com.amazonaws.mobileconnectors.s3.transfermanager.exception.PauseException;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.AbstractTransfer;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.TransferStateChangeListener;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.UploadMonitor;
import com.amazonaws.mobileconnectors.s3.transfermanager.model.UploadResult;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class UploadImpl
extends AbstractTransfer
implements Upload {
    public UploadImpl(String string, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, TransferStateChangeListener transferStateChangeListener) {
        super(string, transferProgress, progressListenerChain, transferStateChangeListener);
    }

    @Override
    public UploadResult waitForUploadResult() throws AmazonClientException, AmazonServiceException, InterruptedException {
        try {
            UploadResult uploadResult = null;
            while (!this.monitor.isDone() || uploadResult == null) {
                Future<?> future = this.monitor.getFuture();
                uploadResult = (UploadResult)future.get();
            }
            return uploadResult;
        }
        catch (ExecutionException executionException) {
            this.rethrowExecutionException(executionException);
            return null;
        }
    }

    @Override
    public PersistableUpload pause() throws PauseException {
        PauseResult<PersistableUpload> pauseResult = this.pause(true);
        if (pauseResult.getPauseStatus() != PauseStatus.SUCCESS) {
            throw new PauseException(pauseResult.getPauseStatus());
        }
        return pauseResult.getInfoToResume();
    }

    private PauseResult<PersistableUpload> pause(boolean bl) throws AmazonClientException {
        UploadMonitor uploadMonitor = (UploadMonitor)this.monitor;
        return uploadMonitor.pause(bl);
    }

    @Override
    public PauseResult<PersistableUpload> tryPause(boolean bl) {
        return this.pause(bl);
    }

    @Override
    public void abort() {
        UploadMonitor uploadMonitor = (UploadMonitor)this.monitor;
        uploadMonitor.performAbort();
    }
}

