/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.services.s3.S3ResponseMetadata;
import com.amazonaws.services.s3.internal.ObjectExpirationHeaderHandler;
import com.amazonaws.services.s3.internal.ObjectRestoreHeaderHandler;
import com.amazonaws.services.s3.internal.S3MetadataResponseHandler;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.util.DateUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractS3ResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private static final Log log = LogFactory.getLog(S3MetadataResponseHandler.class);
    private static final Set<String> ignoredHeaders = new HashSet<String>();

    public boolean needsConnectionLeftOpen() {
        return false;
    }

    protected AmazonWebServiceResponse<T> parseResponseMetadata(HttpResponse httpResponse) {
        AmazonWebServiceResponse amazonWebServiceResponse = new AmazonWebServiceResponse();
        String string = (String)httpResponse.getHeaders().get("x-amz-request-id");
        String string2 = (String)httpResponse.getHeaders().get("x-amz-id-2");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("AWS_REQUEST_ID", string);
        hashMap.put("HOST_ID", string2);
        amazonWebServiceResponse.setResponseMetadata((ResponseMetadata)new S3ResponseMetadata(hashMap));
        return amazonWebServiceResponse;
    }

    protected void populateObjectMetadata(HttpResponse httpResponse, ObjectMetadata objectMetadata) {
        for (Map.Entry entry : httpResponse.getHeaders().entrySet()) {
            String string = (String)entry.getKey();
            if (string.startsWith("x-amz-meta-")) {
                string = string.substring("x-amz-meta-".length());
                objectMetadata.addUserMetadata(string, (String)entry.getValue());
                continue;
            }
            if (ignoredHeaders.contains(string)) continue;
            if (string.equals("Last-Modified")) {
                try {
                    objectMetadata.setHeader(string, ServiceUtils.parseRfc822Date((String)entry.getValue()));
                }
                catch (Exception exception) {
                    log.warn((Object)("Unable to parse last modified date: " + (String)entry.getValue()), (Throwable)exception);
                }
                continue;
            }
            if (string.equals("Content-Length")) {
                try {
                    objectMetadata.setHeader(string, Long.parseLong((String)entry.getValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    log.warn((Object)("Unable to parse content length: " + (String)entry.getValue()), (Throwable)numberFormatException);
                }
                continue;
            }
            if (string.equals("ETag")) {
                objectMetadata.setHeader(string, ServiceUtils.removeQuotes((String)entry.getValue()));
                continue;
            }
            if (string.equals("Expires")) {
                try {
                    objectMetadata.setHttpExpiresDate(DateUtils.parseRFC822Date((String)((String)entry.getValue())));
                }
                catch (Exception exception) {
                    log.warn((Object)("Unable to parse http expiration date: " + (String)entry.getValue()), (Throwable)exception);
                }
                continue;
            }
            if (string.equals("x-amz-expiration")) {
                new ObjectExpirationHeaderHandler<ObjectMetadata>().handle(objectMetadata, httpResponse);
                continue;
            }
            if (string.equals("x-amz-restore")) {
                new ObjectRestoreHeaderHandler<ObjectMetadata>().handle(objectMetadata, httpResponse);
                continue;
            }
            objectMetadata.setHeader(string, entry.getValue());
        }
    }

    static {
        ignoredHeaders.add("Date");
        ignoredHeaders.add("Server");
        ignoredHeaders.add("x-amz-request-id");
        ignoredHeaders.add("x-amz-id-2");
    }
}

