/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

public enum BucketNameUtils {

    private static final int MIN_BUCKET_NAME_LENGTH = 3;
    private static final int MAX_BUCKET_NAME_LENGTH = 63;

    public static void validateBucketName(String string) {
        BucketNameUtils.isValidV2BucketName(string, true);
    }

    public static boolean isValidV2BucketName(String string) {
        return BucketNameUtils.isValidV2BucketName(string, false);
    }

    public static boolean isDNSBucketName(String string) {
        return BucketNameUtils.isValidV2BucketName(string);
    }

    private static boolean isValidV2BucketName(String string, boolean bl) {
        if (string == null) {
            return BucketNameUtils.exception(bl, "Bucket name cannot be null");
        }
        if (string.length() < 3 || string.length() > 63) {
            return BucketNameUtils.exception(bl, "Bucket name should be between 3 and 63 characters long");
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                return BucketNameUtils.exception(bl, "Bucket name should not contain uppercase characters");
            }
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                return BucketNameUtils.exception(bl, "Bucket name should not contain white space");
            }
            if (c == '.') {
                if (n == 46) {
                    return BucketNameUtils.exception(bl, "Bucket name should not contain two adjacent periods");
                }
                if (n == 45) {
                    return BucketNameUtils.exception(bl, "Bucket name should not contain dashes next to periods");
                }
            } else if (c == '-') {
                if (n == 46) {
                    return BucketNameUtils.exception(bl, "Bucket name should not contain dashes next to periods");
                }
            } else if (c < '0' || c > '9' && c < 'a' || c > 'z') {
                return BucketNameUtils.exception(bl, "Bucket name should not contain '" + c + "'");
            }
            n = c;
        }
        if (n == 46 || n == 45) {
            return BucketNameUtils.exception(bl, "Bucket name should not end with '-' or '.'");
        }
        return true;
    }

    private static boolean exception(boolean bl, String string) {
        if (bl) {
            throw new IllegalArgumentException(string);
        }
        return false;
    }
}

