/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

abstract class AbstractHandler
extends DefaultHandler {
    private final StringBuilder text = new StringBuilder();
    private final LinkedList<String> context = new LinkedList();

    AbstractHandler() {
    }

    @Override
    public final void startElement(String string, String string2, String string3, Attributes attributes) {
        this.text.setLength(0);
        this.doStartElement(string, string2, string3, attributes);
        this.context.add(string2);
    }

    protected abstract void doStartElement(String var1, String var2, String var3, Attributes var4);

    @Override
    public final void endElement(String string, String string2, String string3) {
        this.context.removeLast();
        this.doEndElement(string, string2, string3);
    }

    protected abstract void doEndElement(String var1, String var2, String var3);

    @Override
    public final void characters(char[] cArray, int n, int n2) {
        this.text.append(cArray, n, n2);
    }

    protected final String getText() {
        return this.text.toString();
    }

    protected final boolean atTopLevel() {
        return this.context.isEmpty();
    }

    protected final boolean in(String ... stringArray) {
        if (stringArray.length != this.context.size()) {
            return false;
        }
        int n = 0;
        for (String string : this.context) {
            String string2 = stringArray[n];
            if (!string2.equals("*") && !string2.equals(string)) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

