/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.internal.RepeatableCipherInputStream;
import com.amazonaws.services.s3.internal.RepeatableFileInputStream;
import com.amazonaws.services.s3.internal.crypto.AdjustedRangeInputStream;
import com.amazonaws.services.s3.internal.crypto.ByteRangeCapturingInputStream;
import com.amazonaws.services.s3.internal.crypto.CipherFactory;
import com.amazonaws.services.s3.internal.crypto.EncryptionInstruction;
import com.amazonaws.services.s3.internal.crypto.JceEncryptionConstants;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsAccessor;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.util.Base64;
import com.amazonaws.util.LengthCheckInputStream;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtils {
    static final String INSTRUCTION_SUFFIX = ".instruction";

    @Deprecated
    public static PutObjectRequest encryptRequestUsingMetadata(PutObjectRequest putObjectRequest, EncryptionMaterials encryptionMaterials, Provider provider) {
        EncryptionInstruction encryptionInstruction = EncryptionUtils.generateInstruction(encryptionMaterials, provider);
        PutObjectRequest putObjectRequest2 = EncryptionUtils.encryptRequestUsingInstruction(putObjectRequest, encryptionInstruction);
        EncryptionUtils.updateMetadataWithEncryptionInstruction(putObjectRequest, encryptionInstruction);
        return putObjectRequest2;
    }

    @Deprecated
    public static S3Object decryptObjectUsingMetadata(S3Object s3Object, EncryptionMaterials encryptionMaterials, Provider provider) {
        EncryptionInstruction encryptionInstruction = EncryptionUtils.buildInstructionFromObjectMetadata(s3Object, encryptionMaterials, provider);
        return EncryptionUtils.decryptObjectUsingInstruction(s3Object, encryptionInstruction);
    }

    @Deprecated
    public static EncryptionInstruction generateInstruction(EncryptionMaterials encryptionMaterials, Provider provider) {
        return EncryptionUtils.generateInstruction(new StaticEncryptionMaterialsProvider(encryptionMaterials), provider);
    }

    public static EncryptionInstruction generateInstruction(EncryptionMaterialsProvider encryptionMaterialsProvider, Provider provider) {
        return EncryptionUtils.buildInstruction(encryptionMaterialsProvider.getEncryptionMaterials(), provider);
    }

    public static EncryptionInstruction generateInstruction(EncryptionMaterialsProvider encryptionMaterialsProvider, Map<String, String> map, Provider provider) {
        return EncryptionUtils.buildInstruction(encryptionMaterialsProvider.getEncryptionMaterials(map), provider);
    }

    private static EncryptionInstruction buildInstruction(EncryptionMaterials encryptionMaterials, Provider provider) {
        SecretKey secretKey = EncryptionUtils.generateOneTimeUseSymmetricKey();
        CipherFactory cipherFactory = new CipherFactory(secretKey, 1, null, provider);
        byte[] byArray = EncryptionUtils.getEncryptedSymmetricKey(secretKey, encryptionMaterials, provider);
        return new EncryptionInstruction(encryptionMaterials.getMaterialsDescription(), byArray, secretKey, cipherFactory);
    }

    @Deprecated
    public static EncryptionInstruction buildInstructionFromInstructionFile(S3Object s3Object, EncryptionMaterials encryptionMaterials, Provider provider) {
        return EncryptionUtils.buildInstructionFromInstructionFile(s3Object, new StaticEncryptionMaterialsProvider(encryptionMaterials), provider);
    }

    public static EncryptionInstruction buildInstructionFromInstructionFile(S3Object s3Object, EncryptionMaterialsProvider encryptionMaterialsProvider, Provider provider) {
        JSONObject jSONObject = EncryptionUtils.parseJSONInstruction(s3Object);
        try {
            String string = jSONObject.getString("x-amz-key");
            String string2 = jSONObject.getString("x-amz-iv");
            String string3 = jSONObject.tryGetString("x-amz-matdesc");
            Map<String, String> map = EncryptionUtils.convertJSONToMap(string3);
            byte[] byArray = Base64.decode((String)string);
            byte[] byArray2 = Base64.decode((String)string2);
            if (byArray == null || byArray2 == null) {
                throw new AmazonClientException(String.format("Necessary encryption info not found in the instruction file '%s' in bucket '%s'", s3Object.getKey(), s3Object.getBucketName()));
            }
            EncryptionMaterials encryptionMaterials = EncryptionUtils.retrieveOriginalMaterials(map, encryptionMaterialsProvider);
            if (encryptionMaterials == null) {
                throw new AmazonClientException(String.format("Unable to retrieve the encryption materials that originally encrypted object corresponding to instruction file '%s' in bucket '%s'.", s3Object.getKey(), s3Object.getBucketName()));
            }
            SecretKey secretKey = EncryptionUtils.getDecryptedSymmetricKey(byArray, encryptionMaterials, provider);
            CipherFactory cipherFactory = new CipherFactory(secretKey, 2, byArray2, provider);
            return new EncryptionInstruction(map, byArray, secretKey, cipherFactory);
        }
        catch (JSONException jSONException) {
            throw new AmazonClientException("Unable to parse retrieved instruction file : " + jSONException.getMessage());
        }
    }

    @Deprecated
    public static EncryptionInstruction buildInstructionFromObjectMetadata(S3Object s3Object, EncryptionMaterials encryptionMaterials, Provider provider) {
        return EncryptionUtils.buildInstructionFromObjectMetadata(s3Object, new StaticEncryptionMaterialsProvider(encryptionMaterials), provider);
    }

    public static EncryptionInstruction buildInstructionFromObjectMetadata(S3Object s3Object, EncryptionMaterialsProvider encryptionMaterialsProvider, Provider provider) {
        ObjectMetadata objectMetadata = s3Object.getObjectMetadata();
        byte[] byArray = EncryptionUtils.getCryptoBytesFromMetadata("x-amz-key", objectMetadata);
        byte[] byArray2 = EncryptionUtils.getCryptoBytesFromMetadata("x-amz-iv", objectMetadata);
        String string = EncryptionUtils.getStringFromMetadata("x-amz-matdesc", objectMetadata);
        Map<String, String> map = EncryptionUtils.convertJSONToMap(string);
        if (byArray == null || byArray2 == null) {
            throw new AmazonClientException(String.format("Necessary encryption info not found in the headers of file '%s' in bucket '%s'", s3Object.getKey(), s3Object.getBucketName()));
        }
        EncryptionMaterials encryptionMaterials = EncryptionUtils.retrieveOriginalMaterials(map, encryptionMaterialsProvider);
        if (encryptionMaterials == null) {
            throw new AmazonClientException(String.format("Unable to retrieve the encryption materials that originally encrypted file '%s' in bucket '%s'.", s3Object.getKey(), s3Object.getBucketName()));
        }
        SecretKey secretKey = EncryptionUtils.getDecryptedSymmetricKey(byArray, encryptionMaterials, provider);
        CipherFactory cipherFactory = new CipherFactory(secretKey, 2, byArray2, provider);
        return new EncryptionInstruction(map, byArray, secretKey, cipherFactory);
    }

    public static PutObjectRequest encryptRequestUsingInstruction(PutObjectRequest putObjectRequest, EncryptionInstruction encryptionInstruction) {
        long l;
        ObjectMetadata objectMetadata = putObjectRequest.getMetadata();
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
        }
        if (objectMetadata.getContentMD5() != null) {
            objectMetadata.addUserMetadata("x-amz-unencrypted-content-md5", objectMetadata.getContentMD5());
        }
        objectMetadata.setContentMD5(null);
        long l2 = EncryptionUtils.getUnencryptedContentLength(putObjectRequest, objectMetadata);
        if (l2 >= 0L) {
            objectMetadata.addUserMetadata("x-amz-unencrypted-content-length", Long.toString(l2));
        }
        if ((l = EncryptionUtils.calculateCryptoContentLength(encryptionInstruction.getSymmetricCipher(), putObjectRequest, objectMetadata)) >= 0L) {
            objectMetadata.setContentLength(l);
        }
        putObjectRequest.setMetadata(objectMetadata);
        putObjectRequest.setInputStream(EncryptionUtils.getEncryptedInputStream(putObjectRequest, encryptionInstruction.getCipherFactory(), l2));
        putObjectRequest.setFile(null);
        return putObjectRequest;
    }

    public static S3Object decryptObjectUsingInstruction(S3Object s3Object, EncryptionInstruction encryptionInstruction) {
        S3ObjectInputStream s3ObjectInputStream = s3Object.getObjectContent();
        RepeatableCipherInputStream repeatableCipherInputStream = new RepeatableCipherInputStream((InputStream)((Object)s3ObjectInputStream), encryptionInstruction.getCipherFactory());
        s3Object.setObjectContent(new S3ObjectInputStream((InputStream)((Object)repeatableCipherInputStream), s3ObjectInputStream.getHttpRequest()));
        return s3Object;
    }

    public static PutObjectRequest createInstructionPutRequest(PutObjectRequest putObjectRequest, EncryptionInstruction encryptionInstruction) {
        JSONObject jSONObject = EncryptionUtils.convertInstructionToJSONObject(encryptionInstruction);
        byte[] byArray = jSONObject.toString().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectMetadata objectMetadata = putObjectRequest.getMetadata();
        objectMetadata.setContentLength(byArray.length);
        objectMetadata.addUserMetadata("x-amz-crypto-instr-file", "");
        putObjectRequest.setKey(putObjectRequest.getKey() + INSTRUCTION_SUFFIX);
        putObjectRequest.setMetadata(objectMetadata);
        putObjectRequest.setInputStream(byteArrayInputStream);
        return putObjectRequest;
    }

    public static PutObjectRequest createInstructionPutRequest(String string, String string2, EncryptionInstruction encryptionInstruction) {
        JSONObject jSONObject = EncryptionUtils.convertInstructionToJSONObject(encryptionInstruction);
        byte[] byArray = jSONObject.toString().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(byArray.length);
        objectMetadata.addUserMetadata("x-amz-crypto-instr-file", "");
        return new PutObjectRequest(string, string2 + INSTRUCTION_SUFFIX, byteArrayInputStream, objectMetadata);
    }

    public static GetObjectRequest createInstructionGetRequest(GetObjectRequest getObjectRequest) {
        return new GetObjectRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey() + INSTRUCTION_SUFFIX, getObjectRequest.getVersionId());
    }

    public static DeleteObjectRequest createInstructionDeleteObjectRequest(DeleteObjectRequest deleteObjectRequest) {
        return new DeleteObjectRequest(deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey() + INSTRUCTION_SUFFIX);
    }

    public static boolean isEncryptionInfoInMetadata(S3Object s3Object) {
        Map<String, String> map = s3Object.getObjectMetadata().getUserMetadata();
        return map != null && map.containsKey("x-amz-iv") && map.containsKey("x-amz-key");
    }

    public static boolean isEncryptionInfoInInstructionFile(S3Object s3Object) {
        if (s3Object == null) {
            return false;
        }
        Map<String, String> map = s3Object.getObjectMetadata().getUserMetadata();
        if (map == null) {
            return false;
        }
        return map.containsKey("x-amz-crypto-instr-file");
    }

    public static long[] getAdjustedCryptoRange(long[] lArray) {
        if (lArray == null || lArray[0] > lArray[1]) {
            return null;
        }
        long[] lArray2 = new long[]{EncryptionUtils.getCipherBlockLowerBound(lArray[0]), EncryptionUtils.getCipherBlockUpperBound(lArray[1])};
        return lArray2;
    }

    public static S3Object adjustOutputToDesiredRange(S3Object s3Object, long[] lArray) {
        if (lArray == null || lArray[0] > lArray[1]) {
            return s3Object;
        }
        try {
            S3ObjectInputStream s3ObjectInputStream = s3Object.getObjectContent();
            AdjustedRangeInputStream adjustedRangeInputStream = new AdjustedRangeInputStream((InputStream)((Object)s3ObjectInputStream), lArray[0], lArray[1]);
            s3Object.setObjectContent(new S3ObjectInputStream((InputStream)((Object)adjustedRangeInputStream), s3ObjectInputStream.getHttpRequest()));
            return s3Object;
        }
        catch (IOException iOException) {
            throw new AmazonClientException("Error adjusting output to desired byte range: " + iOException.getMessage());
        }
    }

    public static SecretKey generateOneTimeUseSymmetricKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(JceEncryptionConstants.SYMMETRIC_KEY_ALGORITHM);
            keyGenerator.init(JceEncryptionConstants.SYMMETRIC_KEY_LENGTH, new SecureRandom());
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AmazonClientException("Unable to generate envelope symmetric key:" + noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
    }

    public static Cipher createSymmetricCipher(SecretKey secretKey, int n, Provider provider, byte[] byArray) {
        try {
            Cipher cipher = provider != null ? Cipher.getInstance(JceEncryptionConstants.SYMMETRIC_CIPHER_METHOD, provider) : Cipher.getInstance(JceEncryptionConstants.SYMMETRIC_CIPHER_METHOD);
            if (byArray != null) {
                cipher.init(n, (Key)secretKey, new IvParameterSpec(byArray));
            } else {
                cipher.init(n, secretKey);
            }
            return cipher;
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to build cipher: " + exception.getMessage() + "\nMake sure you have the JCE unlimited strength policy files installed and " + "configured for your JVM: http://www.ngs.ac.uk/tools/jcepolicyfiles", (Throwable)exception);
        }
    }

    public static byte[] getEncryptedSymmetricKey(SecretKey secretKey, EncryptionMaterials encryptionMaterials, Provider provider) {
        Key key = encryptionMaterials.getKeyPair() != null ? encryptionMaterials.getKeyPair().getPublic() : encryptionMaterials.getSymmetricKey();
        try {
            byte[] byArray = secretKey.getEncoded();
            Cipher cipher = provider != null ? Cipher.getInstance(key.getAlgorithm(), provider) : Cipher.getInstance(key.getAlgorithm());
            cipher.init(1, key);
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to encrypt symmetric key: " + exception.getMessage(), (Throwable)exception);
        }
    }

    private static SecretKey getDecryptedSymmetricKey(byte[] byArray, EncryptionMaterials encryptionMaterials, Provider provider) {
        Key key = encryptionMaterials.getKeyPair() != null ? encryptionMaterials.getKeyPair().getPrivate() : encryptionMaterials.getSymmetricKey();
        try {
            Cipher cipher = provider != null ? Cipher.getInstance(key.getAlgorithm(), provider) : Cipher.getInstance(key.getAlgorithm());
            cipher.init(2, key);
            byte[] byArray2 = cipher.doFinal(byArray);
            return new SecretKeySpec(byArray2, JceEncryptionConstants.SYMMETRIC_KEY_ALGORITHM);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to decrypt symmetric key from object metadata : " + exception.getMessage(), (Throwable)exception);
        }
    }

    private static InputStream getEncryptedInputStream(PutObjectRequest putObjectRequest, CipherFactory cipherFactory, long l) {
        try {
            Object object = putObjectRequest.getInputStream();
            if (putObjectRequest.getFile() != null) {
                object = new RepeatableFileInputStream(putObjectRequest.getFile());
            }
            if (l > -1L) {
                object = new LengthCheckInputStream(object, l, false);
            }
            return new RepeatableCipherInputStream((InputStream)object, cipherFactory);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to create cipher input stream: " + exception.getMessage(), (Throwable)exception);
        }
    }

    public static ByteRangeCapturingInputStream getEncryptedInputStream(UploadPartRequest uploadPartRequest, CipherFactory cipherFactory) {
        try {
            Object object = uploadPartRequest.getInputStream();
            if (uploadPartRequest.getFile() != null) {
                object = new InputSubstream((InputStream)((Object)new RepeatableFileInputStream(uploadPartRequest.getFile())), uploadPartRequest.getFileOffset(), uploadPartRequest.getPartSize(), uploadPartRequest.isLastPart());
            }
            object = new RepeatableCipherInputStream((InputStream)object, cipherFactory);
            if (!uploadPartRequest.isLastPart()) {
                object = new InputSubstream((InputStream)object, 0L, uploadPartRequest.getPartSize(), false);
            }
            long l = uploadPartRequest.getPartSize();
            int n = cipherFactory.createCipher().getBlockSize();
            return new ByteRangeCapturingInputStream((InputStream)object, l - (long)n, l);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to create cipher input stream: " + exception.getMessage(), (Throwable)exception);
        }
    }

    private static byte[] getCryptoBytesFromMetadata(String string, ObjectMetadata objectMetadata) throws NullPointerException {
        Map<String, String> map = objectMetadata.getUserMetadata();
        if (map == null || !map.containsKey(string)) {
            return null;
        }
        return Base64.decode((String)map.get(string));
    }

    private static String getStringFromMetadata(String string, ObjectMetadata objectMetadata) throws NullPointerException {
        Map<String, String> map = objectMetadata.getUserMetadata();
        if (map == null || !map.containsKey(string)) {
            return null;
        }
        return map.get(string);
    }

    private static Map<String, String> convertJSONToMap(String string) {
        if (string == null) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                hashMap.put(string2, jSONObject.getString(string2));
            }
            return hashMap;
        }
        catch (JSONException jSONException) {
            throw new AmazonClientException("Unable to parse encryption materials description from metadata :" + jSONException.getMessage());
        }
    }

    public static void updateMetadataWithEncryptionInstruction(PutObjectRequest putObjectRequest, EncryptionInstruction encryptionInstruction) {
        byte[] byArray = encryptionInstruction.getEncryptedSymmetricKey();
        Cipher cipher = encryptionInstruction.getSymmetricCipher();
        Map<String, String> map = encryptionInstruction.getMaterialsDescription();
        ObjectMetadata objectMetadata = putObjectRequest.getMetadata();
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
        }
        if (putObjectRequest.getFile() != null) {
            Mimetypes mimetypes = Mimetypes.getInstance();
            objectMetadata.setContentType(mimetypes.getMimetype(putObjectRequest.getFile()));
        }
        EncryptionUtils.updateMetadata(objectMetadata, byArray, cipher, map);
        putObjectRequest.setMetadata(objectMetadata);
    }

    private static void updateMetadata(ObjectMetadata objectMetadata, byte[] byArray, Cipher cipher, Map<String, String> map) {
        if (byArray != null) {
            objectMetadata.addUserMetadata("x-amz-key", Base64.encodeAsString((byte[])byArray));
        }
        objectMetadata.addUserMetadata("x-amz-iv", Base64.encodeAsString((byte[])cipher.getIV()));
        JSONObject jSONObject = new JSONObject(map);
        objectMetadata.addUserMetadata("x-amz-matdesc", jSONObject.toString());
    }

    public static ObjectMetadata updateMetadataWithEncryptionInfo(InitiateMultipartUploadRequest initiateMultipartUploadRequest, byte[] byArray, Cipher cipher, Map<String, String> map) {
        ObjectMetadata objectMetadata = initiateMultipartUploadRequest.getObjectMetadata();
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
        }
        EncryptionUtils.updateMetadata(objectMetadata, byArray, cipher, map);
        return objectMetadata;
    }

    private static EncryptionMaterials retrieveOriginalMaterials(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor) {
        if (encryptionMaterialsAccessor == null) {
            return null;
        }
        return encryptionMaterialsAccessor.getEncryptionMaterials(map);
    }

    private static long calculateCryptoContentLength(Cipher cipher, PutObjectRequest putObjectRequest, ObjectMetadata objectMetadata) {
        long l = EncryptionUtils.getUnencryptedContentLength(putObjectRequest, objectMetadata);
        if (l < 0L) {
            return -1L;
        }
        long l2 = cipher.getBlockSize();
        long l3 = l2 - l % l2;
        return l + l3;
    }

    public static long calculateCryptoContentLength(Cipher cipher, UploadPartRequest uploadPartRequest) {
        long l;
        if (uploadPartRequest.getFile() != null) {
            l = uploadPartRequest.getPartSize() > 0L ? uploadPartRequest.getPartSize() : uploadPartRequest.getFile().length();
        } else if (uploadPartRequest.getInputStream() != null) {
            l = uploadPartRequest.getPartSize();
        } else {
            return -1L;
        }
        long l2 = cipher.getBlockSize();
        long l3 = l2 - l % l2;
        return l + l3;
    }

    private static long getUnencryptedContentLength(PutObjectRequest putObjectRequest, ObjectMetadata objectMetadata) {
        if (putObjectRequest.getFile() != null) {
            return putObjectRequest.getFile().length();
        }
        if (putObjectRequest.getInputStream() != null && objectMetadata.getRawMetadataValue("Content-Length") != null) {
            return objectMetadata.getContentLength();
        }
        return -1L;
    }

    private static JSONObject convertInstructionToJSONObject(EncryptionInstruction encryptionInstruction) {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONObject jSONObject2 = new JSONObject(encryptionInstruction.getMaterialsDescription());
            jSONObject.put("x-amz-matdesc", (Object)jSONObject2.toString());
            jSONObject.put("x-amz-key", (Object)Base64.encodeAsString((byte[])encryptionInstruction.getEncryptedSymmetricKey()));
            byte[] byArray = encryptionInstruction.getSymmetricCipher().getIV();
            jSONObject.put("x-amz-iv", (Object)Base64.encodeAsString((byte[])byArray));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private static JSONObject parseJSONInstruction(S3Object s3Object) {
        try {
            String string = EncryptionUtils.convertStreamToString((InputStream)((Object)s3Object.getObjectContent()));
            return new JSONObject(string);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Error parsing JSON instruction file: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    private static long getCipherBlockLowerBound(long l) {
        long l2 = JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE;
        long l3 = l % l2;
        long l4 = l - l3 - l2;
        if (l4 < 0L) {
            return 0L;
        }
        return l4;
    }

    private static long getCipherBlockUpperBound(long l) {
        long l2 = JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE;
        long l3 = l2 - l % l2;
        return l + l3 + l2;
    }
}

