/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.internal.RepeatableFileInputStream;
import com.amazonaws.services.s3.internal.S3Direct;
import com.amazonaws.services.s3.internal.crypto.CipherLiteInputStream;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoMaterial;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.MultipartUploadContext;
import com.amazonaws.services.s3.internal.crypto.S3CryptoModule;
import com.amazonaws.services.s3.internal.crypto.S3CryptoScheme;
import com.amazonaws.services.s3.internal.crypto.S3KeyWrapScheme;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.MaterialsDescriptionProvider;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.util.LengthCheckInputStream;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public abstract class S3CryptoModuleBase<T extends MultipartUploadContext>
extends S3CryptoModule<T> {
    protected static final int DEFAULT_BUFFER_SIZE = 2048;
    protected final EncryptionMaterialsProvider kekMaterialsProvider;
    protected final CryptoConfiguration cryptoConfig;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final S3CryptoScheme cryptoScheme;
    protected final ContentCryptoScheme contentCryptoScheme;
    protected final Map<String, T> multipartUploadContexts = Collections.synchronizedMap(new HashMap());
    protected final S3Direct s3;

    protected S3CryptoModuleBase(S3Direct s3Direct, AWSCredentialsProvider aWSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, ClientConfiguration clientConfiguration, CryptoConfiguration cryptoConfiguration, S3CryptoScheme s3CryptoScheme) {
        this.kekMaterialsProvider = encryptionMaterialsProvider;
        this.cryptoConfig = cryptoConfiguration;
        this.s3 = s3Direct;
        this.cryptoScheme = s3CryptoScheme;
        this.contentCryptoScheme = s3CryptoScheme.getContentCryptoScheme();
    }

    protected abstract long ciphertextLength(long var1);

    @Override
    public final void abortMultipartUploadSecurely(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        this.s3.abortMultipartUpload(abortMultipartUploadRequest);
        this.multipartUploadContexts.remove(abortMultipartUploadRequest.getUploadId());
    }

    protected final ObjectMetadata updateMetadataWithContentCryptoMaterial(ObjectMetadata objectMetadata, File file, ContentCryptoMaterial contentCryptoMaterial) {
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
        }
        if (file != null) {
            Mimetypes mimetypes = Mimetypes.getInstance();
            objectMetadata.setContentType(mimetypes.getMimetype(file));
        }
        return contentCryptoMaterial.toObjectMetadata(objectMetadata);
    }

    protected final ContentCryptoMaterial createContentCryptoMaterial(AmazonWebServiceRequest amazonWebServiceRequest) {
        if (amazonWebServiceRequest instanceof MaterialsDescriptionProvider) {
            return this.newContentCryptoMaterial(this.kekMaterialsProvider, ((MaterialsDescriptionProvider)amazonWebServiceRequest).getMaterialsDescription(), this.cryptoConfig.getCryptoProvider());
        }
        return this.newContentCryptoMaterial(this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider());
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider encryptionMaterialsProvider, Map<String, String> map, Provider provider) {
        EncryptionMaterials encryptionMaterials = encryptionMaterialsProvider.getEncryptionMaterials(map);
        return this.buildContentCryptoMaterial(encryptionMaterials, provider);
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider encryptionMaterialsProvider, Provider provider) {
        EncryptionMaterials encryptionMaterials = encryptionMaterialsProvider.getEncryptionMaterials();
        return this.buildContentCryptoMaterial(encryptionMaterials, provider);
    }

    private ContentCryptoMaterial buildContentCryptoMaterial(EncryptionMaterials encryptionMaterials, Provider provider) {
        SecretKey secretKey = this.generateCEK();
        byte[] byArray = new byte[this.contentCryptoScheme.getIVLengthInBytes()];
        this.cryptoScheme.getSecureRandom().nextBytes(byArray);
        SecuredCEK securedCEK = this.secureCEK(secretKey, encryptionMaterials, provider);
        return new ContentCryptoMaterial(encryptionMaterials.getMaterialsDescription(), securedCEK.encrypted, securedCEK.keyWrapAlgorithm, this.contentCryptoScheme.createCipherLite(secretKey, byArray, 1, provider));
    }

    protected final SecretKey generateCEK() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(this.contentCryptoScheme.getKeyGeneratorAlgorithm());
            keyGenerator.init(this.contentCryptoScheme.getKeyLengthInBits(), this.cryptoScheme.getSecureRandom());
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AmazonClientException("Unable to generate envelope symmetric key:" + noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
    }

    protected final SecuredCEK secureCEK(SecretKey secretKey, EncryptionMaterials encryptionMaterials, Provider provider) {
        Key key = encryptionMaterials.getKeyPair() != null ? encryptionMaterials.getKeyPair().getPublic() : encryptionMaterials.getSymmetricKey();
        S3KeyWrapScheme s3KeyWrapScheme = this.cryptoScheme.getKeyWrapScheme();
        String string = s3KeyWrapScheme.getKeyWrapAlgorithm(key);
        try {
            if (string != null) {
                Cipher cipher = provider == null ? Cipher.getInstance(string) : Cipher.getInstance(string, provider);
                cipher.init(3, key, this.cryptoScheme.getSecureRandom());
                return new SecuredCEK(cipher.wrap(secretKey), string);
            }
            byte[] byArray = secretKey.getEncoded();
            String string2 = key.getAlgorithm();
            Cipher cipher = provider != null ? Cipher.getInstance(string2, provider) : Cipher.getInstance(string2);
            cipher.init(1, key);
            return new SecuredCEK(cipher.doFinal(byArray), null);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to encrypt symmetric key: " + exception.getMessage(), (Throwable)exception);
        }
    }

    protected final PutObjectRequest wrapWithCipher(PutObjectRequest putObjectRequest, ContentCryptoMaterial contentCryptoMaterial) {
        ObjectMetadata objectMetadata = putObjectRequest.getMetadata();
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
        }
        if (objectMetadata.getContentMD5() != null) {
            objectMetadata.addUserMetadata("x-amz-unencrypted-content-md5", objectMetadata.getContentMD5());
        }
        objectMetadata.setContentMD5(null);
        long l = this.plaintextLength(putObjectRequest, objectMetadata);
        if (l >= 0L) {
            objectMetadata.addUserMetadata("x-amz-unencrypted-content-length", Long.toString(l));
            objectMetadata.setContentLength(this.ciphertextLength(l));
        }
        putObjectRequest.setMetadata(objectMetadata);
        putObjectRequest.setInputStream((InputStream)((Object)this.newS3CipherLiteInputStream(putObjectRequest, contentCryptoMaterial, l)));
        putObjectRequest.setFile(null);
        return putObjectRequest;
    }

    private CipherLiteInputStream newS3CipherLiteInputStream(PutObjectRequest putObjectRequest, ContentCryptoMaterial contentCryptoMaterial, long l) {
        try {
            Object object = putObjectRequest.getInputStream();
            if (putObjectRequest.getFile() != null) {
                object = new RepeatableFileInputStream(putObjectRequest.getFile());
            }
            if (l > -1L) {
                object = new LengthCheckInputStream(object, l, false);
            }
            return new CipherLiteInputStream((InputStream)object, contentCryptoMaterial.getCipherLite(), 2048);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to create cipher input stream: " + exception.getMessage(), (Throwable)exception);
        }
    }

    protected final long plaintextLength(PutObjectRequest putObjectRequest, ObjectMetadata objectMetadata) {
        if (putObjectRequest.getFile() != null) {
            return putObjectRequest.getFile().length();
        }
        if (putObjectRequest.getInputStream() != null && objectMetadata.getRawMetadataValue("Content-Length") != null) {
            return objectMetadata.getContentLength();
        }
        return -1L;
    }

    public final S3CryptoScheme getS3CryptoScheme() {
        return this.cryptoScheme;
    }

    protected final PutObjectRequest upateInstructionPutRequest(PutObjectRequest putObjectRequest, ContentCryptoMaterial contentCryptoMaterial) {
        byte[] byArray = contentCryptoMaterial.toJsonString().getBytes(StringUtils.UTF8);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectMetadata objectMetadata = putObjectRequest.getMetadata();
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
            putObjectRequest.setMetadata(objectMetadata);
        }
        objectMetadata.setContentLength(byArray.length);
        objectMetadata.addUserMetadata("x-amz-crypto-instr-file", "");
        putObjectRequest.setKey(putObjectRequest.getKey() + ".instruction");
        putObjectRequest.setMetadata(objectMetadata);
        putObjectRequest.setInputStream(byteArrayInputStream);
        putObjectRequest.setFile(null);
        return putObjectRequest;
    }

    protected final PutObjectRequest createInstructionPutRequest(String string, String string2, ContentCryptoMaterial contentCryptoMaterial) {
        byte[] byArray = contentCryptoMaterial.toJsonString().getBytes(StringUtils.UTF8);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(byArray.length);
        objectMetadata.addUserMetadata("x-amz-crypto-instr-file", "");
        return new PutObjectRequest(string, string2 + ".instruction", byteArrayInputStream, objectMetadata);
    }

    final <X extends AmazonWebServiceRequest> X appendUserAgent(X x, String string) {
        x.getRequestClientOptions().appendUserAgent(string);
        return x;
    }

    private static class SecuredCEK {
        final byte[] encrypted;
        final String keyWrapAlgorithm;

        SecuredCEK(byte[] byArray, String string) {
            this.encrypted = byArray;
            this.keyWrapAlgorithm = string;
        }
    }
}

