/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.LegacyS3ProgressListener;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.ProgressListener;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.File;
import java.io.InputStream;

public class PutObjectRequest
extends AmazonWebServiceRequest
implements Cloneable {
    private String bucketName;
    private String key;
    private File file;
    private InputStream inputStream;
    private ObjectMetadata metadata;
    private CannedAccessControlList cannedAcl;
    private AccessControlList accessControlList;
    private String storageClass;
    private com.amazonaws.event.ProgressListener generalProgressListener;
    private String redirectLocation;
    private SSECustomerKey sseCustomerKey;

    public PutObjectRequest(String string, String string2, File file) {
        this.bucketName = string;
        this.key = string2;
        this.file = file;
    }

    public PutObjectRequest(String string, String string2, String string3) {
        this.bucketName = string;
        this.key = string2;
        this.redirectLocation = string3;
    }

    public PutObjectRequest(String string, String string2, InputStream inputStream, ObjectMetadata objectMetadata) {
        this.bucketName = string;
        this.key = string2;
        this.inputStream = inputStream;
        this.metadata = objectMetadata;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String string) {
        this.bucketName = string;
    }

    public PutObjectRequest withBucketName(String string) {
        this.setBucketName(string);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public PutObjectRequest withKey(String string) {
        this.setKey(string);
        return this;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String string) {
        this.storageClass = string;
    }

    public PutObjectRequest withStorageClass(String string) {
        this.setStorageClass(string);
        return this;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass.toString();
    }

    public PutObjectRequest withStorageClass(StorageClass storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public PutObjectRequest withFile(File file) {
        this.setFile(file);
        return this;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ObjectMetadata objectMetadata) {
        this.metadata = objectMetadata;
    }

    public PutObjectRequest withMetadata(ObjectMetadata objectMetadata) {
        this.setMetadata(objectMetadata);
        return this;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAccessControlList) {
        this.cannedAcl = cannedAccessControlList;
    }

    public PutObjectRequest withCannedAcl(CannedAccessControlList cannedAccessControlList) {
        this.setCannedAcl(cannedAccessControlList);
        return this;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public PutObjectRequest withAccessControlList(AccessControlList accessControlList) {
        this.setAccessControlList(accessControlList);
        return this;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public PutObjectRequest withInputStream(InputStream inputStream) {
        this.setInputStream(inputStream);
        return this;
    }

    public void setRedirectLocation(String string) {
        this.redirectLocation = string;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public PutObjectRequest withRedirectLocation(String string) {
        this.redirectLocation = string;
        return this;
    }

    public SSECustomerKey getSSECustomerKey() {
        return this.sseCustomerKey;
    }

    public void setSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.sseCustomerKey = sSECustomerKey;
    }

    public PutObjectRequest withSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.setSSECustomerKey(sSECustomerKey);
        return this;
    }

    @Deprecated
    public void setProgressListener(ProgressListener progressListener) {
        this.generalProgressListener = new LegacyS3ProgressListener(progressListener);
    }

    @Deprecated
    public ProgressListener getProgressListener() {
        if (this.generalProgressListener instanceof LegacyS3ProgressListener) {
            return ((LegacyS3ProgressListener)this.generalProgressListener).unwrap();
        }
        return null;
    }

    @Deprecated
    public PutObjectRequest withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    public void setGeneralProgressListener(com.amazonaws.event.ProgressListener progressListener) {
        this.generalProgressListener = progressListener;
    }

    public com.amazonaws.event.ProgressListener getGeneralProgressListener() {
        return this.generalProgressListener;
    }

    public PutObjectRequest withGeneralProgressListener(com.amazonaws.event.ProgressListener progressListener) {
        this.setGeneralProgressListener(progressListener);
        return this;
    }

    public PutObjectRequest clone() {
        return (PutObjectRequest)new PutObjectRequest(this.bucketName, this.key, this.redirectLocation).withAccessControlList(this.accessControlList).withCannedAcl(this.cannedAcl).withFile(this.file).withGeneralProgressListener(this.generalProgressListener).withInputStream(this.inputStream).withMetadata(this.metadata == null ? null : this.metadata.clone()).withStorageClass(this.storageClass).withRequestMetricCollector(this.getRequestMetricCollector());
    }
}

