/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transfermanager;

import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.core.TreeNode;
import com.amazonaws.com.fasterxml.jackson.databind.JsonNode;
import com.amazonaws.com.fasterxml.jackson.databind.ObjectMapper;
import com.amazonaws.mobileconnectors.s3.transfermanager.PersistableDownload;
import com.amazonaws.mobileconnectors.s3.transfermanager.PersistableUpload;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.Jackson;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class PersistableTransfer {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public final String serialize() {
        return Jackson.toJsonString((Object)this);
    }

    public final void serialize(OutputStream outputStream) throws IOException {
        outputStream.write(Jackson.toJsonString((Object)this).getBytes(StringUtils.UTF8));
        outputStream.flush();
    }

    public static <T extends PersistableTransfer> T deserializeFrom(InputStream inputStream) {
        String string;
        Object object;
        JsonNode jsonNode;
        try {
            jsonNode = MAPPER.readTree(inputStream);
            object = jsonNode.get("pauseType");
            if (object == null) {
                throw new IllegalArgumentException("Unrecognized serialized state");
            }
            string = object.asText();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        if ("download".equals(string)) {
            object = PersistableDownload.class;
        } else if ("upload".equals(string)) {
            object = PersistableUpload.class;
        } else {
            throw new UnsupportedOperationException("Unsupported paused transfer type: " + string);
        }
        try {
            PersistableTransfer persistableTransfer = (PersistableTransfer)MAPPER.treeToValue((TreeNode)jsonNode, (Class)object);
            return (T)persistableTransfer;
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalStateException(jsonProcessingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PersistableTransfer> T deserializeFrom(String string) {
        if (string == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StringUtils.UTF8));
        T t = PersistableTransfer.deserializeFrom(byteArrayInputStream);
        return t;
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

