/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.mobileconnectors.s3.transferutility.UploadPartTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class TransferThreadPool {
    private static final int MAX_CONCURRENT_MAIN_THREADS_ALLOWED = 2;
    private static final int MAX_CONCURRENT_PART_THREADS_ALLOWED = 5;
    private static ExecutorService executorMainTask;
    private static ExecutorService executorPartTask;

    TransferThreadPool() {
    }

    private static synchronized void init() {
        if (executorMainTask == null) {
            executorMainTask = TransferThreadPool.buildExecutor(2);
        }
        if (executorPartTask == null) {
            executorPartTask = TransferThreadPool.buildExecutor(5);
        }
    }

    public static Future<Boolean> submitTask(Callable<Boolean> c) {
        TransferThreadPool.init();
        if (c instanceof UploadPartTask) {
            return executorPartTask.submit(c);
        }
        return executorMainTask.submit(c);
    }

    public static void closeThreadPool() {
        if (executorMainTask != null) {
            executorMainTask.shutdown();
            executorMainTask = null;
        }
        if (executorPartTask != null) {
            executorPartTask.shutdown();
            executorPartTask = null;
        }
    }

    private static ExecutorService buildExecutor(int maxThreadsAllowed) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(maxThreadsAllowed, maxThreadsAllowed, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }
}

