/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.crypto.AesCbc;
import com.amazonaws.services.s3.internal.crypto.AesCtr;
import com.amazonaws.services.s3.internal.crypto.AesGcm;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

abstract class ContentCryptoScheme {
    static final long MAX_GCM_BLOCKS = 0xFFFFFFFEL;
    static final long MAX_GCM_BYTES = 0xFFFFFFFE0L;
    static final long MAX_CBC_BYTES = 0x10000000000000L;
    static final long MAX_CTR_BYTES = -1L;
    static final ContentCryptoScheme AES_CBC = new AesCbc();
    static final ContentCryptoScheme AES_GCM = new AesGcm();
    static final ContentCryptoScheme AES_CTR = new AesCtr();

    ContentCryptoScheme() {
    }

    abstract String getKeyGeneratorAlgorithm();

    abstract String getCipherAlgorithm();

    String getSpecificCipherProvider() {
        return null;
    }

    abstract int getKeyLengthInBits();

    abstract int getBlockSizeInBytes();

    abstract int getIVLengthInBytes();

    int getTagLengthInBits() {
        return 0;
    }

    byte[] adjustIV(byte[] iv, long startingBytePos) {
        return iv;
    }

    public String toString() {
        return "cipherAlgo=" + this.getCipherAlgorithm() + ", blockSizeInBytes=" + this.getBlockSizeInBytes() + ", ivLengthInBytes=" + this.getIVLengthInBytes() + ", keyGenAlgo=" + this.getKeyGeneratorAlgorithm() + ", keyLengthInBits=" + this.getKeyLengthInBits() + ", specificProvider=" + this.getSpecificCipherProvider() + ", tagLengthInBits=" + this.getTagLengthInBits();
    }

    static byte[] incrementBlocks(byte[] counter, long blockDelta) {
        if (blockDelta == 0L) {
            return counter;
        }
        if (counter == null || counter.length != 16) {
            throw new IllegalArgumentException();
        }
        if (blockDelta > 0xFFFFFFFEL) {
            throw new IllegalStateException();
        }
        ByteBuffer bb = ByteBuffer.allocate(8);
        for (int i = 12; i <= 15; ++i) {
            bb.put(i - 8, counter[i]);
        }
        long val = bb.getLong() + blockDelta;
        if (val > 0xFFFFFFFEL) {
            throw new IllegalStateException();
        }
        bb.rewind();
        byte[] result = bb.putLong(val).array();
        for (int i = 12; i <= 15; ++i) {
            counter[i] = result[i - 8];
        }
        return counter;
    }

    static ContentCryptoScheme fromCEKAlgo(String cekAlgo) {
        return ContentCryptoScheme.fromCEKAlgo(cekAlgo, false);
    }

    static ContentCryptoScheme fromCEKAlgo(String cekAlgo, boolean isRangeGet) {
        if (AES_GCM.getCipherAlgorithm().equals(cekAlgo)) {
            return isRangeGet ? AES_CTR : AES_GCM;
        }
        if (cekAlgo == null || AES_CBC.getCipherAlgorithm().equals(cekAlgo)) {
            return AES_CBC;
        }
        throw new UnsupportedOperationException("Unsupported content encryption scheme: " + cekAlgo);
    }

    CipherLite createCipherLite(SecretKey cek, byte[] iv, int cipherMode, Provider securityProvider) {
        String specificProvider = this.getSpecificCipherProvider();
        try {
            Cipher cipher = specificProvider != null ? Cipher.getInstance(this.getCipherAlgorithm(), specificProvider) : (securityProvider != null ? Cipher.getInstance(this.getCipherAlgorithm(), securityProvider) : Cipher.getInstance(this.getCipherAlgorithm()));
            cipher.init(cipherMode, (Key)cek, new IvParameterSpec(iv));
            return this.newCipherLite(cipher, cek, cipherMode);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new AmazonClientException("Unable to build cipher: " + e.getMessage() + "\nMake sure you have the JCE unlimited strength policy files installed and configured for your JVM", (Throwable)e);
        }
    }

    protected CipherLite newCipherLite(Cipher cipher, SecretKey cek, int cipherMode) {
        return new CipherLite(cipher, this, cek, cipherMode);
    }

    CipherLite createAuxillaryCipher(SecretKey cek, byte[] iv, int cipherMode, Provider securityProvider, long startingBytePos) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return null;
    }

    CipherLite createCipherLite(SecretKey cek, byte[] iv, int cipherMode) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        return this.createCipherLite(cek, iv, cipherMode, null);
    }

    abstract long getMaxPlaintextSize();
}

