/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import com.amazonaws.mobileconnectors.s3.transferutility.S3ClientReference;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferThreadPool;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferType;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtilityOptions;
import com.amazonaws.services.s3.AmazonS3;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransferService
extends Service {
    private static final Log LOGGER = LogFactory.getLog(TransferService.class);
    private static final String TAG = TransferService.class.getSimpleName();
    static final int MSG_EXEC = 100;
    static final int MSG_CHECK = 200;
    static final int MSG_DISCONNECT = 300;
    static final int MSG_CONNECT = 400;
    static final String INTENT_ACTION_TRANSFER_ADD = "add_transfer";
    static final String INTENT_ACTION_TRANSFER_PAUSE = "pause_transfer";
    static final String INTENT_ACTION_TRANSFER_RESUME = "resume_transfer";
    static final String INTENT_ACTION_TRANSFER_CANCEL = "cancel_transfer";
    static final String INTENT_BUNDLE_TRANSFER_ID = "id";
    static final String INTENT_BUNDLE_TRANSFER_UTILITY_OPTIONS = "transfer_utility_options";
    static final TransferState[] UNFINISHED_TRANSFER_STATES = new TransferState[]{TransferState.WAITING, TransferState.WAITING_FOR_NETWORK, TransferState.IN_PROGRESS, TransferState.RESUMED_WAITING};
    private HandlerThread handlerThread;
    private Handler updateHandler;
    private NetworkInfoReceiver networkInfoReceiver;
    private boolean shouldScan = true;
    private boolean isReceiverNotRegistered = true;
    private volatile long lastActiveTime;
    private volatile int startId;
    private TransferDBUtil dbUtil;
    TransferStatusUpdater updater;
    private long transferServiceCheckTimeInterval;

    public IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException("Can't bind to TransferService");
    }

    public void onCreate() {
        super.onCreate();
        LOGGER.debug((Object)"Starting Transfer Service");
        this.dbUtil = new TransferDBUtil((Context)this);
        this.updater = new TransferStatusUpdater(this.dbUtil);
        this.handlerThread = new HandlerThread(TAG + "-AWSTransferUpdateHandlerThread");
        this.handlerThread.start();
        this.setHandlerLooper(this.handlerThread.getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(Intent intent, int flags, int startId) {
        this.startId = startId;
        if (this.isReceiverNotRegistered) {
            try {
                LOGGER.info((Object)"registering receiver");
                this.registerReceiver(this.networkInfoReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
            }
            catch (IllegalArgumentException iae) {
                LOGGER.warn((Object)"Ignoring the exception trying to register the receiver for connectivity change.");
            }
            catch (IllegalStateException ise) {
                LOGGER.warn((Object)"Ignoring the leak in registering the receiver.");
            }
            finally {
                this.isReceiverNotRegistered = false;
            }
        }
        if (intent == null) {
            return 3;
        }
        Integer id = intent.getIntExtra(INTENT_BUNDLE_TRANSFER_ID, -1);
        if (id < 0) {
            LOGGER.error((Object)"The intent sent by the TransferUtility doesn't have the id.");
            return 2;
        }
        AmazonS3 s3 = S3ClientReference.get(id);
        if (s3 == null) {
            LOGGER.error((Object)"TransferService can't get s3 client and not acting on the id.");
            return 2;
        }
        TransferUtilityOptions tuOptions = (TransferUtilityOptions)intent.getSerializableExtra(INTENT_BUNDLE_TRANSFER_UTILITY_OPTIONS);
        if (tuOptions != null) {
            TransferThreadPool.init(tuOptions.getTransferThreadPoolSize());
            this.transferServiceCheckTimeInterval = tuOptions.getTransferServiceCheckTimeInterval();
            LOGGER.debug((Object)("ThreadPoolSize: " + tuOptions.getTransferThreadPoolSize() + " transferServiceCheckTimeInterval: " + tuOptions.getTransferServiceCheckTimeInterval()));
        } else {
            TransferThreadPool.init(TransferUtilityOptions.getDefaultThreadPoolSize());
            this.transferServiceCheckTimeInterval = TransferUtilityOptions.getDefaultCheckTimeInterval();
        }
        this.updateHandler.sendMessage(this.updateHandler.obtainMessage(100, (Object)intent));
        return 2;
    }

    public void onDestroy() {
        try {
            if (this.networkInfoReceiver != null) {
                LOGGER.info((Object)"unregistering receiver");
                this.unregisterReceiver(this.networkInfoReceiver);
                this.isReceiverNotRegistered = true;
            }
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn((Object)"exception trying to destroy the service");
        }
        this.pauseAll();
        this.handlerThread.quit();
        TransferThreadPool.closeThreadPool();
        S3ClientReference.clear();
        LOGGER.info((Object)"Closing the database.");
        this.dbUtil.closeDB();
        super.onDestroy();
    }

    void checkTransfers() {
        if (this.shouldScan && this.networkInfoReceiver.isNetworkConnected()) {
            this.loadAndResumeTransfersFromDB(UNFINISHED_TRANSFER_STATES);
            this.shouldScan = false;
        }
        if (this.isActive()) {
            this.lastActiveTime = System.currentTimeMillis();
            this.updateHandler.sendEmptyMessageDelayed(200, this.transferServiceCheckTimeInterval);
        } else {
            LOGGER.debug((Object)"Stop self");
            this.stopSelf(this.startId);
        }
    }

    void checkTransfersOnNetworkReconnect() {
        if (this.networkInfoReceiver.isNetworkConnected()) {
            this.loadAndResumeTransfersFromDB(new TransferState[]{TransferState.WAITING_FOR_NETWORK});
        } else {
            LOGGER.error((Object)"Network Connect message received but not connected to network.");
        }
    }

    void execCommand(Intent intent) {
        this.lastActiveTime = System.currentTimeMillis();
        String action = intent.getAction();
        Integer id = intent.getIntExtra(INTENT_BUNDLE_TRANSFER_ID, 0);
        AmazonS3 s3 = S3ClientReference.get(id);
        if (!TransferDBUtil.getTransferDBBase().getDatabase().isOpen()) {
            LOGGER.debug((Object)"Database is not open. Opening the database before proceeding.");
            this.dbUtil = new TransferDBUtil((Context)this);
        }
        if (INTENT_ACTION_TRANSFER_ADD.equals(action)) {
            if (this.updater.getTransfer(id) != null) {
                LOGGER.warn((Object)("Transfer has already been added: " + id));
            } else {
                TransferRecord transfer = this.dbUtil.getTransferById(id);
                if (transfer != null) {
                    this.updater.addTransfer(transfer);
                    transfer.start(s3, this.dbUtil, this.updater, this.networkInfoReceiver);
                } else {
                    LOGGER.error((Object)("Can't find transfer: " + id));
                }
            }
        } else if (INTENT_ACTION_TRANSFER_PAUSE.equals(action)) {
            TransferRecord transfer = this.updater.getTransfer(id);
            if (transfer == null) {
                transfer = this.dbUtil.getTransferById(id);
            }
            if (transfer != null) {
                transfer.pause(s3, this.updater);
            }
        } else if (INTENT_ACTION_TRANSFER_RESUME.equals(action)) {
            TransferRecord transfer = this.updater.getTransfer(id);
            if (transfer == null) {
                transfer = this.dbUtil.getTransferById(id);
                if (transfer != null) {
                    this.updater.addTransfer(transfer);
                } else {
                    LOGGER.error((Object)("Can't find transfer: " + id));
                }
            }
            if (transfer != null) {
                transfer.start(s3, this.dbUtil, this.updater, this.networkInfoReceiver);
            }
        } else if (INTENT_ACTION_TRANSFER_CANCEL.equals(action)) {
            TransferRecord transfer = this.updater.getTransfer(id);
            if (transfer == null) {
                transfer = this.dbUtil.getTransferById(id);
            }
            if (transfer != null) {
                transfer.cancel(s3, this.updater);
            }
        } else {
            LOGGER.error((Object)("Unknown action: " + action));
        }
    }

    private boolean isActive() {
        if (this.shouldScan) {
            return true;
        }
        for (TransferRecord transfer : this.updater.getTransfers().values()) {
            if (!transfer.isRunning()) continue;
            return true;
        }
        return System.currentTimeMillis() - this.lastActiveTime < this.transferServiceCheckTimeInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadAndResumeTransfersFromDB(TransferState[] transferStates) {
        LOGGER.debug((Object)"Loading transfers from database...");
        Cursor c = null;
        int count = 0;
        try {
            c = this.dbUtil.queryTransfersWithTypeAndStates(TransferType.ANY, transferStates);
            while (c.moveToNext()) {
                TransferRecord transfer;
                int id = c.getInt(c.getColumnIndexOrThrow("_id"));
                int partNumber = c.getInt(c.getColumnIndexOrThrow("part_num"));
                AmazonS3 s3 = S3ClientReference.get(id);
                if (s3 == null) {
                    LOGGER.warn((Object)("Cannot find the S3 Client for the transfer: " + id + " Resume the transfer manually."));
                    continue;
                }
                if (partNumber != 0) continue;
                if (this.updater.getTransfer(id) == null) {
                    transfer = new TransferRecord(id);
                    transfer.updateFromDB(c);
                    if (!transfer.start(s3, this.dbUtil, this.updater, this.networkInfoReceiver)) continue;
                    this.updater.addTransfer(transfer);
                    ++count;
                    continue;
                }
                transfer = this.updater.getTransfer(id);
                if (transfer.isRunning()) continue;
                transfer.start(s3, this.dbUtil, this.updater, this.networkInfoReceiver);
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        LOGGER.debug((Object)(count + " transfers are loaded from database"));
    }

    void pauseAll() {
        for (TransferRecord transferRecord : this.updater.getTransfers().values()) {
            AmazonS3 s3 = S3ClientReference.get(transferRecord.id);
            if (s3 == null || transferRecord == null) continue;
            transferRecord.pause(s3, this.updater);
        }
    }

    void pauseAllForNetwork() {
        for (TransferRecord transferRecord : this.updater.getTransfers().values()) {
            AmazonS3 s3 = S3ClientReference.get(transferRecord.id);
            if (s3 == null || transferRecord == null || !transferRecord.pause(s3, this.updater)) continue;
            this.updater.updateState(transferRecord.id, TransferState.WAITING_FOR_NETWORK);
        }
        this.shouldScan = true;
    }

    void setHandlerLooper(Looper looper) {
        this.updateHandler = new UpdateHandler(looper);
        this.networkInfoReceiver = new NetworkInfoReceiver(this.getApplicationContext(), this.updateHandler);
    }

    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        if ((this.getApplicationInfo().flags & 2) == 0) {
            return;
        }
        writer.printf("start id: %d\n", this.startId);
        writer.printf("network status: %s\n", this.networkInfoReceiver.isNetworkConnected());
        writer.printf("lastActiveTime: %s, shouldScan: %s\n", new Date(this.lastActiveTime), this.shouldScan);
        Map<Integer, TransferRecord> transfers = this.updater.getTransfers();
        writer.printf("# of active transfers: %d\n", transfers.size());
        for (TransferRecord transfer : transfers.values()) {
            writer.printf("bucket: %s, key: %s, status: %s, total size: %d, current: %d\n", new Object[]{transfer.bucketName, transfer.key, transfer.state, transfer.bytesTotal, transfer.bytesCurrent});
        }
        writer.flush();
    }

    class UpdateHandler
    extends Handler {
        public UpdateHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 200) {
                TransferService.this.updateHandler.removeMessages(200);
                TransferService.this.checkTransfers();
            } else if (msg.what == 100) {
                TransferService.this.execCommand((Intent)msg.obj);
            } else if (msg.what == 300) {
                TransferService.this.pauseAllForNetwork();
            } else if (msg.what == 400) {
                TransferService.this.checkTransfersOnNetworkReconnect();
            } else {
                LOGGER.error((Object)("Unknown command: " + msg.what));
            }
        }
    }

    static class NetworkInfoReceiver
    extends BroadcastReceiver {
        private final Handler handler;
        private final ConnectivityManager connManager;

        public NetworkInfoReceiver(Context context, Handler handler) {
            this.handler = handler;
            this.connManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                boolean networkConnected = this.isNetworkConnected();
                LOGGER.debug((Object)("Network connected: " + networkConnected));
                this.handler.sendEmptyMessage(networkConnected ? 400 : 300);
            }
        }

        boolean isNetworkConnected() {
            NetworkInfo info = this.connManager.getActiveNetworkInfo();
            return info != null && info.isConnected();
        }
    }
}

