/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.mobileconnectors.s3.transferutility.S3ClientReference;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferObserver;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferService;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferType;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtilityOptions;
import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class TransferUtility {
    private static final Log LOGGER = LogFactory.getLog(TransferUtility.class);
    static final int MINIMUM_UPLOAD_PART_SIZE = 0x500000;
    private static String userAgentFromConfig = "";
    private final AmazonS3 s3;
    private final Context appContext;
    private final TransferDBUtil dbUtil;
    private final String defaultBucket;
    private final TransferUtilityOptions transferUtilityOptions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setUserAgentFromConfig(String userAgent) {
        String string = userAgentFromConfig;
        synchronized (string) {
            userAgentFromConfig = userAgent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUserAgentFromConfig() {
        String string = userAgentFromConfig;
        synchronized (string) {
            if (userAgentFromConfig == null || userAgentFromConfig.trim().isEmpty()) {
                return "";
            }
            return userAgentFromConfig.trim() + "/";
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private TransferUtility(AmazonS3 s3, Context context, String defaultBucket, TransferUtilityOptions tuOptions) {
        this.s3 = s3;
        this.appContext = context.getApplicationContext();
        this.dbUtil = new TransferDBUtil(this.appContext);
        this.defaultBucket = defaultBucket;
        this.transferUtilityOptions = tuOptions;
    }

    @Deprecated
    public TransferUtility(AmazonS3 s3, Context context) {
        this.s3 = s3;
        this.appContext = context.getApplicationContext();
        this.dbUtil = new TransferDBUtil(this.appContext);
        this.defaultBucket = null;
        this.transferUtilityOptions = new TransferUtilityOptions();
    }

    private String getDefaultBucketOrThrow() {
        if (this.defaultBucket == null) {
            throw new IllegalArgumentException("TransferUtility has not been configured with a default bucket. Please use the corresponding method that specifies bucket name or configure the default bucket name in construction of the object. See TransferUtility.builder().defaultBucket() or TransferUtility.builder().awsConfiguration()");
        }
        return this.defaultBucket;
    }

    public TransferObserver download(String bucket, String key, File file) {
        return this.download(bucket, key, file, null);
    }

    public TransferObserver download(String key, File file) {
        return this.download(this.getDefaultBucketOrThrow(), key, file, null);
    }

    public TransferObserver download(String bucket, String key, File file, TransferListener listener) {
        if (file == null || file.isDirectory()) {
            throw new IllegalArgumentException("Invalid file: " + file);
        }
        Uri uri = this.dbUtil.insertSingleTransferRecord(TransferType.DOWNLOAD, bucket, key, file);
        int recordId = Integer.parseInt(uri.getLastPathSegment());
        if (file.isFile()) {
            LOGGER.warn((Object)("Overwrite existing file: " + file));
            file.delete();
        }
        this.sendIntent("add_transfer", recordId);
        return new TransferObserver(recordId, this.dbUtil, bucket, key, file, listener);
    }

    public TransferObserver download(String key, File file, TransferListener listener) {
        return this.download(this.getDefaultBucketOrThrow(), key, file, listener);
    }

    public TransferObserver upload(String bucket, String key, File file) {
        return this.upload(bucket, key, file, new ObjectMetadata());
    }

    public TransferObserver upload(String key, File file) {
        return this.upload(this.getDefaultBucketOrThrow(), key, file, new ObjectMetadata());
    }

    public TransferObserver upload(String bucket, String key, File file, CannedAccessControlList cannedAcl) {
        return this.upload(bucket, key, file, new ObjectMetadata(), cannedAcl);
    }

    public TransferObserver upload(String key, File file, CannedAccessControlList cannedAcl) {
        return this.upload(this.getDefaultBucketOrThrow(), key, file, new ObjectMetadata(), cannedAcl);
    }

    public TransferObserver upload(String bucket, String key, File file, ObjectMetadata metadata) {
        return this.upload(bucket, key, file, metadata, null);
    }

    public TransferObserver upload(String key, File file, ObjectMetadata metadata) {
        return this.upload(this.getDefaultBucketOrThrow(), key, file, metadata, null);
    }

    public TransferObserver upload(String bucket, String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl) {
        return this.upload(bucket, key, file, metadata, cannedAcl, null);
    }

    public TransferObserver upload(String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl) {
        return this.upload(this.getDefaultBucketOrThrow(), key, file, metadata, cannedAcl, null);
    }

    public TransferObserver upload(String bucket, String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl, TransferListener listener) {
        if (file == null || file.isDirectory() || !file.exists()) {
            throw new IllegalArgumentException("Invalid file: " + file);
        }
        int recordId = 0;
        if (this.shouldUploadInMultipart(file)) {
            recordId = this.createMultipartUploadRecords(bucket, key, file, metadata, cannedAcl);
        } else {
            Uri uri = this.dbUtil.insertSingleTransferRecord(TransferType.UPLOAD, bucket, key, file, metadata, cannedAcl);
            recordId = Integer.parseInt(uri.getLastPathSegment());
        }
        this.sendIntent("add_transfer", recordId);
        return new TransferObserver(recordId, this.dbUtil, bucket, key, file, listener);
    }

    public TransferObserver upload(String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl, TransferListener listener) {
        return this.upload(this.getDefaultBucketOrThrow(), key, file, metadata, cannedAcl, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferObserver getTransferById(int id) {
        Cursor c = null;
        try {
            c = this.dbUtil.queryTransferById(id);
            if (c.moveToNext()) {
                TransferObserver to = new TransferObserver(id, this.dbUtil);
                to.updateFromDB(c);
                TransferObserver transferObserver = to;
                return transferObserver;
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransferObserver> getTransfersWithType(TransferType type) {
        ArrayList<TransferObserver> transferObservers = new ArrayList<TransferObserver>();
        Cursor c = null;
        try {
            c = this.dbUtil.queryAllTransfersWithType(type);
            while (c.moveToNext()) {
                int id = c.getInt(c.getColumnIndexOrThrow("_id"));
                TransferObserver to = new TransferObserver(id, this.dbUtil);
                to.updateFromDB(c);
                transferObservers.add(to);
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return transferObservers;
    }

    public List<TransferObserver> getTransfersWithTypeAndState(TransferType type, TransferState state) {
        return this.getTransfersWithTypeAndStates(type, new TransferState[]{state});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransferObserver> getTransfersWithTypeAndStates(TransferType type, TransferState[] states) {
        ArrayList<TransferObserver> transferObservers = new ArrayList<TransferObserver>();
        Cursor c = null;
        try {
            c = this.dbUtil.queryTransfersWithTypeAndStates(type, states);
            while (c.moveToNext()) {
                int partNum = c.getInt(c.getColumnIndexOrThrow("part_num"));
                if (partNum != 0) continue;
                int id = c.getInt(c.getColumnIndexOrThrow("_id"));
                TransferObserver to = new TransferObserver(id, this.dbUtil);
                to.updateFromDB(c);
                transferObservers.add(to);
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return transferObservers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> getTransferIdsWithTypeAndStates(TransferType type, TransferState[] states) {
        ArrayList<Integer> transferIds = new ArrayList<Integer>();
        Cursor c = null;
        try {
            c = this.dbUtil.queryTransfersWithTypeAndStates(type, states);
            while (c.moveToNext()) {
                int partNum = c.getInt(c.getColumnIndexOrThrow("part_num"));
                if (partNum != 0) continue;
                int id = c.getInt(c.getColumnIndexOrThrow("_id"));
                transferIds.add(id);
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return transferIds;
    }

    private int createMultipartUploadRecords(String bucket, String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl) {
        long remainingLenth = file.length();
        double partSize = (double)remainingLenth / 10000.0;
        partSize = Math.ceil(partSize);
        long optimalPartSize = (long)Math.max(partSize, 5242880.0);
        long fileOffset = 0L;
        int partNumber = 1;
        int partCount = (int)Math.ceil((double)remainingLenth / (double)optimalPartSize);
        ContentValues[] valuesArray = new ContentValues[partCount + 1];
        valuesArray[0] = this.dbUtil.generateContentValuesForMultiPartUpload(bucket, key, file, fileOffset, 0, "", file.length(), 0, metadata, cannedAcl);
        for (int i = 1; i < partCount + 1; ++i) {
            long bytesForPart = Math.min(optimalPartSize, remainingLenth);
            valuesArray[i] = this.dbUtil.generateContentValuesForMultiPartUpload(bucket, key, file, fileOffset, partNumber, "", bytesForPart, remainingLenth - optimalPartSize <= 0L ? 1 : 0, metadata, cannedAcl);
            fileOffset += optimalPartSize;
            remainingLenth -= optimalPartSize;
            ++partNumber;
        }
        return this.dbUtil.bulkInsertTransferRecords(valuesArray);
    }

    public boolean pause(int id) {
        this.sendIntent("pause_transfer", id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAllWithType(TransferType type) {
        Cursor c = null;
        try {
            c = this.dbUtil.queryAllTransfersWithType(type);
            while (c.moveToNext()) {
                int id = c.getInt(c.getColumnIndexOrThrow("_id"));
                this.pause(id);
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    public TransferObserver resume(int id) {
        this.sendIntent("resume_transfer", id);
        return this.getTransferById(id);
    }

    public List<TransferObserver> resumeAllWithType(TransferType type) {
        ArrayList<TransferObserver> observers = new ArrayList<TransferObserver>();
        List<Integer> transferIds = this.getTransferIdsWithTypeAndStates(type, new TransferState[]{TransferState.PAUSED, TransferState.FAILED, TransferState.CANCELED});
        for (Integer transferId : transferIds) {
            observers.add(this.resume(transferId));
        }
        return observers;
    }

    public boolean cancel(int id) {
        this.sendIntent("cancel_transfer", id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllWithType(TransferType type) {
        Cursor c = null;
        try {
            c = this.dbUtil.queryAllTransfersWithType(type);
            while (c.moveToNext()) {
                int id = c.getInt(c.getColumnIndexOrThrow("_id"));
                this.cancel(id);
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    public boolean deleteTransferRecord(int id) {
        this.cancel(id);
        return this.dbUtil.deleteTransferRecords(id) > 0;
    }

    private synchronized void sendIntent(String action, int id) {
        S3ClientReference.put(id, this.s3);
        Intent intent = new Intent(this.appContext, TransferService.class);
        intent.setAction(action);
        intent.putExtra("id", id);
        intent.putExtra("transfer_utility_options", (Serializable)this.transferUtilityOptions);
        this.appContext.startService(intent);
    }

    private boolean shouldUploadInMultipart(File file) {
        return file != null && file.length() > 0x500000L;
    }

    static <X extends AmazonWebServiceRequest> X appendTransferServiceUserAgentString(X request) {
        request.getRequestClientOptions().appendUserAgent("TransferService/" + TransferUtility.getUserAgentFromConfig() + VersionInfoUtils.getVersion());
        return request;
    }

    static <X extends AmazonWebServiceRequest> X appendMultipartTransferServiceUserAgentString(X request) {
        request.getRequestClientOptions().appendUserAgent("TransferService_multipart/" + TransferUtility.getUserAgentFromConfig() + VersionInfoUtils.getVersion());
        return request;
    }

    TransferDBUtil getDbUtil() {
        return this.dbUtil;
    }

    public static class Builder {
        private AmazonS3 s3;
        private Context appContext;
        private String defaultBucket;
        private AWSConfiguration awsConfig;
        private TransferUtilityOptions transferUtilityOptions;

        protected Builder() {
        }

        public Builder s3Client(AmazonS3 s3Client) {
            this.s3 = s3Client;
            return this;
        }

        public Builder context(Context applicationContext) {
            this.appContext = applicationContext.getApplicationContext();
            return this;
        }

        public Builder defaultBucket(String bucket) {
            this.defaultBucket = bucket;
            return this;
        }

        public Builder awsConfiguration(AWSConfiguration awsConfiguration) {
            this.awsConfig = awsConfiguration;
            return this;
        }

        public Builder transferUtilityOptions(TransferUtilityOptions tuOptions) {
            this.transferUtilityOptions = tuOptions;
            return this;
        }

        public TransferUtility build() {
            if (this.s3 == null) {
                throw new IllegalArgumentException("AmazonS3 client is required please set using .s3Client(yourClient)");
            }
            if (this.appContext == null) {
                throw new IllegalArgumentException("Context is required please set using .context(applicationContext)");
            }
            if (this.awsConfig != null) {
                try {
                    JSONObject tuConfig = this.awsConfig.optJsonObject("S3TransferUtility");
                    this.s3.setRegion(Region.getRegion((String)tuConfig.getString("Region")));
                    this.defaultBucket = tuConfig.getString("Bucket");
                    TransferUtility.setUserAgentFromConfig(this.awsConfig.getUserAgent());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to read S3TransferUtility please check your setup or awsconfiguration.json file", e);
                }
            }
            if (this.transferUtilityOptions == null) {
                this.transferUtilityOptions = new TransferUtilityOptions();
            }
            return new TransferUtility(this.s3, this.appContext, this.defaultBucket, this.transferUtilityOptions);
        }
    }
}

