/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.services.simpledb.model.Item;
import com.amazonaws.services.simpledb.model.transform.AttributeStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class ItemStaxUnmarshaller
implements Unmarshaller<Item, StaxUnmarshallerContext> {
    private static ItemStaxUnmarshaller instance;

    public Item unmarshall(StaxUnmarshallerContext context) throws Exception {
        Item item = new Item();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return item;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("Name", targetDepth)) {
                    item.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Name/@encoding", targetDepth)) {
                    item.setAlternateNameEncoding(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Attribute", targetDepth)) continue;
                item.getAttributes().add(AttributeStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return item;
    }

    public static ItemStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ItemStaxUnmarshaller();
        }
        return instance;
    }
}

