/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sns.model.MessageAttributeValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PublishRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String topicArn;
    private String targetArn;
    private String phoneNumber;
    private String message;
    private String subject;
    private String messageStructure;
    private Map<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>();
    private String messageDeduplicationId;
    private String messageGroupId;

    public PublishRequest() {
    }

    public PublishRequest(String topicArn, String message) {
        this.setTopicArn(topicArn);
        this.setMessage(message);
    }

    public PublishRequest(String topicArn, String message, String subject) {
        this.setTopicArn(topicArn);
        this.setMessage(message);
        this.setSubject(subject);
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }

    public PublishRequest withTopicArn(String topicArn) {
        this.topicArn = topicArn;
        return this;
    }

    public String getTargetArn() {
        return this.targetArn;
    }

    public void setTargetArn(String targetArn) {
        this.targetArn = targetArn;
    }

    public PublishRequest withTargetArn(String targetArn) {
        this.targetArn = targetArn;
        return this;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public PublishRequest withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public PublishRequest withMessage(String message) {
        this.message = message;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public PublishRequest withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getMessageStructure() {
        return this.messageStructure;
    }

    public void setMessageStructure(String messageStructure) {
        this.messageStructure = messageStructure;
    }

    public PublishRequest withMessageStructure(String messageStructure) {
        this.messageStructure = messageStructure;
        return this;
    }

    public Map<String, MessageAttributeValue> getMessageAttributes() {
        return this.messageAttributes;
    }

    public void setMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        this.messageAttributes = messageAttributes;
    }

    public PublishRequest withMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        this.messageAttributes = messageAttributes;
        return this;
    }

    public PublishRequest addMessageAttributesEntry(String key, MessageAttributeValue value) {
        if (null == this.messageAttributes) {
            this.messageAttributes = new HashMap<String, MessageAttributeValue>();
        }
        if (this.messageAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.messageAttributes.put(key, value);
        return this;
    }

    public PublishRequest clearMessageAttributesEntries() {
        this.messageAttributes = null;
        return this;
    }

    public String getMessageDeduplicationId() {
        return this.messageDeduplicationId;
    }

    public void setMessageDeduplicationId(String messageDeduplicationId) {
        this.messageDeduplicationId = messageDeduplicationId;
    }

    public PublishRequest withMessageDeduplicationId(String messageDeduplicationId) {
        this.messageDeduplicationId = messageDeduplicationId;
        return this;
    }

    public String getMessageGroupId() {
        return this.messageGroupId;
    }

    public void setMessageGroupId(String messageGroupId) {
        this.messageGroupId = messageGroupId;
    }

    public PublishRequest withMessageGroupId(String messageGroupId) {
        this.messageGroupId = messageGroupId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTopicArn() != null) {
            sb.append("TopicArn: " + this.getTopicArn() + ",");
        }
        if (this.getTargetArn() != null) {
            sb.append("TargetArn: " + this.getTargetArn() + ",");
        }
        if (this.getPhoneNumber() != null) {
            sb.append("PhoneNumber: " + this.getPhoneNumber() + ",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: " + this.getMessage() + ",");
        }
        if (this.getSubject() != null) {
            sb.append("Subject: " + this.getSubject() + ",");
        }
        if (this.getMessageStructure() != null) {
            sb.append("MessageStructure: " + this.getMessageStructure() + ",");
        }
        if (this.getMessageAttributes() != null) {
            sb.append("MessageAttributes: " + this.getMessageAttributes() + ",");
        }
        if (this.getMessageDeduplicationId() != null) {
            sb.append("MessageDeduplicationId: " + this.getMessageDeduplicationId() + ",");
        }
        if (this.getMessageGroupId() != null) {
            sb.append("MessageGroupId: " + this.getMessageGroupId());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTopicArn() == null ? 0 : this.getTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getTargetArn() == null ? 0 : this.getTargetArn().hashCode());
        hashCode = 31 * hashCode + (this.getPhoneNumber() == null ? 0 : this.getPhoneNumber().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getSubject() == null ? 0 : this.getSubject().hashCode());
        hashCode = 31 * hashCode + (this.getMessageStructure() == null ? 0 : this.getMessageStructure().hashCode());
        hashCode = 31 * hashCode + (this.getMessageAttributes() == null ? 0 : this.getMessageAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getMessageDeduplicationId() == null ? 0 : this.getMessageDeduplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getMessageGroupId() == null ? 0 : this.getMessageGroupId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest)obj;
        if (other.getTopicArn() == null ^ this.getTopicArn() == null) {
            return false;
        }
        if (other.getTopicArn() != null && !other.getTopicArn().equals(this.getTopicArn())) {
            return false;
        }
        if (other.getTargetArn() == null ^ this.getTargetArn() == null) {
            return false;
        }
        if (other.getTargetArn() != null && !other.getTargetArn().equals(this.getTargetArn())) {
            return false;
        }
        if (other.getPhoneNumber() == null ^ this.getPhoneNumber() == null) {
            return false;
        }
        if (other.getPhoneNumber() != null && !other.getPhoneNumber().equals(this.getPhoneNumber())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getSubject() == null ^ this.getSubject() == null) {
            return false;
        }
        if (other.getSubject() != null && !other.getSubject().equals(this.getSubject())) {
            return false;
        }
        if (other.getMessageStructure() == null ^ this.getMessageStructure() == null) {
            return false;
        }
        if (other.getMessageStructure() != null && !other.getMessageStructure().equals(this.getMessageStructure())) {
            return false;
        }
        if (other.getMessageAttributes() == null ^ this.getMessageAttributes() == null) {
            return false;
        }
        if (other.getMessageAttributes() != null && !other.getMessageAttributes().equals(this.getMessageAttributes())) {
            return false;
        }
        if (other.getMessageDeduplicationId() == null ^ this.getMessageDeduplicationId() == null) {
            return false;
        }
        if (other.getMessageDeduplicationId() != null && !other.getMessageDeduplicationId().equals(this.getMessageDeduplicationId())) {
            return false;
        }
        if (other.getMessageGroupId() == null ^ this.getMessageGroupId() == null) {
            return false;
        }
        return other.getMessageGroupId() == null || other.getMessageGroupId().equals(this.getMessageGroupId());
    }
}

