/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.AddPermissionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class AddPermissionRequestMarshaller
implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {
    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {
        String prefix;
        if (addPermissionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AddPermissionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addPermissionRequest, "AmazonSNS");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2010-03-31");
        if (addPermissionRequest.getTopicArn() != null) {
            prefix = "TopicArn";
            String topicArn = addPermissionRequest.getTopicArn();
            request.addParameter(prefix, StringUtils.fromString((String)topicArn));
        }
        if (addPermissionRequest.getLabel() != null) {
            prefix = "Label";
            String label = addPermissionRequest.getLabel();
            request.addParameter(prefix, StringUtils.fromString((String)label));
        }
        if (addPermissionRequest.getAWSAccountIds() != null) {
            prefix = "AWSAccountId";
            List<String> aWSAccountIds = addPermissionRequest.getAWSAccountIds();
            int aWSAccountIdsIndex = 1;
            String aWSAccountIdsPrefix = prefix;
            for (String aWSAccountIdsItem : aWSAccountIds) {
                prefix = aWSAccountIdsPrefix + ".member." + aWSAccountIdsIndex;
                if (aWSAccountIdsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)aWSAccountIdsItem));
                }
                ++aWSAccountIdsIndex;
            }
            prefix = aWSAccountIdsPrefix;
        }
        if (addPermissionRequest.getActionNames() != null) {
            prefix = "ActionName";
            List<String> actionNames = addPermissionRequest.getActionNames();
            int actionNamesIndex = 1;
            String actionNamesPrefix = prefix;
            for (String actionNamesItem : actionNames) {
                prefix = actionNamesPrefix + ".member." + actionNamesIndex;
                if (actionNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)actionNamesItem));
                }
                ++actionNamesIndex;
            }
            String string = actionNamesPrefix;
        }
        return request;
    }
}

